/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Rectangle;
import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.shape.ShapeRenderer;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.Viewer;

class RepaintManager {
    private Viewer viewer;
    private ShapeManager shapeManager;
    private int holdRepaint = 0;
    boolean repaintPending;
    private boolean logTime;
    private ShapeRenderer[] renderers;
    private BitSet bsAtoms;
    private Point3f ptOffset = new Point3f();

    RepaintManager(Viewer viewer, ShapeManager shapeManager) {
        this.viewer = viewer;
        this.shapeManager = shapeManager;
    }

    void clear() {
        this.clear(-1);
    }

    void pushHoldRepaint() {
        ++this.holdRepaint;
    }

    void popHoldRepaint(boolean bl) {
        --this.holdRepaint;
        if (this.holdRepaint <= 0) {
            this.holdRepaint = 0;
            if (bl) {
                this.repaintPending = true;
                this.viewer.repaint();
            }
        }
    }

    boolean refresh() {
        if (this.repaintPending) {
            return false;
        }
        this.repaintPending = true;
        if (this.holdRepaint == 0) {
            this.viewer.repaint();
        }
        return true;
    }

    synchronized void requestRepaintAndWait() {
        this.viewer.repaint();
        try {
            this.wait(this.viewer.getRepaintWait());
            if (this.repaintPending) {
                Logger.error("repaintManager requestRepaintAndWait timeout");
                this.repaintDone();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void repaintDone() {
        this.repaintPending = false;
        this.notify();
    }

    void render(Graphics3D graphics3D, ModelSet modelSet) {
        this.render1(graphics3D, modelSet);
        Rectangle rectangle = this.viewer.getRubberBandSelection();
        if (rectangle != null && graphics3D.setColix(this.viewer.getColixRubberband())) {
            graphics3D.drawRect(rectangle.x, rectangle.y, 0, 0, rectangle.width, rectangle.height);
        }
    }

    private void render1(Graphics3D graphics3D, ModelSet modelSet) {
        if (modelSet == null || !this.viewer.mustRenderFlag()) {
            return;
        }
        if (this.logTime) {
            Logger.startTimer();
        }
        this.logTime = this.viewer.getTestFlag1();
        this.viewer.finalizeTransformParameters();
        try {
            if (this.bsAtoms != null) {
                this.translateSelected();
            }
            graphics3D.renderBackground();
            if (this.renderers == null) {
                this.renderers = new ShapeRenderer[34];
            }
            for (int i = 0; i < 34 && graphics3D.currentlyRendering(); ++i) {
                Shape shape = this.shapeManager.getShape(i);
                if (shape == null) continue;
                this.getRenderer(i, graphics3D).render(graphics3D, modelSet, shape);
                if (!this.logTime) continue;
                Logger.checkTimer("render time " + JmolConstants.getShapeClassName(i));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.error("rendering error? ");
        }
        if (this.logTime) {
            Logger.checkTimer("render time");
        }
    }

    void clear(int n) {
        if (this.renderers == null) {
            return;
        }
        if (n >= 0) {
            this.renderers[n] = null;
        } else {
            for (int i = 0; i < 34; ++i) {
                this.renderers[i] = null;
            }
        }
    }

    private ShapeRenderer getRenderer(int n, Graphics3D graphics3D) {
        if (this.renderers[n] == null) {
            this.renderers[n] = this.allocateRenderer(n, graphics3D);
        }
        return this.renderers[n];
    }

    private ShapeRenderer allocateRenderer(int n, Graphics3D graphics3D) {
        String string = JmolConstants.getShapeClassName(n) + "Renderer";
        try {
            Class<?> clazz = Class.forName(string);
            ShapeRenderer shapeRenderer = (ShapeRenderer)clazz.newInstance();
            shapeRenderer.setViewerG3dShapeID(this.viewer, graphics3D, n);
            return shapeRenderer;
        }
        catch (Exception exception) {
            Logger.error("Could not instantiate renderer:" + string, exception);
            return null;
        }
    }

    String generateOutput(String string, Graphics3D graphics3D, ModelSet modelSet, String string2) {
        JmolRendererInterface jmolRendererInterface = null;
        CharSequence charSequence = null;
        boolean bl = false;
        try {
            charSequence = string2 == null ? new StringBuffer() : string2;
            Class<?> clazz = Class.forName("org.jmol.export.Export3D");
            jmolRendererInterface = (JmolRendererInterface)clazz.newInstance();
            bl = jmolRendererInterface.initializeExporter(string, this.viewer, graphics3D, charSequence);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            Logger.error("Cannot export " + string);
            return null;
        }
        jmolRendererInterface.renderBackground();
        for (int i = 0; i < 34; ++i) {
            Shape shape = this.shapeManager.getShape(i);
            if (shape == null) continue;
            this.getRenderer(i, graphics3D).render(jmolRendererInterface, modelSet, shape);
        }
        return jmolRendererInterface.finalizeOutput();
    }

    void setSelectedTranslation(BitSet bitSet, char c, int n) {
        this.bsAtoms = bitSet;
        switch (c) {
            case 'X': 
            case 'x': {
                this.ptOffset.x += (float)n;
                break;
            }
            case 'Y': 
            case 'y': {
                this.ptOffset.y += (float)n;
                break;
            }
            case 'Z': 
            case 'z': {
                this.ptOffset.z += (float)n;
            }
        }
    }

    void translateSelected() {
        Point3f point3f = this.viewer.getAtomSetCenter(this.bsAtoms);
        Point3f point3f2 = new Point3f();
        this.viewer.transformPoint(point3f, point3f2);
        point3f2.add(this.ptOffset);
        this.viewer.unTransformPoint(point3f2, point3f2);
        point3f2.sub(point3f);
        this.viewer.setAtomCoordRelative(point3f2, this.bsAtoms);
        this.bsAtoms = null;
        this.ptOffset.set(0.0f, 0.0f, 0.0f);
    }
}

