/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import org.jmol.util.DefaultLogger;
import org.jmol.util.LoggerInterface;

public final class Logger {
    private static LoggerInterface _logger = new DefaultLogger();
    public static final int LEVEL_FATAL = 1;
    public static final int LEVEL_ERROR = 2;
    public static final int LEVEL_WARN = 3;
    public static final int LEVEL_INFO = 4;
    public static final int LEVEL_DEBUG = 5;
    public static final int LEVEL_DEBUGHIGH = 6;
    public static final int LEVEL_MAX = 7;
    private static final boolean[] _activeLevels = new boolean[7];
    private static boolean _logLevel = false;
    public static boolean debugging;
    public static boolean debuggingHigh;
    static long startTime;

    private static boolean getProperty(String string, boolean bl) {
        try {
            String string2 = System.getProperty("jmol.logger." + string);
            if (string2 != null) {
                return Boolean.TRUE.equals(Boolean.valueOf(string2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static void setLogger(LoggerInterface loggerInterface) {
        _logger = loggerInterface;
        debugging = Logger.isActiveLevel(5) || Logger.isActiveLevel(6);
    }

    public static boolean isActiveLevel(int n) {
        return _logger != null && n >= 0 && n < 7 && _activeLevels[n];
    }

    public static void setActiveLevel(int n, boolean bl) {
        if (n < 0) {
            n = 0;
        }
        if (n >= 7) {
            n = 6;
        }
        Logger._activeLevels[n] = bl;
        debugging = Logger.isActiveLevel(5) || Logger.isActiveLevel(6);
    }

    public static void setLogLevel(int n) {
        int n2 = 7;
        while (--n2 >= 0) {
            Logger.setActiveLevel(n2, n2 <= n);
        }
    }

    public static String getLevel(int n) {
        switch (n) {
            case 6: {
                return "DEBUGHIGH";
            }
            case 5: {
                return "DEBUG";
            }
            case 4: {
                return "INFO";
            }
            case 3: {
                return "WARN";
            }
            case 2: {
                return "ERROR";
            }
            case 1: {
                return "FATAL";
            }
        }
        return "????";
    }

    public static boolean logLevel() {
        return _logLevel;
    }

    public static void logLevel(boolean bl) {
        _logLevel = bl;
    }

    public static void debug(String string) {
        if (!debugging) {
            return;
        }
        try {
            _logger.debug(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void info(String string) {
        try {
            if (Logger.isActiveLevel(4)) {
                _logger.info(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void warn(String string) {
        try {
            if (Logger.isActiveLevel(3)) {
                _logger.warn(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void warn(String string, Throwable throwable) {
        try {
            if (Logger.isActiveLevel(3)) {
                _logger.warn(string, throwable);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public static void error(String string) {
        try {
            if (Logger.isActiveLevel(2)) {
                _logger.error(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void error(String string, Throwable throwable) {
        try {
            if (Logger.isActiveLevel(2)) {
                _logger.error(string, throwable);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public static int getLogLevel() {
        int n = 7;
        while (--n >= 0) {
            if (!Logger.isActiveLevel(n)) continue;
            return n;
        }
        return 0;
    }

    public static void fatal(String string) {
        try {
            if (Logger.isActiveLevel(1)) {
                _logger.fatal(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void fatal(String string, Throwable throwable) {
        try {
            if (Logger.isActiveLevel(1)) {
                _logger.fatal(string, throwable);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public static void startTimer() {
        startTime = System.currentTimeMillis();
    }

    public static long checkTimer(String string) {
        long l = System.currentTimeMillis() - startTime;
        if (string != null) {
            Logger.info(string + ": " + l + " ms");
        }
        return l;
    }

    public static void checkMemory() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long l = runtime.totalMemory();
        long l2 = runtime.freeMemory();
        long l3 = 0L;
        try {
            l3 = runtime.maxMemory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.info("Memory: Total-Free=" + (l - l2) + "; Total=" + l + "; Free=" + l2 + "; Max=" + l3);
    }

    static {
        Logger._activeLevels[6] = Logger.getProperty("debugHigh", false);
        Logger._activeLevels[5] = Logger.getProperty("debug", false);
        Logger._activeLevels[4] = Logger.getProperty("info", true);
        Logger._activeLevels[3] = Logger.getProperty("warn", true);
        Logger._activeLevels[2] = Logger.getProperty("error", true);
        Logger._activeLevels[1] = Logger.getProperty("fatal", true);
        _logLevel = Logger.getProperty("logLevel", false);
        debugging = _logger != null && (_activeLevels[5] || _activeLevels[6]);
        debuggingHigh = debugging && _activeLevels[6];
    }
}

