from ftplib import FTP
import sys

# Get accession number from argument
accession = sys.argv[1]
outfile = sys.argv[2]
prefix = accession[0:3]
middle = accession[3:6]
suffix = accession[6:9]

# NCBI SRA FTP site
ftp = FTP('ftp-trace.ncbi.nih.gov')

# Open file and transfer requested SRA as a file
# Try to change the working directory until it works
sra = open(outfile, 'wb')
ftp.login('ftp')
connected = False
while not connected:
    try:
        ftp.cwd('/sra/sra-instant/reads/ByRun/sra/' + 
                prefix + '/' +
                prefix + middle + '/' +
                prefix + middle + suffix + '/')
        connected = True
    except:
        pass
        
ftp.retrbinary('RETR ' + prefix + middle + suffix + '.sra', sra.write)
ftp.quit()
