#!/bin/bash
set -e

inputFile=$1
id=$2
outputFile=$3
outputDir=$4
database=$5
limit_reads=$6
limit_ratio=$7
selection=$8
germline=$9
fastaFile=${10}

wd="$PWD"
dir="$(cd "$(dirname "$0")" && pwd)"
mkdir $outputDir
mkdir $outputDir/data
echo "<html><center><h1><a href='index.html'>Click here for the results</a></h1>Tip: Open it in a new tab (middle mouse button or right mouse button -> 'open in new tab' on the link above)</center></html>" > $outputFile

unzip $dir/browser.zip -d $outputDir/ > $outputDir/unziplog.log

if [[ "$database" == "download" ]] ; then
	echo "Downloading up to date database from IMGT..."
	mkdir $outputDir/tmp
	mkdir $outputDir/tmp/germline
	cp $dir/germline/get-germline $outputDir/tmp/germline
	cp $dir/germline/split-from-imgt.py $outputDir/tmp/germline
	cp $dir/vidjil $outputDir/tmp
	cd $outputDir/tmp/germline
	./get-germline 2>&1
	cd $outputDir/tmp
else
	cd $dir
fi

./vidjil -G germline/$germline -y all -r ${limit_reads} -% ${limit_ratio} -b $id -o $outputDir/data $inputFile

mv $outputDir/data/${id}.vdj.fa $fastaFile

echo -e \
"var config = {\n" \
"    'autoload' : 'data/${id}.vidjil'\n" \
"}" > $outputDir/js/conf.js;

