#!/bin/bash

inputFile=$1
outputFile=$2
outputDir=$3
database=$4
limit_reads=$5
limit_ratio=$6


dir="$(cd "$(dirname "$0")" && pwd)"
mkdir $outputDir

unzip $dir/browser.zip -d $outputDir/ > $outputDir/unziplog.log

mkdir $outputDir/out

if [[ "$database" == "download" ]] ; then
	echo "Downloading up to date database from IMGT..."
	mkdir $outputDir/tmp
	mkdir $outputDir/tmp/germline
	cp $dir/germline/get-germline $outputDir/tmp/germline
	cp $dir/germline/split-from-imgt.py $outputDir/tmp/germline
	cp $dir/vidjil $outputDir/tmp
	cd $outputDir/tmp/germline
	./get-germline 2>&1
	cd $outputDir/tmp
else
	cd $dir
fi
./vidjil $inputFile -y all -r ${limit_reads} -% ${limit_ratio} -b data -o $outputDir



echo "<html><center><h1><a href='index.html'>Click here for the results</a></h1>Tip: Open it in a new tab (middle mouse button or right mouse button -> 'open in new tab' on the link above)</center></html>" > $outputFile

cd "$outputDir"
