#options( show.error.messages=F, error = function () { cat( geterrmessage(), file=stderr() ); q( "no", 1, F ) } )

args <- commandArgs(trailingOnly = TRUE)

inFile = args[1]
outFile = args[2]
outDir = args[3]
clonalType = args[4]

if (!("gridExtra" %in% rownames(installed.packages()))) {
	install.packages("gridExtra", repos="http://cran.xl-mirror.nl/") 
}
library(gridExtra)
if (!("ggplot2" %in% rownames(installed.packages()))) {
	install.packages("ggplot2", repos="http://cran.xl-mirror.nl/") 
}
require(ggplot2)
if (!("plyr" %in% rownames(installed.packages()))) {
	install.packages("plyr", repos="http://cran.xl-mirror.nl/") 
}			
require(plyr)

if (!("data.table" %in% rownames(installed.packages()))) {
	install.packages("data.table", repos="http://cran.xl-mirror.nl/") 
}
library(data.table)


test = read.table(inFile, sep="\t", header=TRUE, fill=T, comment.char="")

test = test[test$Sample != "",]

test$Top.V.Gene = gsub("[*]([0-9]+)", "", test$Top.V.Gene)
test$Top.D.Gene = gsub("[*]([0-9]+)", "", test$Top.D.Gene)
test$Top.J.Gene = gsub("[*]([0-9]+)", "", test$Top.J.Gene)

#test$VDJCDR3 = do.call(paste, c(test[c("Top.V.Gene", "Top.D.Gene", "Top.J.Gene","CDR3.Seq.DNA")], sep = ":"))
test$VDJCDR3 = do.call(paste, c(test[unlist(strsplit(clonalType, ","))], sep = ":"))

PROD = test[test$VDJ.Frame != "In-frame with stop codon" & test$VDJ.Frame != "Out-of-frame" & test$CDR3.Found.How != "NOT_FOUND" , ]
if("Functionality" %in% colnames(test)) {
	PROD = test[test$Functionality == "productive" | test$Functionality == "productive (see comment)", ]
}

NONPROD = test[test$VDJ.Frame == "In-frame with stop codon" | test$VDJ.Frame == "Out-of-frame" | test$CDR3.Found.How == "NOT_FOUND" , ]

#PRODF = PROD[ -1]

PRODF = PROD

#PRODF = unique(PRODF)
PRODF = PRODF[!duplicated(PRODF$VDJCDR3), ]

PRODFV = data.frame(data.table(PRODF)[, list(Length=.N), by=c("Sample", "Top.V.Gene")])
PRODFV$Length = as.numeric(PRODFV$Length)
Total = 0
Total = ddply(PRODFV, .(Sample), function(x) data.frame(Total = sum(x$Length)))
PRODFV = merge(PRODFV, Total, by.x='Sample', by.y='Sample', all.x=TRUE)
PRODFV = ddply(PRODFV, c("Sample", "Top.V.Gene"), summarise, relFreq= (Length*100 / Total))

PRODFD = data.frame(data.table(PRODF)[, list(Length=.N), by=c("Sample", "Top.D.Gene")])
PRODFD$Length = as.numeric(PRODFD$Length)
Total = 0
Total = ddply(PRODFD, .(Sample), function(x) data.frame(Total = sum(x$Length)))
PRODFD = merge(PRODFD, Total, by.x='Sample', by.y='Sample', all.x=TRUE)
PRODFD = ddply(PRODFD, c("Sample", "Top.D.Gene"), summarise, relFreq= (Length*100 / Total))

PRODFJ = data.frame(data.table(PRODF)[, list(Length=.N), by=c("Sample", "Top.J.Gene")])
PRODFJ$Length = as.numeric(PRODFJ$Length)
Total = 0
Total = ddply(PRODFJ, .(Sample), function(x) data.frame(Total = sum(x$Length)))
PRODFJ = merge(PRODFJ, Total, by.x='Sample', by.y='Sample', all.x=TRUE)
PRODFJ = ddply(PRODFJ, c("Sample", "Top.J.Gene"), summarise, relFreq= (Length*100 / Total))

V = c("v.name\tchr.orderV\nIGHV7-81\t1\nIGHV3-74\t2\nIGHV3-73\t3\nIGHV3-72\t4\nIGHV2-70\t6\nIGHV1-69\t7\nIGHV3-66\t8\nIGHV3-64\t9\nIGHV4-61\t10\nIGHV4-59\t11\nIGHV1-58\t12\nIGHV3-53\t13\nIGHV5-a\t15\nIGHV5-51\t16\nIGHV3-49\t17\nIGHV3-48\t18\nIGHV1-46\t20\nIGHV1-45\t21\nIGHV3-43\t22\nIGHV4-39\t23\nIGHV3-35\t24\nIGHV4-34\t25\nIGHV3-33\t26\nIGHV4-31\t27\nIGHV4-30-4\t28\nIGHV4-30-2\t29\nIGHV3-30-3\t30\nIGHV3-30\t31\nIGHV4-28\t32\nIGHV2-26\t33\nIGHV1-24\t34\nIGHV3-23\t35\nIGHV3-21\t37\nIGHV3-20\t38\nIGHV1-18\t40\nIGHV3-15\t41\nIGHV3-13\t42\nIGHV3-11\t43\nIGHV3-9\t44\nIGHV1-8\t45\nIGHV3-7\t46\nIGHV2-5\t47\nIGHV7-4-1\t48\nIGHV4-4\t49\nIGHV4-b\t50\nIGHV1-3\t51\nIGHV1-2\t52\nIGHV6-1\t53")
tcV = textConnection(V)
Vchain = read.table(tcV, sep="\t", header=TRUE)
PRODFV = merge(PRODFV, Vchain, by.x='Top.V.Gene', by.y='v.name', all.x=TRUE)
close(tcV)

D = c("v.name\tchr.orderD\nIGHD1-1\t1\nIGHD2-2\t2\nIGHD3-3\t3\nIGHD6-6\t4\nIGHD1-7\t5\nIGHD2-8\t6\nIGHD3-9\t7\nIGHD3-10\t8\nIGHD4-11\t9\nIGHD5-12\t10\nIGHD6-13\t11\nIGHD1-14\t12\nIGHD2-15\t13\nIGHD3-16\t14\nIGHD4-17\t15\nIGHD5-18\t16\nIGHD6-19\t17\nIGHD1-20\t18\nIGHD2-21\t19\nIGHD3-22\t20\nIGHD4-23\t21\nIGHD5-24\t22\nIGHD6-25\t23\nIGHD1-26\t24\nIGHD7-27\t25")
tcD = textConnection(D)
Dchain = read.table(tcD, sep="\t", header=TRUE)
PRODFD = merge(PRODFD, Dchain, by.x='Top.D.Gene', by.y='v.name', all.x=TRUE)
close(tcD)


J = c("v.name\tchr.orderJ\nIGHJ1\t1\nIGHJ2\t2\nIGHJ3\t3\nIGHJ4\t4\nIGHJ5\t5\nIGHJ6\t6")
tcJ = textConnection(J)
Jchain = read.table(tcJ, sep="\t", header=TRUE)
PRODFJ = merge(PRODFJ, Jchain, by.x='Top.J.Gene', by.y='v.name', all.x=TRUE)
close(tcJ)

setwd(outDir)

write.table(PRODF, "allUnique.tsv", sep="\t",quote=F,row.names=F,col.names=T)

pV = ggplot(PRODFV)
pV = pV + geom_bar( aes( x=factor(reorder(Top.V.Gene, chr.orderV)), y=relFreq, fill=Sample), stat='identity', position="dodge") + theme(axis.text.x = element_text(angle = 90, hjust = 1))
pV = pV + xlab("Summary of V gene") + ylab("Frequency") + ggtitle("Relative frequency of V gene usage")

png("VPlot.png",width = 1280, height = 720)
pV
dev.off();

pD = ggplot(PRODFD)
pD = pD + geom_bar( aes( x=factor(reorder(Top.D.Gene, chr.orderD)), y=relFreq, fill=Sample), stat='identity', position="dodge") + theme(axis.text.x = element_text(angle = 90, hjust = 1))
pD = pD + xlab("Summary of D gene") + ylab("Frequency") + ggtitle("Relative frequency of D gene usage")

png("DPlot.png",width = 800, height = 600)
pD
dev.off();

pJ = ggplot(PRODFJ)
pJ = pJ + geom_bar( aes( x=factor(reorder(Top.J.Gene, chr.orderJ)), y=relFreq, fill=Sample), stat='identity', position="dodge") + theme(axis.text.x = element_text(angle = 90, hjust = 1))
pJ = pJ + xlab("Summary of J gene") + ylab("Frequency") + ggtitle("Relative frequency of J gene usage")

png("JPlot.png",width = 800, height = 600)
pJ
dev.off();

revVchain = Vchain
revDchain = Dchain
revVchain$chr.orderV = rev(revVchain$chr.orderV)
revDchain$chr.orderD = rev(revDchain$chr.orderD)

plotVD <- function(dat){
	if(length(dat[,1]) == 0){
		return()
	}
	img = ggplot() + 
	geom_tile(data=dat, aes(x=factor(reorder(Top.D.Gene, chr.orderD)), y=factor(reorder(Top.V.Gene, chr.orderV)), fill=relLength)) + 
	theme(axis.text.x = element_text(angle = 90, hjust = 1)) + 
	scale_fill_gradient(low="gold", high="blue", na.value="white") + 
	ggtitle(paste(unique(dat$Sample), " (N=" , sum(dat$Length, na.rm=T) ,")", sep="")) + 
	xlab("D genes") + 
	ylab("V Genes")
	
	png(paste("HeatmapVD_", unique(dat[3])[1,1] , ".png", sep=""), width=150+(15*length(Dchain$v.name)), height=100+(15*length(Vchain$v.name)))
	print(img)
	dev.off()
}

VandDCount = data.frame(data.table(PRODF)[, list(Length=.N), by=c("Top.V.Gene", "Top.D.Gene", "Sample")])

VandDCount$l = log(VandDCount$Length)
maxVD = data.frame(data.table(VandDCount)[, list(max=max(l)), by=c("Sample")])
VandDCount = merge(VandDCount, maxVD, by.x="Sample", by.y="Sample", all.x=T)
VandDCount$relLength = VandDCount$l / VandDCount$max

cartegianProductVD = expand.grid(Top.V.Gene = Vchain$v.name, Top.D.Gene = Dchain$v.name, Sample = unique(test$Sample))

completeVD = merge(VandDCount, cartegianProductVD, all.y=TRUE)
completeVD = merge(completeVD, revVchain, by.x="Top.V.Gene", by.y="v.name", all.x=TRUE)
completeVD = merge(completeVD, Dchain, by.x="Top.D.Gene", by.y="v.name", all.x=TRUE)
VDList = split(completeVD, f=completeVD[,"Sample"])

lapply(VDList, FUN=plotVD)



plotVJ <- function(dat){
	if(length(dat[,1]) == 0){
		return()
	}
	img = ggplot() + 
	geom_tile(data=dat, aes(x=factor(reorder(Top.J.Gene, chr.orderJ)), y=factor(reorder(Top.V.Gene, chr.orderV)), fill=relLength)) + 
	theme(axis.text.x = element_text(angle = 90, hjust = 1)) + 
	scale_fill_gradient(low="gold", high="blue", na.value="white") + 
	ggtitle(paste(unique(dat$Sample), " (N=" , sum(dat$Length, na.rm=T) ,")", sep="")) + 
	xlab("J genes") + 
	ylab("V Genes")
	
	png(paste("HeatmapVJ_", unique(dat[3])[1,1] , ".png", sep=""), width=150+(15*length(Jchain$v.name)), height=100+(15*length(Vchain$v.name)))
	print(img)
	dev.off()
}

VandJCount = data.frame(data.table(PRODF)[, list(Length=.N), by=c("Top.V.Gene", "Top.J.Gene", "Sample")])

VandJCount$l = log(VandJCount$Length)
maxVJ = data.frame(data.table(VandJCount)[, list(max=max(l)), by=c("Sample")])
VandJCount = merge(VandJCount, maxVJ, by.x="Sample", by.y="Sample", all.x=T)
VandJCount$relLength = VandJCount$l / VandJCount$max

cartegianProductVJ = expand.grid(Top.V.Gene = Vchain$v.name, Top.J.Gene = Jchain$v.name, Sample = unique(test$Sample))

completeVJ = merge(VandJCount, cartegianProductVJ, all.y=TRUE)
completeVJ = merge(completeVJ, revVchain, by.x="Top.V.Gene", by.y="v.name", all.x=TRUE)
completeVJ = merge(completeVJ, Jchain, by.x="Top.J.Gene", by.y="v.name", all.x=TRUE)
VJList = split(completeVJ, f=completeVJ[,"Sample"])
lapply(VJList, FUN=plotVJ)

plotDJ <- function(dat){
	if(length(dat[,1]) == 0){
		return()
	}
	img = ggplot() + 
	geom_tile(data=dat, aes(x=factor(reorder(Top.J.Gene, chr.orderJ)), y=factor(reorder(Top.D.Gene, chr.orderD)), fill=relLength)) + 
	theme(axis.text.x = element_text(angle = 90, hjust = 1)) + 
	scale_fill_gradient(low="gold", high="blue", na.value="white") + 
	ggtitle(paste(unique(dat$Sample), " (N=" , sum(dat$Length, na.rm=T) ,")", sep="")) + 
	xlab("J genes") + 
	ylab("D Genes")
	
	png(paste("HeatmapDJ_", unique(dat[3])[1,1] , ".png", sep=""), width=150+(15*length(Jchain$v.name)), height=100+(15*length(Dchain$v.name)))
	print(img)
	dev.off()
}

DandJCount = data.frame(data.table(PRODF)[, list(Length=.N), by=c("Top.D.Gene", "Top.J.Gene", "Sample")])

DandJCount$l = log(DandJCount$Length)
maxDJ = data.frame(data.table(DandJCount)[, list(max=max(l)), by=c("Sample")])
DandJCount = merge(DandJCount, maxDJ, by.x="Sample", by.y="Sample", all.x=T)
DandJCount$relLength = DandJCount$l / DandJCount$max

cartegianProductDJ = expand.grid(Top.D.Gene = Dchain$v.name, Top.J.Gene = Jchain$v.name, Sample = unique(test$Sample))

completeDJ = merge(DandJCount, cartegianProductDJ, all.y=TRUE)
completeDJ = merge(completeDJ, revDchain, by.x="Top.D.Gene", by.y="v.name", all.x=TRUE)
completeDJ = merge(completeDJ, Jchain, by.x="Top.J.Gene", by.y="v.name", all.x=TRUE)
DJList = split(completeDJ, f=completeDJ[,"Sample"])
lapply(DJList, FUN=plotDJ)


sampleFile <- file("samples.txt")
un = unique(test$Sample)
un = paste(un, sep="\n")
writeLines(un, sampleFile)
close(sampleFile)


if("Replicate" %in% colnames(test))
{
	clonalityFrame = PROD
	clonalityFrame$ReplicateConcat = do.call(paste, c(clonalityFrame[c("VDJCDR3", "Sample", "Replicate")], sep = ":"))
	clonalityFrame = clonalityFrame[!duplicated(clonalityFrame$ReplicateConcat), ]
	write.table(clonalityFrame, "clonalityComplete.tsv", sep="\t",quote=F,row.names=F,col.names=T)

	ClonalitySampleReplicatePrint <- function(dat){
	    write.table(dat, paste("clonality_", unique(dat$Sample) , "_", unique(dat$Replicate), ".tsv", sep=""), sep="\t",quote=F,row.names=F,col.names=T)
	}

    clonalityFrameSplit = split(clonalityFrame, f=clonalityFrame[,c("Sample", "Replicate")])
    lapply(clonalityFrameSplit, FUN=ClonalitySampleReplicatePrint)

    ClonalitySamplePrint <- function(dat){
	    write.table(dat, paste("clonality_", unique(dat$Sample) , ".tsv", sep=""), sep="\t",quote=F,row.names=F,col.names=T)
	}

    clonalityFrameSplit = split(clonalityFrame, f=clonalityFrame[,"Sample"])
    lapply(clonalityFrameSplit, FUN=ClonalitySamplePrint)

	clonalFreq = data.frame(data.table(clonalityFrame)[, list(Type=.N), by=c("Sample", "VDJCDR3")])
	clonalFreqCount = data.frame(data.table(clonalFreq)[, list(Count=.N), by=c("Sample", "Type")])
	clonalFreqCount$realCount = clonalFreqCount$Type * clonalFreqCount$Count
	clonalSum = data.frame(data.table(clonalFreqCount)[, list(Reads=sum(realCount)), by=c("Sample")])
	clonalFreqCount = merge(clonalFreqCount, clonalSum, by.x="Sample", by.y="Sample")

	ct = c('Type\tWeight\n2\t1\n3\t3\n4\t6\n5\t10\n6\t15')
	tcct = textConnection(ct)
	CT  = read.table(tcct, sep="\t", header=TRUE)
	close(tcct)
	clonalFreqCount = merge(clonalFreqCount, CT, by.x="Type", by.y="Type", all.x=T)
	clonalFreqCount$WeightedCount = clonalFreqCount$Count * clonalFreqCount$Weight

	ReplicateReads = data.frame(data.table(clonalityFrame)[, list(Type=.N), by=c("Sample", "Replicate", "VDJCDR3")])
	ReplicateReads = data.frame(data.table(ReplicateReads)[, list(Reads=.N), by=c("Sample", "Replicate")])
	clonalFreqCount$Reads = as.numeric(clonalFreqCount$Reads)
	ReplicateReads$squared = ReplicateReads$Reads * ReplicateReads$Reads

	ReplicatePrint <- function(dat){
		write.table(dat[-1], paste("ReplicateReads_", unique(dat[1])[1,1] , ".csv", sep=""), sep=",",quote=F,na="-",row.names=F,col.names=F)
	}

	ReplicateSplit = split(ReplicateReads, f=ReplicateReads[,"Sample"])
	lapply(ReplicateSplit, FUN=ReplicatePrint)

	ReplicateReads = data.frame(data.table(ReplicateReads)[, list(ReadsSum=sum(Reads), ReadsSquaredSum=sum(squared)), by=c("Sample")])
	clonalFreqCount = merge(clonalFreqCount, ReplicateReads, by.x="Sample", by.y="Sample", all.x=T)


	ReplicateSumPrint <- function(dat){
		write.table(dat[-1], paste("ReplicateSumReads_", unique(dat[1])[1,1] , ".csv", sep=""), sep=",",quote=F,na="-",row.names=F,col.names=F)
	}

	ReplicateSumSplit = split(ReplicateReads, f=ReplicateReads[,"Sample"])
	lapply(ReplicateSumSplit, FUN=ReplicateSumPrint)

	clonalFreqCountSum = data.frame(data.table(clonalFreqCount)[, list(Numerator=sum(WeightedCount, na.rm=T)), by=c("Sample")])
	clonalFreqCount = merge(clonalFreqCount, clonalFreqCountSum, by.x="Sample", by.y="Sample", all.x=T)
	clonalFreqCount$ReadsSum = as.numeric(clonalFreqCount$ReadsSum) #prevent integer overflow
	clonalFreqCount$Denominator = (((clonalFreqCount$ReadsSum * clonalFreqCount$ReadsSum) - clonalFreqCount$ReadsSquaredSum) / 2)
	clonalFreqCount$Result = (clonalFreqCount$Numerator + 1) / (clonalFreqCount$Denominator + 1)

	ClonalityScorePrint <- function(dat){
		write.table(dat$Result, paste("ClonalityScore_", unique(dat[1])[1,1] , ".csv", sep=""), sep=",",quote=F,na="-",row.names=F,col.names=F)
	}

	clonalityScore = clonalFreqCount[c("Sample", "Result")]
	clonalityScore = unique(clonalityScore)

	clonalityScoreSplit = split(clonalityScore, f=clonalityScore[,"Sample"])
	lapply(clonalityScoreSplit, FUN=ClonalityScorePrint)

	clonalityOverview = clonalFreqCount[c("Sample", "Type", "Count", "Weight", "WeightedCount")]



	ClonalityOverviewPrint <- function(dat){
		write.table(dat[-1], paste("ClonalityOverView_", unique(dat[1])[1,1] , ".csv", sep=""), sep=",",quote=F,na="-",row.names=F,col.names=F)
	}

	clonalityOverviewSplit = split(clonalityOverview, f=clonalityOverview$Sample)
	lapply(clonalityOverviewSplit, FUN=ClonalityOverviewPrint)
}
