library(ggplot2)
library(reshape2)

args <- commandArgs(trailingOnly = TRUE)

input.file = args[1] #the data that's get turned into the "SHM overview" table in the html report "data_sum.txt"
plot1.file = args[2] 
plot2.file = args[3]
plot3.file = args[4]

dat = read.table(input.file, header=F, sep=",", quote="", stringsAsFactors=F, fill=T)

classes = c("ca", "ca1", "ca2", "cg", "cg1", "cg2", "cg3", "cg4", "cm")
xyz = c("x", "y", "z")

names(dat) = c("info", paste(rep(classes, each=3), xyz, sep="."), paste("un", xyz, sep="."), paste("all", xyz, sep="."))

