args <- commandArgs(trailingOnly = TRUE)

input=args[1]
column=as.numeric(args[2])
header=(args[3] == "yes")
regex_filter=args[4]
out_file=args[5]

print(regex_filter)

dat = read.table(input, header=header, sep="\t", fill=T, stringsAsFactors=F, quote="")

dat.names = names(dat)

dat$filtered = gsub("\\(.*", "", dat[,column])

duplicates = dat[duplicated(dat$filtered),"filtered"]

dat = dat[dat[,"filtered"] %in% duplicates,]

dat = dat[order(dat[,"filtered"]),]

write.table(dat[,dat.names], out_file, sep="\t", row.names=F, col.names=header, quote=F)
