#!/bin/bash
dir="$(cd "$(dirname "$0")" && pwd)"

action=$1
input=$2
output=$3

cp $input $PWD/input.tab

input="$PWD/input.tab"

mkdir $PWD/outdir

if [ "fasta" == "$action" ] ; then
	python3 $dir/ParseDb.py fasta -d $input --outdir $PWD/outdir --outname output
	mv $PWD/outdir/output_sequences.fasta $output
elif [ "clip" == "$action" ] ; then
	python3 $dir/ParseDb.py clip -d $input --outdir $PWD/outdir --outname output
	mv $PWD/outdir/output_sequences.fasta $output
elif [ "split" == "$action" ] ; then
	field="`cat $input 2> /dev/null | head -n 1 | cut -f$4 | tr '\n\r' ' '`"
	label=$5
	mkdir $PWD/split
	python3 $dir/ParseDb.py split -d $input --outdir $PWD/split --outname output -f $field 
	#rename "s/output_${field}/$label/" $PWD/split/*
elif [ "add" == "$action" ] ; then
	field="`cat $input 2> /dev/null | head -n 1 | cut -f$4 | tr '\n\r' ' '`"
	value=$5
	python3 $dir/ParseDb.py add -d $input --outdir $PWD/outdir --outname output -f $field -u $value
	mv $PWD/outdir/output_parse-add.tab $output
elif [ "delete" == "$action" ] ; then
	field="`cat $input 2> /dev/null | head -n 1 | cut -f$4 | tr '\n\r' ' '`"
	value=$5
	regex=$6
	if [ "true" == "$regex" ] ; then
		regex="--regex"
	else
		regex=""
	fi
	python3 $dir/ParseDb.py delete -d $input --outdir $PWD/outdir --outname output -f $field -u $value --logic any $regex
	mv $PWD/outdir/output_parse-delete.tab $output
elif [ "drop" == "$action" ] ; then
	field="`cat $input 2> /dev/null | head -n 1 | cut -f$4 | tr '\n\r' ' '`"
	python3 $dir/ParseDb.py drop -d $input --outdir $PWD/outdir --outname output -f $field
	mv $PWD/outdir/output_parse-drop.tab $output
elif [ "index" == "$action" ] ; then
	field=$4
	python3 $dir/ParseDb.py index -d $input --outdir $PWD/outdir --outname output -f $field
	mv $PWD/outdir/output_parse-index.tab $output
elif [ "rename" == "$action" ] ; then
	field="`cat $input 2> /dev/null | head -n 1 | cut -f$4 | tr '\n\r' ' '`"
	newname=$5
	python3 $dir/ParseDb.py rename -d $input --outdir $PWD/outdir --outname output -f $field -k $newname
	mv $PWD/outdir/output_parse-rename.tab $output
elif [ "select" == "$action" ] ; then
	field="`cat $input 2> /dev/null | head -n 1 | cut -f$4 | tr '\n\r' ' '`"
	value=$5
	regex=$6
	if [ "true" == "$regex" ] ; then
		regex="--regex"
	else
		regex=""
	fi
	python3 $dir/ParseDb.py select -d $input --outdir $PWD/outdir --outname output -f $field -u $value --logic any $regex
	mv $PWD/outdir/output_parse-select.tab $output
elif [ "sort" == "$action" ] ; then
	field="`cat $input 2> /dev/null | head -n 1 | cut -f$4 | tr '\n\r' ' '`"
	num=$5
	tmp=""
	if [ "true" == "$num" ] ; then
		tmp="--num"
	fi	
	desc=$6
	if [ "true" == "$desc" ] ; then
		tmp="--descend $tmp"
	fi	
	python3 $dir/ParseDb.py sort -d $input --outdir $PWD/outdir --outname output -f $field $tmp
	mv $PWD/outdir/output_parse-sort.tab $output
elif [ "update" == "$action" ] ; then
	field="`cat $input 2> /dev/null | head -n 1 | cut -f$4 | tr '\n\r' ' '`"
	value=$5
	replace=$6
	regex=$7
	if [ "true" == "$regex" ] ; then
		regex="--regex"
	else
		regex=""
	fi
	python3 $dir/ParseDb.py update -d $input --outdir $PWD/outdir --outname output -f $field -u $value -t $replace $regex
	mv $PWD/outdir/output_parse-update.tab $output
fi

