from galaxy import eggs
import pkg_resources
pkg_resources.require( "bx-python" )

import logging, os, sys, time, sets, tempfile, shutil
import data
from galaxy import util
from galaxy.datatypes.sniff import *
from galaxy.datatypes.binary import Binary
import tarfile

class Tar( Binary ):
    """Class describing a BAM binary file"""
    file_ext = "tar"
    def sniff( self, filename ):
        try:
            if tarfile.is_tarfile(filename):
                return True
            return False
        except:
            return False
    def set_peek( self, dataset, is_multi_byte=False ):
        if not dataset.dataset.purged:
            dataset.peek  = "Tar file"
            dataset.blurb = data.nice_size( dataset.get_size() )
        else:
            dataset.peek = 'file does not exist'
            dataset.blurb = 'file purged from disk'
    def display_peek( self, dataset ):
        try:
            return dataset.peek
        except:
            return "Tar file (%s)" % ( data.nice_size( dataset.get_size() ) )

