#!/bin/bash

# Check java version
if (type -p java >> /dev/null); then
    _java=java
elif [[ -n "$JAVA_HOME" ]] && [[ -x "$JAVA_HOME/bin/java" ]];  then
    _java="$JAVA_HOME/bin/java"
else
    echo "You must install java before runing this tool"
    exit 1
fi
if [[ "$_java" ]]; then
    version=$("$_java" -version 2>&1 | awk -F '"' '/version/ {print $2}')
    if ! [[ "$version" > "1.6" ]]; then
        echo "Java version should be > 1.6"
	exit 1
    fi
fi

# Locate the jar directory
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
jar_path="${DIR}/jars/${1}"
shift

# Untar the chromosome file into a temporary directory
tar_file="$1"
shift
tmp_dir="/tmp/$(basename "$tar_file")"
mkdir -p $tmp_dir
tar -C $tmp_dir -xvf $tar_file

# Run the jar and remove the temporary directory
java -jar $jar_path $@ -c "$tmp_dir"
rm -rf $tmp_dir
