#!/bin/bash

if (type -p java >> /dev/null); then
    _java=java
elif [[ -n "$JAVA_HOME" ]] && [[ -x "$JAVA_HOME/bin/java" ]];  then
    _java="$JAVA_HOME/bin/java"
else
    echo "You must install java before runing this tool" >&2
    exit 1
fi

if [[ "$_java" ]]; then
    version=$("$_java" -version 2>&1 | awk -F '"' '/version/ {print $2}')
    if ! [[ "$version" > "1.6" ]]; then
        echo "Java version should be > 1.6" >&2
	exit 1
    fi
fi

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

jar_path="${DIR}/jars/${1}"
shift

java -jar $jar_path $@
