import json
import argparse
import os
import shutil



parser = argparse.ArgumentParser(description='Create data manager json.')
parser.add_argument('--dbkey', action='store')
parser.add_argument('--provider', action='store')
parser.add_argument('--ref', action='store')
parser.add_argument('--out', action='store')

args = parser.parse_args()

def main(args):
    data_manager_entry = {}
    data_manager_entry['value'] = args.dbkey.lower()
    data_manager_entry['name'] = args.dbkey
    data_manager_entry['path'] = '.'
    data_manager_entry['ref'] = args.ref
    data_manager_entry['provider'] = args.provider
    data_manager_json = dict(data_tables=dict(gene_sets=data_manager_entry))
    params = json.loads(open(args.out).read())
    target_directory = params['output_data'][0]['extra_files_path']
    os.mkdir(target_directory)
    output_path = os.path.join(os.getcwd(), 'featurecount_gxf')
    for filename in os.listdir(output_path):
        shutil.move(os.path.join(output_path, filename), target_directory)
    file(args.output, 'w').write(json.dumps(data_manager_json))

if __name__ == '__main__':
    main(args)
