/*
 * Decompiled with CFR 0.152.
 */
package jhi.intertekparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import jhi.intertekparser.IntertekMarker;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class IntertekParser {
    private String genotypeFileName;
    private String intertekFileName;
    private String outputFileName;
    private Map<String, IntertekMarker> intertekMarkers;
    private HashSet<String> genotypeMarkers;

    public static void main(String[] args) {
        Options options = IntertekParser.mainOptions();
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cl = parser.parse(options, args);
            IntertekParser intertekParser = new IntertekParser(cl.getOptionValue("g"), cl.getOptionValue("i"), cl.getOptionValue("o"));
            intertekParser.parse();
        }
        catch (ParseException e) {
            IntertekParser.printHelp("IntertekParser");
            e.printStackTrace();
        }
    }

    public IntertekParser(String genotypeFileName, String intertekFileName, String outputFileName) {
        this.genotypeFileName = genotypeFileName;
        this.intertekFileName = intertekFileName;
        this.outputFileName = outputFileName;
    }

    public void parse() {
        this.readIntertekFile();
        File genotypeFile = new File(this.genotypeFileName);
        if (!genotypeFile.exists()) {
            System.out.println("Genotype file does not exist");
            System.exit(1);
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(genotypeFile));
             PrintWriter writer = new PrintWriter(new FileWriter(new File(this.outputFileName)));){
            String str = reader.readLine();
            while (str.length() == 0 || str.startsWith("#")) {
                writer.println(str);
                str = reader.readLine();
            }
            this.genotypeMarkers = new HashSet();
            String[] markerNames = str.split("\t");
            for (int i = 1; i < markerNames.length; ++i) {
                this.genotypeMarkers.add(markerNames[i]);
            }
            writer.println(str);
            while ((str = reader.readLine()) != null) {
                writer.println(str);
            }
            for (String markerName : this.intertekMarkers.keySet()) {
                if (!this.genotypeMarkers.contains(markerName)) continue;
                IntertekMarker intertekMarker = this.intertekMarkers.get(markerName);
                writer.println("# fjFavAllele\t" + intertekMarker.getName() + "\t" + intertekMarker.getFavourableAlleles().stream().collect(Collectors.joining("\t")));
                writer.println("# fjUnfavAllele\t" + intertekMarker.getName() + "\t" + intertekMarker.getUnfavourableAlleles().stream().collect(Collectors.joining("\t")));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readIntertekFile() {
        File intertekFile = new File(this.intertekFileName);
        if (!intertekFile.exists()) {
            System.out.println("Intertek file does not exist");
            System.exit(1);
        }
        this.intertekMarkers = new HashMap<String, IntertekMarker>();
        try (BufferedReader reader = new BufferedReader(new FileReader(intertekFile));){
            String str = null;
            while ((str = reader.readLine()) != null) {
                if (str.toLowerCase().startsWith("intertek_snp_id")) continue;
                String[] tokens = str.split("\t");
                String markerName = tokens[0];
                System.out.println("Intertek Marker: " + markerName);
                String traitGene = tokens[1];
                String favourableAllele = tokens[2];
                String unfavourableAllele = tokens[3];
                this.intertekMarkers.put(markerName, new IntertekMarker(markerName, traitGene, Collections.singletonList(favourableAllele), Collections.singletonList(unfavourableAllele)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Options mainOptions() {
        Options options = new Options();
        options.addRequiredOption("g", "genotype", true, "A filepath to a Flapjack formatted genotype file");
        options.addRequiredOption("i", "intertek", true, "A filepath to an Intertek formatted file with favourable allele information");
        options.addRequiredOption("o", "output", true, "A filepath to the name and location of the desired output file");
        return options;
    }

    private static void printHelp(String name) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(name, IntertekParser.mainOptions(), true);
    }
}

