/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.util.ArrayList;
import java.util.Collections;
import jhi.flapjack.analysis.SimilarityScore;
import jhi.flapjack.analysis.SortLines;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.LineInfo;

public class SortLinesBySimilarity
extends SortLines {
    private Line comparisonLine;
    private boolean[] chromosomes;

    public SortLinesBySimilarity(GTViewSet viewSet, Line comparisonLine, boolean[] chromosomes) {
        super(viewSet);
        this.comparisonLine = comparisonLine;
        this.chromosomes = chromosomes;
    }

    @Override
    public void runJob(int jobIndex) {
        long s = System.currentTimeMillis();
        super.runJob(jobIndex);
        this.viewSet.setDisplayLineScores(true);
        System.out.println("Similarity sort in " + (System.currentTimeMillis() - s) + "ms");
    }

    @Override
    protected ArrayList<LineInfo> doSort(GTView view) {
        ArrayList<LineScore> scores = new ArrayList<LineScore>();
        float[][] matrix = this.viewSet.getDataSet().getStateTable().calculateSimilarityMatrix();
        int line = this.viewSet.indexOf(this.comparisonLine);
        System.out.println("Sorting using line " + line + " as comparison line");
        ArrayList<LineInfo> lines = view.getViewSet().getLines();
        int i = 0;
        while (i < lines.size() && this.okToRun) {
            SimilarityScore ss = new SimilarityScore(this.viewSet, matrix, this.chromosomes);
            SimilarityScore.Score score = ss.getScore(line, i);
            scores.add(new LineScore(lines.get(i), score.score, score.nComparisons, score.data));
            ++i;
            ++this.linesScored;
        }
        Collections.sort(scores);
        ArrayList<LineInfo> lineOrder = new ArrayList<LineInfo>(view.lineCount());
        for (int i2 = 0; i2 < scores.size() && this.okToRun; ++i2) {
            lineOrder.add(((LineScore)scores.get((int)i2)).lineInfo);
        }
        return lineOrder;
    }

    private class LineScore
    implements Comparable<LineScore> {
        LineInfo lineInfo;
        float score;
        float nComparisons;
        String data;

        LineScore(LineInfo lineInfo, float score, float nComparisons, String data) {
            this.lineInfo = lineInfo;
            this.score = score;
            this.nComparisons = nComparisons;
            this.data = data;
            lineInfo.setScore(score);
        }

        @Override
        public int compareTo(LineScore other) {
            if (this.score > other.score) {
                return -1;
            }
            if (this.score == other.score) {
                if (this.nComparisons > other.nComparisons) {
                    return -1;
                }
                if (this.nComparisons == other.nComparisons) {
                    return this.data.compareTo(other.data);
                }
                return 1;
            }
            return 1;
        }
    }
}

