/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import jhi.flapjack.analysis.SimilarityScore;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.GenotypeData;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.results.SimMatrix;
import jhi.flapjack.io.ProjectSerializerDB;
import scri.commons.gui.RB;
import scri.commons.gui.SimpleJob;

public class CalculateSimilarityMatrix
extends SimpleJob {
    private GTViewSet viewSet;
    private GTView view;
    private boolean[] chromosomes;
    private ArrayList<Integer> indices;
    private ArrayList<int[]> viewMarkers;
    private float[][] stMatrix;
    private SimilarityScore ss;
    private SimMatrix matrix = new SimMatrix();
    private AtomicInteger count = new AtomicInteger(0);
    private boolean useCache;

    public CalculateSimilarityMatrix(GTViewSet viewSet, GTView view, boolean[] chromosomes, boolean useCache) {
        this.viewSet = viewSet;
        this.view = view;
        this.chromosomes = chromosomes;
        this.useCache = useCache;
        this.indices = new ArrayList();
        for (int i = 0; i < viewSet.getLines().size(); ++i) {
            if (this.skipLine(i)) continue;
            this.indices.add(i);
            this.matrix.getLineInfos().add(view.getLineInfo(i));
        }
        this.maximum = (int)(Math.pow(this.indices.size(), 2.0) / 2.0);
    }

    public SimMatrix getMatrix() {
        return this.matrix;
    }

    public int getValue() {
        return this.count.intValue();
    }

    public void runJob(int index) throws Exception {
        long s = System.currentTimeMillis();
        this.viewMarkers = new ArrayList();
        for (int i = 0; i < this.viewSet.getViews().size(); ++i) {
            if (!this.chromosomes[i]) continue;
            this.viewMarkers.add(this.selectedMarkers(this.viewSet.getView(i)));
        }
        this.stMatrix = this.viewSet.getDataSet().getStateTable().calculateSimilarityMatrix();
        this.ss = new SimilarityScore(this.viewSet, this.stMatrix, this.chromosomes);
        this.matrix.initialize(this.indices.size());
        int cores = Runtime.getRuntime().availableProcessors();
        ExecutorService executor = Executors.newFixedThreadPool(cores);
        Future[] tasks = new Future[cores];
        System.out.println("Calculating similarity matrix...");
        for (int i = 0; i < tasks.length; ++i) {
            tasks[i] = executor.submit(new Calculator(i, cores));
        }
        for (Future task : tasks) {
            task.get();
        }
        if (this.okToRun) {
            this.viewSet.getMatrices().add(this.matrix);
            long e = System.currentTimeMillis();
            System.out.println("SimMatrix time: " + (e - s) + "ms");
            if (this.useCache) {
                ProjectSerializerDB.cacheToDisk(this.matrix);
            }
        }
    }

    public String getMessage() {
        return RB.format((String)"gui.MenuAnalysis.simMatrix.message", (Object[])new Object[]{this.count});
    }

    private boolean skipLine(int i) {
        if (this.view.isDummyLine(i) || this.view.isSplitter(i) || this.view.isDuplicate(i)) {
            return true;
        }
        return !this.view.isLineSelected(i);
    }

    private int[] selectedMarkers(GTView view) {
        int[] selected = new int[view.countSelectedMarkers()];
        int j = 0;
        for (int i = 0; i < view.getMarkers().size(); ++i) {
            if (view.getMarkerInfo(i).dummyMarker() || !view.isMarkerSelected(i)) continue;
            selected[j++] = view.getMarkerInfo(i).getIndex();
        }
        return selected;
    }

    private class Calculator
    implements Runnable {
        private int i;
        private int cores;

        Calculator(int i, int cores) {
            this.i = i;
            this.cores = cores;
        }

        @Override
        public void run() {
            int indicesSize = CalculateSimilarityMatrix.this.indices.size();
            while (this.i < indicesSize && CalculateSimilarityMatrix.this.okToRun) {
                for (int j = 0; j < this.i && CalculateSimilarityMatrix.this.okToRun; ++j) {
                    int a = (Integer)CalculateSimilarityMatrix.this.indices.get(this.i);
                    int b = (Integer)CalculateSimilarityMatrix.this.indices.get(j);
                    float score = CalculateSimilarityMatrix.this.ss.getScore(this.getData(a), this.getData(b), CalculateSimilarityMatrix.this.viewMarkers);
                    CalculateSimilarityMatrix.this.matrix.setValueAt(this.i, j, score);
                    CalculateSimilarityMatrix.this.count.getAndIncrement();
                }
                this.i += this.cores;
            }
        }

        private ArrayList<GenotypeData> getData(int lineIndex) {
            Line line = CalculateSimilarityMatrix.this.viewSet.getLines().get(lineIndex).getLine();
            ArrayList<GenotypeData> data = new ArrayList<GenotypeData>();
            for (int i = 0; i < CalculateSimilarityMatrix.this.chromosomes.length; ++i) {
                if (!CalculateSimilarityMatrix.this.chromosomes[i]) continue;
                data.add(line.getGenotypes().get(i));
            }
            return data;
        }
    }
}

