/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDByteArray;
import ch.systemsx.cisd.base.mdarray.MDDoubleArray;
import ch.systemsx.cisd.base.mdarray.MDFloatArray;
import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.base.mdarray.MDLongArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5BooleanWriter;
import ch.systemsx.cisd.hdf5.HDF5ByteWriter;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5CompoundType;
import ch.systemsx.cisd.hdf5.HDF5CompoundWriter;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5DataType;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5DateTimeWriter;
import ch.systemsx.cisd.hdf5.HDF5DoubleWriter;
import ch.systemsx.cisd.hdf5.HDF5EnumWriter;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValue;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueArray;
import ch.systemsx.cisd.hdf5.HDF5FileLevelReadWriteHandler;
import ch.systemsx.cisd.hdf5.HDF5FloatStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5FloatWriter;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntWriter;
import ch.systemsx.cisd.hdf5.HDF5LinkInformation;
import ch.systemsx.cisd.hdf5.HDF5LongReader;
import ch.systemsx.cisd.hdf5.HDF5LongWriter;
import ch.systemsx.cisd.hdf5.HDF5ObjectInformation;
import ch.systemsx.cisd.hdf5.HDF5ObjectReadWriteInfoProviderHandler;
import ch.systemsx.cisd.hdf5.HDF5ObjectType;
import ch.systemsx.cisd.hdf5.HDF5OpaqueType;
import ch.systemsx.cisd.hdf5.HDF5OpaqueWriter;
import ch.systemsx.cisd.hdf5.HDF5Reader;
import ch.systemsx.cisd.hdf5.HDF5ReferenceWriter;
import ch.systemsx.cisd.hdf5.HDF5ShortWriter;
import ch.systemsx.cisd.hdf5.HDF5StringWriter;
import ch.systemsx.cisd.hdf5.HDF5TimeDuration;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationArray;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationWriter;
import ch.systemsx.cisd.hdf5.HDF5TimeUnit;
import ch.systemsx.cisd.hdf5.HDF5UnsignedByteWriter;
import ch.systemsx.cisd.hdf5.HDF5UnsignedIntWriter;
import ch.systemsx.cisd.hdf5.HDF5UnsignedLongWriter;
import ch.systemsx.cisd.hdf5.HDF5UnsignedShortWriter;
import ch.systemsx.cisd.hdf5.IHDF5BooleanWriter;
import ch.systemsx.cisd.hdf5.IHDF5ByteWriter;
import ch.systemsx.cisd.hdf5.IHDF5CompoundInformationRetriever;
import ch.systemsx.cisd.hdf5.IHDF5CompoundWriter;
import ch.systemsx.cisd.hdf5.IHDF5DateTimeWriter;
import ch.systemsx.cisd.hdf5.IHDF5DoubleWriter;
import ch.systemsx.cisd.hdf5.IHDF5EnumWriter;
import ch.systemsx.cisd.hdf5.IHDF5FileLevelReadWriteHandler;
import ch.systemsx.cisd.hdf5.IHDF5FloatWriter;
import ch.systemsx.cisd.hdf5.IHDF5IntWriter;
import ch.systemsx.cisd.hdf5.IHDF5LongWriter;
import ch.systemsx.cisd.hdf5.IHDF5ObjectReadWriteInfoProviderHandler;
import ch.systemsx.cisd.hdf5.IHDF5OpaqueWriter;
import ch.systemsx.cisd.hdf5.IHDF5ReferenceWriter;
import ch.systemsx.cisd.hdf5.IHDF5ShortWriter;
import ch.systemsx.cisd.hdf5.IHDF5StringWriter;
import ch.systemsx.cisd.hdf5.IHDF5TimeDurationWriter;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import java.io.Flushable;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;
import ncsa.hdf.hdf5lib.exceptions.HDF5SymbolTableException;

final class HDF5Writer
extends HDF5Reader
implements IHDF5Writer {
    private final HDF5BaseWriter baseWriter;
    private final IHDF5FileLevelReadWriteHandler fileHandler;
    private final IHDF5ObjectReadWriteInfoProviderHandler objectHandler;
    private final IHDF5ByteWriter byteWriter;
    private final IHDF5ByteWriter ubyteWriter;
    private final IHDF5ShortWriter shortWriter;
    private final IHDF5ShortWriter ushortWriter;
    private final IHDF5IntWriter intWriter;
    private final IHDF5IntWriter uintWriter;
    private final IHDF5LongWriter longWriter;
    private final IHDF5LongWriter ulongWriter;
    private final IHDF5FloatWriter floatWriter;
    private final IHDF5DoubleWriter doubleWriter;
    private final IHDF5BooleanWriter booleanWriter;
    private final IHDF5StringWriter stringWriter;
    private final IHDF5EnumWriter enumWriter;
    private final IHDF5CompoundWriter compoundWriter;
    private final IHDF5DateTimeWriter dateTimeWriter;
    private final HDF5TimeDurationWriter timeDurationWriter;
    private final IHDF5ReferenceWriter referenceWriter;
    private final IHDF5OpaqueWriter opaqueWriter;

    HDF5Writer(HDF5BaseWriter baseWriter) {
        super(baseWriter);
        this.baseWriter = baseWriter;
        this.fileHandler = new HDF5FileLevelReadWriteHandler(baseWriter);
        this.objectHandler = new HDF5ObjectReadWriteInfoProviderHandler(baseWriter);
        this.byteWriter = new HDF5ByteWriter(baseWriter);
        this.ubyteWriter = new HDF5UnsignedByteWriter(baseWriter);
        this.shortWriter = new HDF5ShortWriter(baseWriter);
        this.ushortWriter = new HDF5UnsignedShortWriter(baseWriter);
        this.intWriter = new HDF5IntWriter(baseWriter);
        this.uintWriter = new HDF5UnsignedIntWriter(baseWriter);
        this.longWriter = new HDF5LongWriter(baseWriter);
        this.ulongWriter = new HDF5UnsignedLongWriter(baseWriter);
        this.floatWriter = new HDF5FloatWriter(baseWriter);
        this.doubleWriter = new HDF5DoubleWriter(baseWriter);
        this.booleanWriter = new HDF5BooleanWriter(baseWriter);
        this.stringWriter = new HDF5StringWriter(baseWriter);
        this.enumWriter = new HDF5EnumWriter(baseWriter);
        this.compoundWriter = new HDF5CompoundWriter(baseWriter, this.enumWriter);
        this.dateTimeWriter = new HDF5DateTimeWriter(baseWriter, (HDF5LongReader)this.longReader);
        this.timeDurationWriter = new HDF5TimeDurationWriter(baseWriter, (HDF5LongReader)this.longReader);
        this.referenceWriter = new HDF5ReferenceWriter(baseWriter);
        this.opaqueWriter = new HDF5OpaqueWriter(baseWriter);
    }

    HDF5BaseWriter getBaseWriter() {
        return this.baseWriter;
    }

    @Override
    public IHDF5FileLevelReadWriteHandler file() {
        return this.fileHandler;
    }

    @Override
    public boolean isUseExtendableDataTypes() {
        return this.baseWriter.useExtentableDataTypes;
    }

    @Override
    public IHDF5WriterConfigurator.FileFormat getFileFormat() {
        return this.baseWriter.fileFormat;
    }

    @Override
    public void flush() {
        this.baseWriter.checkOpen();
        this.baseWriter.flush();
    }

    @Override
    public void flushSyncBlocking() {
        this.baseWriter.checkOpen();
        this.baseWriter.flushSyncBlocking();
    }

    @Override
    public boolean addFlushable(Flushable flushable) {
        return this.baseWriter.addFlushable(flushable);
    }

    @Override
    public boolean removeFlushable(Flushable flushable) {
        return this.baseWriter.removeFlushable(flushable);
    }

    @Override
    public IHDF5ObjectReadWriteInfoProviderHandler object() {
        return this.objectHandler;
    }

    @Override
    public HDF5LinkInformation getLinkInformation(String objectPath) {
        return this.objectHandler.getLinkInformation(objectPath);
    }

    @Override
    public void createHardLink(String currentPath, String newPath) {
        this.objectHandler.createHardLink(currentPath, newPath);
    }

    @Override
    public HDF5ObjectInformation getObjectInformation(String objectPath) {
        return this.objectHandler.getObjectInformation(objectPath);
    }

    @Override
    public void createSoftLink(String targetPath, String linkPath) {
        this.objectHandler.createSoftLink(targetPath, linkPath);
    }

    @Override
    public void createOrUpdateSoftLink(String targetPath, String linkPath) {
        this.objectHandler.createOrUpdateSoftLink(targetPath, linkPath);
    }

    @Override
    public HDF5ObjectType getObjectType(String objectPath, boolean followLink) {
        return this.objectHandler.getObjectType(objectPath, followLink);
    }

    @Override
    public void createExternalLink(String targetFileName, String targetPath, String linkPath) throws IllegalStateException {
        this.objectHandler.createExternalLink(targetFileName, targetPath, linkPath);
    }

    @Override
    public HDF5ObjectType getObjectType(String objectPath) {
        return this.objectHandler.getObjectType(objectPath);
    }

    @Override
    public boolean exists(String objectPath, boolean followLink) {
        return this.objectHandler.exists(objectPath, followLink);
    }

    @Override
    public boolean exists(String objectPath) {
        return this.objectHandler.exists(objectPath);
    }

    @Override
    public void createOrUpdateExternalLink(String targetFileName, String targetPath, String linkPath) throws IllegalStateException {
        this.objectHandler.createOrUpdateExternalLink(targetFileName, targetPath, linkPath);
    }

    @Override
    public String toHouseKeepingPath(String objectPath) {
        return this.objectHandler.toHouseKeepingPath(objectPath);
    }

    @Override
    public boolean isHouseKeepingObject(String objectPath) {
        return this.objectHandler.isHouseKeepingObject(objectPath);
    }

    @Override
    public boolean isGroup(String objectPath, boolean followLink) {
        return this.objectHandler.isGroup(objectPath, followLink);
    }

    @Override
    public boolean isGroup(String objectPath) {
        return this.objectHandler.isGroup(objectPath);
    }

    @Override
    public void delete(String objectPath) {
        this.objectHandler.delete(objectPath);
    }

    @Override
    public void move(String oldLinkPath, String newLinkPath) throws HDF5SymbolTableException {
        this.objectHandler.move(oldLinkPath, newLinkPath);
    }

    @Override
    public boolean isDataSet(String objectPath, boolean followLink) {
        return this.objectHandler.isDataSet(objectPath, followLink);
    }

    @Override
    public void createGroup(String groupPath) {
        this.objectHandler.createGroup(groupPath);
    }

    @Override
    public boolean isDataSet(String objectPath) {
        return this.objectHandler.isDataSet(objectPath);
    }

    @Override
    public void createGroup(String groupPath, int sizeHint) {
        this.objectHandler.createGroup(groupPath, sizeHint);
    }

    @Override
    public boolean isDataType(String objectPath, boolean followLink) {
        return this.objectHandler.isDataType(objectPath, followLink);
    }

    @Override
    public boolean isDataType(String objectPath) {
        return this.objectHandler.isDataType(objectPath);
    }

    @Override
    public void createGroup(String groupPath, int maxCompact, int minDense) {
        this.objectHandler.createGroup(groupPath, maxCompact, minDense);
    }

    @Override
    public boolean isSoftLink(String objectPath) {
        return this.objectHandler.isSoftLink(objectPath);
    }

    @Override
    public boolean isExternalLink(String objectPath) {
        return this.objectHandler.isExternalLink(objectPath);
    }

    @Override
    public boolean isSymbolicLink(String objectPath) {
        return this.objectHandler.isSymbolicLink(objectPath);
    }

    @Override
    public String tryGetSymbolicLinkTarget(String objectPath) {
        return this.objectHandler.tryGetSymbolicLinkTarget(objectPath);
    }

    @Override
    public void setDataSetSize(String objectPath, long newSize) {
        this.objectHandler.setDataSetSize(objectPath, newSize);
    }

    @Override
    public boolean hasAttribute(String objectPath, String attributeName) {
        return this.objectHandler.hasAttribute(objectPath, attributeName);
    }

    @Override
    public void setDataSetDimensions(String objectPath, long[] newDimensions) {
        this.objectHandler.setDataSetDimensions(objectPath, newDimensions);
    }

    @Override
    public List<String> getAttributeNames(String objectPath) {
        return this.objectHandler.getAttributeNames(objectPath);
    }

    @Override
    public void setTypeVariant(String objectPath, HDF5DataTypeVariant typeVariant) {
        this.objectHandler.setTypeVariant(objectPath, typeVariant);
    }

    @Override
    public List<String> getAllAttributeNames(String objectPath) {
        return this.objectHandler.getAllAttributeNames(objectPath);
    }

    @Override
    public void setTypeVariant(String objectPath, String attributeName, HDF5DataTypeVariant typeVariant) {
        this.objectHandler.setTypeVariant(objectPath, attributeName, typeVariant);
    }

    @Override
    public HDF5DataTypeInformation getAttributeInformation(String objectPath, String attributeName) {
        return this.objectHandler.getAttributeInformation(objectPath, attributeName);
    }

    @Override
    public void deleteTypeVariant(String objectPath) {
        this.objectHandler.deleteTypeVariant(objectPath);
    }

    @Override
    public void deleteTypeVariant(String objectPath, String attributeName) {
        this.objectHandler.deleteTypeVariant(objectPath, attributeName);
    }

    @Override
    public HDF5DataTypeInformation getAttributeInformation(String objectPath, String attributeName, HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions) {
        return this.objectHandler.getAttributeInformation(objectPath, attributeName, dataTypeInfoOptions);
    }

    @Override
    public void deleteAttribute(String objectPath, String name) {
        this.objectHandler.deleteAttribute(objectPath, name);
    }

    @Override
    public HDF5DataSetInformation getDataSetInformation(String dataSetPath) {
        return this.objectHandler.getDataSetInformation(dataSetPath);
    }

    @Override
    public HDF5DataSetInformation getDataSetInformation(String dataSetPath, HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions) {
        return this.objectHandler.getDataSetInformation(dataSetPath, dataTypeInfoOptions);
    }

    @Override
    public long getSize(String objectPath) {
        return this.objectHandler.getSize(objectPath);
    }

    @Override
    public long getNumberOfElements(String objectPath) {
        return this.objectHandler.getNumberOfElements(objectPath);
    }

    @Override
    public void copy(String sourceObject, IHDF5Writer destinationWriter, String destinationObject) {
        this.objectHandler.copy(sourceObject, destinationWriter, destinationObject);
    }

    @Override
    public void copy(String sourceObject, IHDF5Writer destinationWriter) {
        this.objectHandler.copy(sourceObject, destinationWriter);
    }

    @Override
    public void copyAll(IHDF5Writer destinationWriter) {
        this.objectHandler.copyAll(destinationWriter);
    }

    @Override
    public List<String> getGroupMembers(String groupPath) {
        return this.objectHandler.getGroupMembers(groupPath);
    }

    @Override
    public List<String> getAllGroupMembers(String groupPath) {
        return this.objectHandler.getAllGroupMembers(groupPath);
    }

    @Override
    public List<String> getGroupMemberPaths(String groupPath) {
        return this.objectHandler.getGroupMemberPaths(groupPath);
    }

    @Override
    public List<HDF5LinkInformation> getGroupMemberInformation(String groupPath, boolean readLinkTargets) {
        return this.objectHandler.getGroupMemberInformation(groupPath, readLinkTargets);
    }

    @Override
    public List<HDF5LinkInformation> getAllGroupMemberInformation(String groupPath, boolean readLinkTargets) {
        return this.objectHandler.getAllGroupMemberInformation(groupPath, readLinkTargets);
    }

    @Override
    public HDF5DataTypeVariant tryGetTypeVariant(String objectPath) {
        return this.objectHandler.tryGetTypeVariant(objectPath);
    }

    @Override
    public HDF5DataTypeVariant tryGetTypeVariant(String objectPath, String attributeName) {
        return this.objectHandler.tryGetTypeVariant(objectPath, attributeName);
    }

    @Override
    public String tryGetDataTypePath(String objectPath) {
        return this.objectHandler.tryGetDataTypePath(objectPath);
    }

    @Override
    public String tryGetDataTypePath(HDF5DataType type) {
        return this.objectHandler.tryGetDataTypePath(type);
    }

    @Override
    public void setBooleanAttribute(String objectPath, String name, boolean value) {
        this.booleanWriter.setAttr(objectPath, name, value);
    }

    @Override
    public IHDF5BooleanWriter bool() {
        return this.booleanWriter;
    }

    @Override
    public void writeBitField(String objectPath, BitSet data, HDF5GenericStorageFeatures features) {
        this.booleanWriter.writeBitField(objectPath, data, features);
    }

    @Override
    public void writeBitField(String objectPath, BitSet data) {
        this.booleanWriter.writeBitField(objectPath, data);
    }

    @Override
    public void writeBoolean(String objectPath, boolean value) {
        this.booleanWriter.write(objectPath, value);
    }

    @Override
    public void createBitField(String objectPath, int size) {
        this.booleanWriter.createBitField(objectPath, size);
    }

    @Override
    public void createBitField(String objectPath, long size, int blockSize) {
        this.booleanWriter.createBitField(objectPath, size, blockSize);
    }

    @Override
    public void createBitField(String objectPath, int size, HDF5IntStorageFeatures features) {
        this.booleanWriter.createBitField(objectPath, size, HDF5GenericStorageFeatures.build(features).features());
    }

    @Override
    public void createBitField(String objectPath, long size, int blockSize, HDF5IntStorageFeatures features) {
        this.booleanWriter.createBitField(objectPath, size, blockSize, HDF5GenericStorageFeatures.build(features).features());
    }

    @Override
    public void writeBitFieldBlock(String objectPath, BitSet data, int dataSize, long blockNumber) {
        this.booleanWriter.writeBitFieldBlock(objectPath, data, dataSize, blockNumber);
    }

    @Override
    public void writeBitFieldBlockWithOffset(String objectPath, BitSet data, int dataSize, long offset) {
        this.booleanWriter.writeBitFieldBlockWithOffset(objectPath, data, dataSize, offset);
    }

    @Override
    public IHDF5OpaqueWriter opaque() {
        return this.opaqueWriter;
    }

    @Override
    public HDF5OpaqueType createOpaqueByteArray(String objectPath, String tag, int size, HDF5GenericStorageFeatures features) {
        return this.opaqueWriter.createArray(objectPath, tag, size, features);
    }

    @Override
    public HDF5OpaqueType createOpaqueByteArray(String objectPath, String tag, int size) {
        return this.opaqueWriter.createArray(objectPath, tag, size);
    }

    @Override
    public HDF5OpaqueType createOpaqueByteArray(String objectPath, String tag, long size, int blockSize, HDF5GenericStorageFeatures features) {
        return this.opaqueWriter.createArray(objectPath, tag, size, blockSize, features);
    }

    @Override
    public HDF5OpaqueType createOpaqueByteArray(String objectPath, String tag, long size, int blockSize) {
        return this.opaqueWriter.createArray(objectPath, tag, size, blockSize);
    }

    @Override
    public void writeOpaqueByteArray(String objectPath, String tag, byte[] data, HDF5GenericStorageFeatures features) {
        this.opaqueWriter.writeArray(objectPath, tag, data, features);
    }

    @Override
    public void writeOpaqueByteArray(String objectPath, String tag, byte[] data) {
        this.opaqueWriter.writeArray(objectPath, tag, data);
    }

    @Override
    public void writeOpaqueByteArrayBlock(String objectPath, HDF5OpaqueType dataType, byte[] data, long blockNumber) {
        this.opaqueWriter.writeArrayBlock(objectPath, dataType, data, blockNumber);
    }

    @Override
    public void writeOpaqueByteArrayBlockWithOffset(String objectPath, HDF5OpaqueType dataType, byte[] data, int dataSize, long offset) {
        this.opaqueWriter.writeArrayBlockWithOffset(objectPath, dataType, data, dataSize, offset);
    }

    @Override
    public IHDF5DateTimeWriter time() {
        return this.dateTimeWriter;
    }

    @Override
    public IHDF5TimeDurationWriter duration() {
        return this.timeDurationWriter;
    }

    @Override
    public void createTimeStampArray(String objectPath, int size, HDF5GenericStorageFeatures features) {
        this.dateTimeWriter.createArray(objectPath, size, features);
    }

    @Override
    public void setTimeStampAttribute(String objectPath, String name, long value) {
        this.dateTimeWriter.setAttr(objectPath, name, value);
    }

    @Override
    public void setDateAttribute(String objectPath, String name, Date date) {
        this.dateTimeWriter.setAttr(objectPath, name, date);
    }

    @Override
    public void setTimeDurationAttribute(String objectPath, String name, HDF5TimeDuration timeDuration) {
        this.timeDurationWriter.setAttr(objectPath, name, timeDuration);
    }

    @Override
    public void setTimeDurationAttribute(String objectPath, String name, long timeDuration, HDF5TimeUnit timeUnit) {
        this.timeDurationWriter.setAttr(objectPath, name, timeDuration, timeUnit);
    }

    @Override
    public void setDateArrayAttribute(String objectPath, String name, Date[] dates) {
        this.dateTimeWriter.setArrayAttr(objectPath, name, dates);
    }

    @Override
    public void setTimeStampArrayAttribute(String objectPath, String name, long[] timeStamps) {
        this.dateTimeWriter.setArrayAttr(objectPath, name, timeStamps);
    }

    @Override
    public void setTimeDurationArrayAttribute(String objectPath, String name, HDF5TimeDurationArray timeDurations) {
        this.timeDurationWriter.setArrayAttr(objectPath, name, timeDurations);
    }

    @Override
    public void createTimeStampArray(String objectPath, int size) {
        this.dateTimeWriter.createArray(objectPath, size);
    }

    @Override
    public void createTimeStampArray(String objectPath, long size, int blockSize, HDF5GenericStorageFeatures features) {
        this.dateTimeWriter.createArray(objectPath, size, blockSize, features);
    }

    @Override
    public void createTimeStampArray(String objectPath, long size, int blockSize) {
        this.dateTimeWriter.createArray(objectPath, size, blockSize);
    }

    @Override
    public void writeDate(String objectPath, Date date) {
        this.dateTimeWriter.write(objectPath, date);
    }

    @Override
    public void writeDateArray(String objectPath, Date[] dates, HDF5GenericStorageFeatures features) {
        this.dateTimeWriter.writeArray(objectPath, dates, features);
    }

    @Override
    public void writeDateArray(String objectPath, Date[] dates) {
        this.dateTimeWriter.writeArray(objectPath, dates);
    }

    @Override
    public void writeTimeStamp(String objectPath, long timeStamp) {
        this.dateTimeWriter.write(objectPath, timeStamp);
    }

    @Override
    public void writeTimeStampArray(String objectPath, long[] timeStamps, HDF5GenericStorageFeatures features) {
        this.dateTimeWriter.writeArray(objectPath, timeStamps, features);
    }

    @Override
    public void writeTimeStampArray(String objectPath, long[] timeStamps) {
        this.dateTimeWriter.writeArray(objectPath, timeStamps);
    }

    @Override
    public void writeTimeStampArrayBlock(String objectPath, long[] data, long blockNumber) {
        this.dateTimeWriter.writeArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeTimeStampArrayBlockWithOffset(String objectPath, long[] data, int dataSize, long offset) {
        this.dateTimeWriter.writeArrayBlockWithOffset(objectPath, data, dataSize, offset);
    }

    @Override
    public void createTimeDurationArray(String objectPath, int size, HDF5TimeUnit timeUnit, HDF5GenericStorageFeatures features) {
        this.timeDurationWriter.createArray(objectPath, size, timeUnit, features);
    }

    @Override
    public void createTimeDurationArray(String objectPath, int size, HDF5TimeUnit timeUnit) {
        this.timeDurationWriter.createArray(objectPath, size, timeUnit);
    }

    @Override
    public void createTimeDurationArray(String objectPath, long size, int blockSize, HDF5TimeUnit timeUnit, HDF5GenericStorageFeatures features) {
        this.timeDurationWriter.createArray(objectPath, size, blockSize, timeUnit, features);
    }

    @Override
    public void createTimeDurationArray(String objectPath, long size, int blockSize, HDF5TimeUnit timeUnit) {
        this.timeDurationWriter.createArray(objectPath, size, blockSize, timeUnit);
    }

    @Override
    public void writeTimeDuration(String objectPath, long timeDuration, HDF5TimeUnit timeUnit) {
        this.timeDurationWriter.write(objectPath, timeDuration, timeUnit);
    }

    @Override
    public void writeTimeDuration(String objectPath, HDF5TimeDuration timeDuration) {
        this.timeDurationWriter.write(objectPath, timeDuration);
    }

    @Override
    @Deprecated
    public void writeTimeDuration(String objectPath, long timeDuration) {
        this.timeDurationWriter.writeTimeDuration(objectPath, timeDuration);
    }

    @Override
    @Deprecated
    public void writeTimeDurationArray(String objectPath, long[] timeDurations, HDF5TimeUnit timeUnit, HDF5IntStorageFeatures features) {
        this.timeDurationWriter.writeTimeDurationArray(objectPath, timeDurations, timeUnit, features);
    }

    @Override
    public void writeTimeDurationArray(String objectPath, HDF5TimeDurationArray timeDurations) {
        this.timeDurationWriter.writeArray(objectPath, timeDurations);
    }

    @Override
    public void writeTimeDurationArray(String objectPath, HDF5TimeDurationArray timeDurations, HDF5IntStorageFeatures features) {
        this.timeDurationWriter.writeArray(objectPath, timeDurations, features);
    }

    @Override
    @Deprecated
    public void writeTimeDurationArray(String objectPath, long[] timeDurations, HDF5TimeUnit timeUnit) {
        this.timeDurationWriter.writeTimeDurationArray(objectPath, timeDurations, timeUnit);
    }

    @Override
    @Deprecated
    public void writeTimeDurationArray(String objectPath, long[] timeDurations) {
        this.timeDurationWriter.writeTimeDurationArray(objectPath, timeDurations);
    }

    @Override
    @Deprecated
    public void writeTimeDurationArray(String objectPath, HDF5TimeDuration[] timeDurations) {
        this.timeDurationWriter.writeTimeDurationArray(objectPath, timeDurations);
    }

    @Override
    @Deprecated
    public void writeTimeDurationArray(String objectPath, HDF5TimeDuration[] timeDurations, HDF5IntStorageFeatures features) {
        this.timeDurationWriter.writeTimeDurationArray(objectPath, timeDurations, features);
    }

    @Override
    public void writeTimeDurationArrayBlock(String objectPath, HDF5TimeDurationArray data, long blockNumber) {
        this.timeDurationWriter.writeArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeTimeDurationArrayBlockWithOffset(String objectPath, HDF5TimeDurationArray data, int dataSize, long offset) {
        this.timeDurationWriter.writeArrayBlockWithOffset(objectPath, data, dataSize, offset);
    }

    @Override
    @Deprecated
    public void writeTimeDurationArrayBlock(String objectPath, long[] data, long blockNumber, HDF5TimeUnit timeUnit) {
        this.timeDurationWriter.writeTimeDurationArrayBlock(objectPath, data, blockNumber, timeUnit);
    }

    @Override
    @Deprecated
    public void writeTimeDurationArrayBlockWithOffset(String objectPath, long[] data, int dataSize, long offset, HDF5TimeUnit timeUnit) {
        this.timeDurationWriter.writeTimeDurationArrayBlockWithOffset(objectPath, data, dataSize, offset, timeUnit);
    }

    @Override
    @Deprecated
    public void writeTimeDurationArrayBlock(String objectPath, HDF5TimeDuration[] data, long blockNumber) {
        this.timeDurationWriter.writeTimeDurationArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    @Deprecated
    public void writeTimeDurationArrayBlockWithOffset(String objectPath, HDF5TimeDuration[] data, int dataSize, long offset) {
        this.timeDurationWriter.writeTimeDurationArrayBlockWithOffset(objectPath, data, dataSize, offset);
    }

    @Override
    public IHDF5ReferenceWriter reference() {
        return this.referenceWriter;
    }

    @Override
    public void writeObjectReference(String objectPath, String referencedObjectPath) {
        this.referenceWriter.write(objectPath, referencedObjectPath);
    }

    @Override
    public void writeObjectReferenceArray(String objectPath, String[] referencedObjectPath) {
        this.referenceWriter.writeArray(objectPath, referencedObjectPath);
    }

    @Override
    public void writeObjectReferenceArray(String objectPath, String[] referencedObjectPath, HDF5IntStorageFeatures features) {
        this.referenceWriter.writeArray(objectPath, referencedObjectPath, features);
    }

    @Override
    public void writeObjectReferenceMDArray(String objectPath, MDArray<String> referencedObjectPaths) {
        this.referenceWriter.writeMDArray(objectPath, referencedObjectPaths);
    }

    @Override
    public void writeObjectReferenceMDArray(String objectPath, MDArray<String> referencedObjectPaths, HDF5IntStorageFeatures features) {
        this.referenceWriter.writeMDArray(objectPath, referencedObjectPaths, features);
    }

    @Override
    public void setObjectReferenceAttribute(String objectPath, String name, String referencedObjectPath) {
        this.referenceWriter.setAttr(objectPath, name, referencedObjectPath);
    }

    @Override
    public void setObjectReferenceArrayAttribute(String objectPath, String name, String[] value) {
        this.referenceWriter.setArrayAttr(objectPath, name, value);
    }

    @Override
    public IHDF5StringWriter string() {
        return this.stringWriter;
    }

    @Override
    public void setObjectReferenceMDArrayAttribute(String objectPath, String name, MDArray<String> referencedObjectPaths) {
        this.referenceWriter.setMDArrayAttr(objectPath, name, referencedObjectPaths);
    }

    @Override
    public void createObjectReferenceArray(String objectPath, int size) {
        this.referenceWriter.createArray(objectPath, size);
    }

    @Override
    public void createObjectReferenceArray(String objectPath, long size, int blockSize) {
        this.referenceWriter.createArray(objectPath, size, blockSize);
    }

    @Override
    public void createObjectReferenceArray(String objectPath, int size, HDF5IntStorageFeatures features) {
        this.referenceWriter.createArray(objectPath, size, features);
    }

    @Override
    public void createObjectReferenceArray(String objectPath, long size, int blockSize, HDF5IntStorageFeatures features) {
        this.referenceWriter.createArray(objectPath, size, blockSize, features);
    }

    @Override
    public void writeObjectReferenceArrayBlock(String objectPath, String[] referencedObjectPaths, long blockNumber) {
        this.referenceWriter.writeArrayBlock(objectPath, referencedObjectPaths, blockNumber);
    }

    @Override
    public void writeObjectReferenceArrayBlockWithOffset(String objectPath, String[] referencedObjectPaths, int dataSize, long offset) {
        this.referenceWriter.writeArrayBlockWithOffset(objectPath, referencedObjectPaths, dataSize, offset);
    }

    @Override
    public void createObjectReferenceMDArray(String objectPath, int[] dimensions) {
        this.referenceWriter.createMDArray(objectPath, dimensions);
    }

    @Override
    public void createObjectReferenceMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.referenceWriter.createMDArray(objectPath, dimensions, blockDimensions);
    }

    @Override
    public void createObjectReferenceMDArray(String objectPath, int[] dimensions, HDF5IntStorageFeatures features) {
        this.referenceWriter.createMDArray(objectPath, dimensions, features);
    }

    @Override
    public void createObjectReferenceMDArray(String objectPath, long[] dimensions, int[] blockDimensions, HDF5IntStorageFeatures features) {
        this.referenceWriter.createMDArray(objectPath, dimensions, blockDimensions, features);
    }

    @Override
    public void writeObjectReferenceMDArrayBlock(String objectPath, MDArray<String> referencedObjectPaths, long[] blockNumber) {
        this.referenceWriter.writeMDArrayBlock(objectPath, referencedObjectPaths, blockNumber);
    }

    @Override
    public void writeObjectReferenceMDArrayBlockWithOffset(String objectPath, MDArray<String> referencedObjectPaths, long[] offset) {
        this.referenceWriter.writeMDArrayBlockWithOffset(objectPath, referencedObjectPaths, offset);
    }

    @Override
    public void writeObjectReferenceMDArrayBlockWithOffset(String objectPath, MDLongArray data, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        this.referenceWriter.writeMDArrayBlockWithOffset(objectPath, data, blockDimensions, offset, memoryOffset);
    }

    @Override
    public void createStringArray(String objectPath, int maxLength, int size) {
        this.stringWriter.createArray(objectPath, maxLength, size);
    }

    @Override
    public void createStringArray(String objectPath, int maxLength, long size, int blockSize) {
        this.stringWriter.createArray(objectPath, maxLength, size, blockSize);
    }

    @Override
    public void createStringArray(String objectPath, int maxLength, int size, HDF5GenericStorageFeatures features) {
        this.stringWriter.createArray(objectPath, maxLength, size, features);
    }

    @Override
    public void createStringArray(String objectPath, int maxLength, long size, int blockSize, HDF5GenericStorageFeatures features) {
        this.stringWriter.createArray(objectPath, maxLength, size, blockSize, features);
    }

    @Override
    public void createStringVariableLengthArray(String objectPath, int size) {
        this.stringWriter.createArrayVL(objectPath, size);
    }

    @Override
    public void createStringVariableLengthArray(String objectPath, long size, int blockSize) {
        this.stringWriter.createArrayVL(objectPath, size, blockSize);
    }

    @Override
    public void createStringVariableLengthArray(String objectPath, long size, int blockSize, HDF5GenericStorageFeatures features) {
        this.stringWriter.createArrayVL(objectPath, size, blockSize, features);
    }

    @Override
    public void createStringVariableLengthArray(String objectPath, int size, HDF5GenericStorageFeatures features) {
        this.stringWriter.createArrayVL(objectPath, size, features);
    }

    @Override
    public void setStringAttribute(String objectPath, String name, String value) {
        this.stringWriter.setAttr(objectPath, name, value);
    }

    @Override
    public void setStringAttribute(String objectPath, String name, String value, int maxLength) {
        this.stringWriter.setAttr(objectPath, name, value, maxLength);
    }

    @Override
    public void setStringArrayAttribute(String objectPath, String name, String[] value, int maxLength) {
        this.stringWriter.setArrayAttr(objectPath, name, value, maxLength);
    }

    @Override
    public void setStringArrayAttribute(String objectPath, String name, String[] value) {
        this.stringWriter.setArrayAttr(objectPath, name, value);
    }

    @Override
    public void setStringMDArrayAttribute(String objectPath, String name, MDArray<String> value) {
        this.stringWriter.setMDArrayAttr(objectPath, name, value);
    }

    @Override
    public void setStringMDArrayAttribute(String objectPath, String name, MDArray<String> value, int maxLength) {
        this.stringWriter.setMDArrayAttr(objectPath, name, value, maxLength);
    }

    @Override
    public void setStringAttributeVariableLength(String objectPath, String name, String value) {
        this.stringWriter.setAttrVL(objectPath, name, value);
    }

    @Override
    public void writeString(String objectPath, String data, int maxLength) {
        this.stringWriter.write(objectPath, data, maxLength);
    }

    @Override
    public void writeString(String objectPath, String data) {
        this.stringWriter.write(objectPath, data);
    }

    @Override
    public void writeString(String objectPath, String data, HDF5GenericStorageFeatures features) {
        this.stringWriter.write(objectPath, data, features);
    }

    @Override
    public void writeString(String objectPath, String data, int maxLength, HDF5GenericStorageFeatures features) {
        this.stringWriter.write(objectPath, data, maxLength, features);
    }

    @Override
    public void writeStringArray(String objectPath, String[] data, HDF5GenericStorageFeatures features) {
        this.stringWriter.writeArray(objectPath, data, features);
    }

    @Override
    public void writeStringArray(String objectPath, String[] data) {
        this.stringWriter.writeArray(objectPath, data);
    }

    @Override
    public void writeStringArray(String objectPath, String[] data, int maxLength) {
        this.stringWriter.writeArray(objectPath, data, maxLength);
    }

    @Override
    public void writeStringArray(String objectPath, String[] data, int maxLength, HDF5GenericStorageFeatures features) {
        this.stringWriter.writeArray(objectPath, data, maxLength, features);
    }

    @Override
    public void createStringMDArray(String objectPath, int maxLength, int[] dimensions, HDF5GenericStorageFeatures features) {
        this.stringWriter.createMDArray(objectPath, maxLength, dimensions, features);
    }

    @Override
    public void createStringMDArray(String objectPath, int maxLength, int[] dimensions) {
        this.stringWriter.createMDArray(objectPath, maxLength, dimensions);
    }

    @Override
    public void createStringMDArray(String objectPath, int maxLength, long[] dimensions, int[] blockSize, HDF5GenericStorageFeatures features) {
        this.stringWriter.createMDArray(objectPath, maxLength, dimensions, blockSize, features);
    }

    @Override
    public void createStringMDArray(String objectPath, int maxLength, long[] dimensions, int[] blockSize) {
        this.stringWriter.createMDArray(objectPath, maxLength, dimensions, blockSize);
    }

    @Override
    public void writeStringMDArray(String objectPath, MDArray<String> data, int maxLength) {
        this.stringWriter.writeMDArray(objectPath, data, maxLength);
    }

    @Override
    public void writeStringMDArray(String objectPath, MDArray<String> data) {
        this.stringWriter.writeMDArray(objectPath, data);
    }

    @Override
    public void writeStringMDArray(String objectPath, MDArray<String> data, HDF5GenericStorageFeatures features) {
        this.stringWriter.writeMDArray(objectPath, data, features);
    }

    @Override
    public void writeStringMDArray(String objectPath, MDArray<String> data, int maxLength, HDF5GenericStorageFeatures features) {
        this.stringWriter.writeMDArray(objectPath, data, maxLength, features);
    }

    @Override
    public void writeStringArrayBlock(String objectPath, String[] data, long blockNumber) {
        this.stringWriter.writeArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeStringArrayBlockWithOffset(String objectPath, String[] data, int dataSize, long offset) {
        this.stringWriter.writeArrayBlockWithOffset(objectPath, data, dataSize, offset);
    }

    @Override
    public void writeStringMDArrayBlock(String objectPath, MDArray<String> data, long[] blockNumber) {
        this.stringWriter.writeMDArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeStringMDArrayBlockWithOffset(String objectPath, MDArray<String> data, long[] offset) {
        this.stringWriter.writeMDArrayBlockWithOffset(objectPath, data, offset);
    }

    @Override
    public void writeStringVariableLength(String objectPath, String data) {
        this.stringWriter.writeVL(objectPath, data);
    }

    @Override
    public void writeStringVariableLengthArray(String objectPath, String[] data) {
        this.stringWriter.writeArrayVL(objectPath, data);
    }

    @Override
    public void writeStringVariableLengthArray(String objectPath, String[] data, HDF5GenericStorageFeatures features) {
        this.stringWriter.writeArrayVL(objectPath, data, features);
    }

    @Override
    public void writeStringVariableLengthMDArray(String objectPath, MDArray<String> data, HDF5GenericStorageFeatures features) {
        this.stringWriter.writeMDArrayVL(objectPath, data, features);
    }

    @Override
    public void writeStringVariableLengthMDArray(String objectPath, MDArray<String> data) {
        this.stringWriter.writeMDArrayVL(objectPath, data);
    }

    @Override
    public void createStringVariableLengthMDArray(String objectPath, int[] dimensions, HDF5GenericStorageFeatures features) {
        this.stringWriter.createMDArrayVL(objectPath, dimensions, features);
    }

    @Override
    public void createStringVariableLengthMDArray(String objectPath, int[] dimensions) {
        this.stringWriter.createMDArrayVL(objectPath, dimensions);
    }

    @Override
    public void createStringVariableLengthMDArray(String objectPath, long[] dimensions, int[] blockSize, HDF5GenericStorageFeatures features) {
        this.stringWriter.createMDArrayVL(objectPath, dimensions, blockSize, features);
    }

    @Override
    public void createStringVariableLengthMDArray(String objectPath, long[] dimensions, int[] blockSize) {
        this.stringWriter.createMDArrayVL(objectPath, dimensions, blockSize);
    }

    @Override
    public IHDF5EnumWriter enums() {
        return this.enumWriter;
    }

    @Override
    public IHDF5EnumWriter enumeration() {
        return this.enumWriter;
    }

    @Override
    public HDF5EnumerationType getEnumType(String name, String[] values) throws HDF5JavaException {
        return this.enumWriter.getType(name, values);
    }

    @Override
    public HDF5EnumerationType getEnumType(String name, String[] values, boolean check) throws HDF5JavaException {
        return this.enumWriter.getType(name, values, check);
    }

    @Override
    public HDF5EnumerationType createEnumArray(String objectPath, HDF5EnumerationType enumType, int size) {
        return this.enumWriter.createArray(objectPath, enumType, size);
    }

    @Override
    public HDF5EnumerationType createEnumArray(String objectPath, HDF5EnumerationType enumType, long size, HDF5IntStorageFeatures features) {
        return this.enumWriter.createArray(objectPath, enumType, size, features);
    }

    @Override
    public HDF5EnumerationType createEnumArray(String objectPath, HDF5EnumerationType enumType, long size, int blockSize, HDF5IntStorageFeatures features) {
        return this.enumWriter.createArray(objectPath, enumType, size, blockSize, features);
    }

    @Override
    public HDF5EnumerationType createEnumArray(String objectPath, HDF5EnumerationType enumType, long size, int blockSize) {
        return this.enumWriter.createArray(objectPath, enumType, size, blockSize);
    }

    @Override
    public void setEnumAttribute(String objectPath, String name, HDF5EnumerationValue value) {
        this.enumWriter.setAttr(objectPath, name, value);
    }

    @Override
    public void setEnumAttribute(String objectPath, String name, Enum<?> value) throws HDF5JavaException {
        this.enumWriter.setAttr(objectPath, name, value);
    }

    @Override
    public <T extends Enum<T>> void writeEnum(String objectPath, Enum<T> value) throws HDF5JavaException {
        this.enumWriter.write(objectPath, value);
    }

    @Override
    public void writeEnum(String objectPath, String[] options, String value) {
        this.enumWriter.write(objectPath, this.enumWriter.newAnonVal(options, value));
    }

    @Override
    public <T extends Enum<T>> void writeEnumArray(String objectPath, Enum<T>[] data) {
        this.enumWriter.writeArray(objectPath, this.enumWriter.newAnonArray(data));
    }

    @Override
    public void writeEnumArray(String objectPath, String[] options, String[] data) {
        this.enumWriter.writeArray(objectPath, this.enumWriter.newAnonArray(options, data));
    }

    @Override
    public void setEnumArrayAttribute(String objectPath, String name, HDF5EnumerationValueArray value) {
        this.enumWriter.setArrayAttr(objectPath, name, value);
    }

    @Override
    public void writeEnum(String objectPath, HDF5EnumerationValue value) throws HDF5JavaException {
        this.enumWriter.write(objectPath, value);
    }

    @Override
    public void writeEnumArray(String objectPath, HDF5EnumerationValueArray data, HDF5IntStorageFeatures features) throws HDF5JavaException {
        this.enumWriter.writeArray(objectPath, data, features);
    }

    @Override
    public void writeEnumArray(String objectPath, HDF5EnumerationValueArray data) throws HDF5JavaException {
        this.enumWriter.writeArray(objectPath, data);
    }

    @Override
    public void writeEnumArrayBlock(String objectPath, HDF5EnumerationValueArray data, long blockNumber) {
        this.enumWriter.writeArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeEnumArrayBlockWithOffset(String objectPath, HDF5EnumerationValueArray data, int dataSize, long offset) {
        this.enumWriter.writeArrayBlockWithOffset(objectPath, data, dataSize, offset);
    }

    @Override
    public IHDF5CompoundWriter compounds() {
        return this.compoundWriter;
    }

    @Override
    public IHDF5CompoundWriter compound() {
        return this.compoundWriter;
    }

    @Override
    public <T> HDF5CompoundType<T> getCompoundType(String name, Class<T> pojoClass, HDF5CompoundMemberMapping ... members) {
        return this.compoundWriter.getType(name, pojoClass, members);
    }

    @Override
    public <T> HDF5CompoundType<T> getCompoundType(Class<T> pojoClass, HDF5CompoundMemberMapping ... members) {
        return this.compoundWriter.getType(pojoClass, members);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredCompoundType(String name, Class<T> pojoClass) {
        return this.compoundWriter.getInferredType(name, pojoClass);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredCompoundType(Class<T> pojoClass) {
        return this.compoundWriter.getInferredType(pojoClass);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredCompoundType(String name, T template) {
        return this.compoundWriter.getInferredType(name, template);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredCompoundType(T template) {
        return this.compoundWriter.getInferredType(template);
    }

    @Override
    public <T> void createCompoundArray(String objectPath, HDF5CompoundType<T> type, int size) {
        this.compoundWriter.createArray(objectPath, type, size);
    }

    @Override
    public <T> void createCompoundArray(String objectPath, HDF5CompoundType<T> type, long size, HDF5GenericStorageFeatures features) {
        this.compoundWriter.createArray(objectPath, type, size, features);
    }

    @Override
    public <T> void createCompoundArray(String objectPath, HDF5CompoundType<T> type, long size, int blockSize, HDF5GenericStorageFeatures features) {
        this.compoundWriter.createArray(objectPath, type, size, blockSize, features);
    }

    @Override
    public <T> void createCompoundArray(String objectPath, HDF5CompoundType<T> type, long size, int blockSize) {
        this.compoundWriter.createArray(objectPath, type, size, blockSize);
    }

    @Override
    public <T> void createCompoundMDArray(String objectPath, HDF5CompoundType<T> type, int[] dimensions, HDF5GenericStorageFeatures features) {
        this.compoundWriter.createMDArray(objectPath, type, dimensions, features);
    }

    @Override
    public <T> void createCompoundMDArray(String objectPath, HDF5CompoundType<T> type, int[] dimensions) {
        this.compoundWriter.createMDArray(objectPath, type, dimensions);
    }

    @Override
    public <T> void createCompoundMDArray(String objectPath, HDF5CompoundType<T> type, long[] dimensions, int[] blockDimensions, HDF5GenericStorageFeatures features) {
        this.compoundWriter.createMDArray(objectPath, type, dimensions, blockDimensions, features);
    }

    @Override
    public <T> void createCompoundMDArray(String objectPath, HDF5CompoundType<T> type, long[] dimensions, int[] blockDimensions) {
        this.compoundWriter.createMDArray(objectPath, type, dimensions, blockDimensions);
    }

    @Override
    public <T> void writeCompound(String objectPath, HDF5CompoundType<T> type, T data, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        this.compoundWriter.write(objectPath, type, data, inspectorOrNull);
    }

    @Override
    public <T> void writeCompound(String objectPath, HDF5CompoundType<T> type, T data) {
        this.compoundWriter.write(objectPath, type, data);
    }

    @Override
    public <T> void writeCompound(String objectPath, T data) {
        this.compoundWriter.write(objectPath, data);
    }

    @Override
    public <T> void writeCompoundArray(String objectPath, HDF5CompoundType<T> type, T[] data, HDF5GenericStorageFeatures features, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        this.compoundWriter.writeArray(objectPath, type, data, features, inspectorOrNull);
    }

    @Override
    public <T> void writeCompoundArray(String objectPath, HDF5CompoundType<T> type, T[] data, HDF5GenericStorageFeatures features) {
        this.compoundWriter.writeArray(objectPath, type, data, features);
    }

    @Override
    public <T> void writeCompoundArray(String objectPath, HDF5CompoundType<T> type, T[] data) {
        this.compoundWriter.writeArray(objectPath, type, data);
    }

    @Override
    public <T> void writeCompoundArrayBlock(String objectPath, HDF5CompoundType<T> type, T[] data, long blockNumber, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        this.compoundWriter.writeArrayBlock(objectPath, type, data, blockNumber, inspectorOrNull);
    }

    @Override
    public <T> void writeCompoundArrayBlock(String objectPath, HDF5CompoundType<T> type, T[] data, long blockNumber) {
        this.compoundWriter.writeArrayBlock(objectPath, type, data, blockNumber);
    }

    @Override
    public <T> void writeCompoundArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, T[] data, long offset, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        this.compoundWriter.writeArrayBlockWithOffset(objectPath, type, data, offset, inspectorOrNull);
    }

    @Override
    public <T> void writeCompoundArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, T[] data, long offset) {
        this.compoundWriter.writeArrayBlockWithOffset(objectPath, type, data, offset);
    }

    @Override
    public <T> void writeCompoundMDArray(String objectPath, HDF5CompoundType<T> type, MDArray<T> data, HDF5GenericStorageFeatures features, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        this.compoundWriter.writeMDArray(objectPath, type, data, features, inspectorOrNull);
    }

    @Override
    public <T> void writeCompoundMDArray(String objectPath, HDF5CompoundType<T> type, MDArray<T> data, HDF5GenericStorageFeatures features) {
        this.compoundWriter.writeMDArray(objectPath, type, data, features);
    }

    @Override
    public <T> void writeCompoundMDArray(String objectPath, HDF5CompoundType<T> type, MDArray<T> data) {
        this.compoundWriter.writeMDArray(objectPath, type, data);
    }

    @Override
    public <T> void writeCompoundArray(String objectPath, T[] data) {
        this.compoundWriter.writeArray(objectPath, data);
    }

    @Override
    public <T> void writeCompoundArray(String objectPath, T[] data, HDF5GenericStorageFeatures features) {
        this.compoundWriter.writeArray(objectPath, data, features);
    }

    @Override
    public <T> void writeCompoundMDArray(String objectPath, MDArray<T> data) {
        this.compoundWriter.writeMDArray(objectPath, data);
    }

    @Override
    public <T> void writeCompoundMDArray(String objectPath, MDArray<T> data, HDF5GenericStorageFeatures features) {
        this.compoundWriter.writeMDArray(objectPath, data, features);
    }

    @Override
    public <T> void writeCompoundMDArrayBlock(String objectPath, HDF5CompoundType<T> type, MDArray<T> data, long[] blockDimensions, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        this.compoundWriter.writeMDArrayBlock(objectPath, type, data, blockDimensions, inspectorOrNull);
    }

    @Override
    public <T> void writeCompoundMDArrayBlock(String objectPath, HDF5CompoundType<T> type, MDArray<T> data, long[] blockDimensions) {
        this.compoundWriter.writeMDArrayBlock(objectPath, type, data, blockDimensions);
    }

    @Override
    public <T> void writeCompoundMDArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, MDArray<T> data, int[] blockDimensions, long[] offset, int[] memoryOffset, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        this.compoundWriter.writeMDArrayBlockWithOffset(objectPath, type, data, blockDimensions, offset, memoryOffset, inspectorOrNull);
    }

    @Override
    public <T> void writeCompoundMDArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, MDArray<T> data, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        this.compoundWriter.writeMDArrayBlockWithOffset(objectPath, type, data, blockDimensions, offset, memoryOffset);
    }

    @Override
    public <T> void writeCompoundMDArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, MDArray<T> data, long[] offset, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        this.compoundWriter.writeMDArrayBlockWithOffset(objectPath, type, data, offset, inspectorOrNull);
    }

    @Override
    public <T> void writeCompoundMDArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, MDArray<T> data, long[] offset) {
        this.compoundWriter.writeMDArrayBlockWithOffset(objectPath, type, data, offset);
    }

    @Override
    public <T> HDF5CompoundMemberInformation[] getCompoundMemberInformation(Class<T> compoundClass) {
        return this.compoundWriter.getMemberInfo(compoundClass);
    }

    @Override
    public HDF5CompoundMemberInformation[] getCompoundMemberInformation(String dataTypeName) {
        return this.compoundWriter.getMemberInfo(dataTypeName);
    }

    @Override
    public HDF5CompoundMemberInformation[] getCompoundDataSetInformation(String dataSetPath) throws HDF5JavaException {
        return this.compoundWriter.getDataSetInfo(dataSetPath);
    }

    @Override
    public HDF5CompoundType<List<?>> getInferredCompoundType(String name, List<String> memberNames, List<?> template) {
        return this.compoundWriter.getInferredType(name, memberNames, template);
    }

    @Override
    public HDF5CompoundType<List<?>> getInferredCompoundType(List<String> memberNames, List<?> template) {
        return this.compoundWriter.getInferredType(memberNames, template);
    }

    @Override
    public HDF5CompoundType<Object[]> getInferredCompoundType(String name, String[] memberNames, Object[] template) {
        return this.compoundWriter.getInferredType(name, memberNames, template);
    }

    @Override
    public HDF5CompoundType<Object[]> getInferredCompoundType(String[] memberNames, Object[] template) {
        return this.compoundWriter.getInferredType(memberNames, template);
    }

    @Override
    public <T> HDF5CompoundType<T> getDataSetCompoundType(String objectPath, Class<T> pojoClass) {
        return this.compoundWriter.getDataSetType(objectPath, pojoClass);
    }

    @Override
    public <T> HDF5CompoundType<T> getNamedCompoundType(String dataTypeName, Class<T> pojoClass) {
        return this.compoundWriter.getNamedType(dataTypeName, pojoClass);
    }

    @Override
    public <T> HDF5CompoundType<T> getNamedCompoundType(Class<T> pojoClass) {
        return this.compoundWriter.getNamedType(pojoClass);
    }

    @Override
    public void createByteArray(String objectPath, int blockSize) {
        this.byteWriter.createArray(objectPath, blockSize);
    }

    @Override
    public void createByteArray(String objectPath, long size, int blockSize) {
        this.byteWriter.createArray(objectPath, size, blockSize);
    }

    @Override
    public void createByteArray(String objectPath, int size, HDF5IntStorageFeatures features) {
        this.byteWriter.createArray(objectPath, size, features);
    }

    @Override
    public void createByteArray(String objectPath, long size, int blockSize, HDF5IntStorageFeatures features) {
        this.byteWriter.createArray(objectPath, size, blockSize, features);
    }

    @Override
    public void createByteMDArray(String objectPath, int[] blockDimensions) {
        this.byteWriter.createMDArray(objectPath, blockDimensions);
    }

    @Override
    public void createByteMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.byteWriter.createMDArray(objectPath, dimensions, blockDimensions);
    }

    @Override
    public void createByteMDArray(String objectPath, int[] dimensions, HDF5IntStorageFeatures features) {
        this.byteWriter.createMDArray(objectPath, dimensions, features);
    }

    @Override
    public void createByteMDArray(String objectPath, long[] dimensions, int[] blockDimensions, HDF5IntStorageFeatures features) {
        this.byteWriter.createMDArray(objectPath, dimensions, blockDimensions, features);
    }

    @Override
    public void createByteMatrix(String objectPath, int blockSizeX, int blockSizeY) {
        this.byteWriter.createMatrix(objectPath, blockSizeX, blockSizeY);
    }

    @Override
    public void createByteMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY) {
        this.byteWriter.createMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY);
    }

    @Override
    public void createByteMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY, HDF5IntStorageFeatures features) {
        this.byteWriter.createMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY, features);
    }

    @Override
    public void setByteArrayAttribute(String objectPath, String name, byte[] value) {
        this.byteWriter.setArrayAttr(objectPath, name, value);
    }

    @Override
    public void setByteAttribute(String objectPath, String name, byte value) {
        this.byteWriter.setAttr(objectPath, name, value);
    }

    @Override
    public void setByteMDArrayAttribute(String objectPath, String name, MDByteArray value) {
        this.byteWriter.setMDArrayAttr(objectPath, name, value);
    }

    @Override
    public void setByteMatrixAttribute(String objectPath, String name, byte[][] value) {
        this.byteWriter.setMatrixAttr(objectPath, name, value);
    }

    @Override
    public void writeByte(String objectPath, byte value) {
        this.byteWriter.write(objectPath, value);
    }

    @Override
    public void writeByteArray(String objectPath, byte[] data) {
        this.byteWriter.writeArray(objectPath, data);
    }

    @Override
    public void writeByteArray(String objectPath, byte[] data, HDF5IntStorageFeatures features) {
        this.byteWriter.writeArray(objectPath, data, features);
    }

    @Override
    public void writeByteArrayBlock(String objectPath, byte[] data, long blockNumber) {
        this.byteWriter.writeArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeByteArrayBlockWithOffset(String objectPath, byte[] data, int dataSize, long offset) {
        this.byteWriter.writeArrayBlockWithOffset(objectPath, data, dataSize, offset);
    }

    @Override
    public void writeByteMDArray(String objectPath, MDByteArray data) {
        this.byteWriter.writeMDArray(objectPath, data);
    }

    @Override
    public void writeByteMDArray(String objectPath, MDByteArray data, HDF5IntStorageFeatures features) {
        this.byteWriter.writeMDArray(objectPath, data, features);
    }

    @Override
    public void writeByteMDArrayBlock(String objectPath, MDByteArray data, long[] blockNumber) {
        this.byteWriter.writeMDArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeByteMDArrayBlockWithOffset(String objectPath, MDByteArray data, long[] offset) {
        this.byteWriter.writeMDArrayBlockWithOffset(objectPath, data, offset);
    }

    @Override
    public void writeByteMDArrayBlockWithOffset(String objectPath, MDByteArray data, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        this.byteWriter.writeMDArrayBlockWithOffset(objectPath, data, blockDimensions, offset, memoryOffset);
    }

    @Override
    public void writeByteMatrix(String objectPath, byte[][] data) {
        this.byteWriter.writeMatrix(objectPath, data);
    }

    @Override
    public void writeByteMatrix(String objectPath, byte[][] data, HDF5IntStorageFeatures features) {
        this.byteWriter.writeMatrix(objectPath, data, features);
    }

    @Override
    public void writeByteMatrixBlock(String objectPath, byte[][] data, long blockNumberX, long blockNumberY) {
        this.byteWriter.writeMatrixBlock(objectPath, data, blockNumberX, blockNumberY);
    }

    @Override
    public void writeByteMatrixBlockWithOffset(String objectPath, byte[][] data, long offsetX, long offsetY) {
        this.byteWriter.writeMatrixBlockWithOffset(objectPath, data, offsetX, offsetY);
    }

    @Override
    public void writeByteMatrixBlockWithOffset(String objectPath, byte[][] data, int dataSizeX, int dataSizeY, long offsetX, long offsetY) {
        this.byteWriter.writeMatrixBlockWithOffset(objectPath, data, dataSizeX, dataSizeY, offsetX, offsetY);
    }

    @Override
    public void createDoubleArray(String objectPath, int blockSize) {
        this.doubleWriter.createArray(objectPath, blockSize);
    }

    @Override
    public void createDoubleArray(String objectPath, long size, int blockSize) {
        this.doubleWriter.createArray(objectPath, size, blockSize);
    }

    @Override
    public void createDoubleArray(String objectPath, int size, HDF5FloatStorageFeatures features) {
        this.doubleWriter.createArray(objectPath, size, features);
    }

    @Override
    public void createDoubleArray(String objectPath, long size, int blockSize, HDF5FloatStorageFeatures features) {
        this.doubleWriter.createArray(objectPath, size, blockSize, features);
    }

    @Override
    public void createDoubleMDArray(String objectPath, int[] blockDimensions) {
        this.doubleWriter.createMDArray(objectPath, blockDimensions);
    }

    @Override
    public void createDoubleMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.doubleWriter.createMDArray(objectPath, dimensions, blockDimensions);
    }

    @Override
    public void createDoubleMDArray(String objectPath, int[] dimensions, HDF5FloatStorageFeatures features) {
        this.doubleWriter.createMDArray(objectPath, dimensions, features);
    }

    @Override
    public void createDoubleMDArray(String objectPath, long[] dimensions, int[] blockDimensions, HDF5FloatStorageFeatures features) {
        this.doubleWriter.createMDArray(objectPath, dimensions, blockDimensions, features);
    }

    @Override
    public void createDoubleMatrix(String objectPath, int blockSizeX, int blockSizeY) {
        this.doubleWriter.createMatrix(objectPath, blockSizeX, blockSizeY);
    }

    @Override
    public void createDoubleMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY) {
        this.doubleWriter.createMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY);
    }

    @Override
    public void createDoubleMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY, HDF5FloatStorageFeatures features) {
        this.doubleWriter.createMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY, features);
    }

    @Override
    public void setDoubleArrayAttribute(String objectPath, String name, double[] value) {
        this.doubleWriter.setArrayAttr(objectPath, name, value);
    }

    @Override
    public void setDoubleAttribute(String objectPath, String name, double value) {
        this.doubleWriter.setAttr(objectPath, name, value);
    }

    @Override
    public void setDoubleMDArrayAttribute(String objectPath, String name, MDDoubleArray value) {
        this.doubleWriter.setMDArrayAttr(objectPath, name, value);
    }

    @Override
    public void setDoubleMatrixAttribute(String objectPath, String name, double[][] value) {
        this.doubleWriter.setMatrixAttr(objectPath, name, value);
    }

    @Override
    public void writeDouble(String objectPath, double value) {
        this.doubleWriter.write(objectPath, value);
    }

    @Override
    public void writeDoubleArray(String objectPath, double[] data) {
        this.doubleWriter.writeArray(objectPath, data);
    }

    @Override
    public void writeDoubleArray(String objectPath, double[] data, HDF5FloatStorageFeatures features) {
        this.doubleWriter.writeArray(objectPath, data, features);
    }

    @Override
    public void writeDoubleArrayBlock(String objectPath, double[] data, long blockNumber) {
        this.doubleWriter.writeArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeDoubleArrayBlockWithOffset(String objectPath, double[] data, int dataSize, long offset) {
        this.doubleWriter.writeArrayBlockWithOffset(objectPath, data, dataSize, offset);
    }

    @Override
    public void writeDoubleMDArray(String objectPath, MDDoubleArray data) {
        this.doubleWriter.writeMDArray(objectPath, data);
    }

    @Override
    public void writeDoubleMDArray(String objectPath, MDDoubleArray data, HDF5FloatStorageFeatures features) {
        this.doubleWriter.writeMDArray(objectPath, data, features);
    }

    @Override
    public void writeDoubleMDArrayBlock(String objectPath, MDDoubleArray data, long[] blockNumber) {
        this.doubleWriter.writeMDArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeDoubleMDArrayBlockWithOffset(String objectPath, MDDoubleArray data, long[] offset) {
        this.doubleWriter.writeMDArrayBlockWithOffset(objectPath, data, offset);
    }

    @Override
    public void writeDoubleMDArrayBlockWithOffset(String objectPath, MDDoubleArray data, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        this.doubleWriter.writeMDArrayBlockWithOffset(objectPath, data, blockDimensions, offset, memoryOffset);
    }

    @Override
    public void writeDoubleMatrix(String objectPath, double[][] data) {
        this.doubleWriter.writeMatrix(objectPath, data);
    }

    @Override
    public void writeDoubleMatrix(String objectPath, double[][] data, HDF5FloatStorageFeatures features) {
        this.doubleWriter.writeMatrix(objectPath, data, features);
    }

    @Override
    public void writeDoubleMatrixBlock(String objectPath, double[][] data, long blockNumberX, long blockNumberY) {
        this.doubleWriter.writeMatrixBlock(objectPath, data, blockNumberX, blockNumberY);
    }

    @Override
    public void writeDoubleMatrixBlockWithOffset(String objectPath, double[][] data, long offsetX, long offsetY) {
        this.doubleWriter.writeMatrixBlockWithOffset(objectPath, data, offsetX, offsetY);
    }

    @Override
    public void writeDoubleMatrixBlockWithOffset(String objectPath, double[][] data, int dataSizeX, int dataSizeY, long offsetX, long offsetY) {
        this.doubleWriter.writeMatrixBlockWithOffset(objectPath, data, dataSizeX, dataSizeY, offsetX, offsetY);
    }

    @Override
    public void createFloatArray(String objectPath, int blockSize) {
        this.floatWriter.createArray(objectPath, blockSize);
    }

    @Override
    public void createFloatArray(String objectPath, long size, int blockSize) {
        this.floatWriter.createArray(objectPath, size, blockSize);
    }

    @Override
    public void createFloatArray(String objectPath, int size, HDF5FloatStorageFeatures features) {
        this.floatWriter.createArray(objectPath, size, features);
    }

    @Override
    public void createFloatArray(String objectPath, long size, int blockSize, HDF5FloatStorageFeatures features) {
        this.floatWriter.createArray(objectPath, size, blockSize, features);
    }

    @Override
    public void createFloatMDArray(String objectPath, int[] blockDimensions) {
        this.floatWriter.createMDArray(objectPath, blockDimensions);
    }

    @Override
    public void createFloatMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.floatWriter.createMDArray(objectPath, dimensions, blockDimensions);
    }

    @Override
    public void createFloatMDArray(String objectPath, int[] dimensions, HDF5FloatStorageFeatures features) {
        this.floatWriter.createMDArray(objectPath, dimensions, features);
    }

    @Override
    public void createFloatMDArray(String objectPath, long[] dimensions, int[] blockDimensions, HDF5FloatStorageFeatures features) {
        this.floatWriter.createMDArray(objectPath, dimensions, blockDimensions, features);
    }

    @Override
    public void createFloatMatrix(String objectPath, int blockSizeX, int blockSizeY) {
        this.floatWriter.createMatrix(objectPath, blockSizeX, blockSizeY);
    }

    @Override
    public void createFloatMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY) {
        this.floatWriter.createMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY);
    }

    @Override
    public void createFloatMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY, HDF5FloatStorageFeatures features) {
        this.floatWriter.createMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY, features);
    }

    @Override
    public void setFloatArrayAttribute(String objectPath, String name, float[] value) {
        this.floatWriter.setArrayAttr(objectPath, name, value);
    }

    @Override
    public void setFloatAttribute(String objectPath, String name, float value) {
        this.floatWriter.setAttr(objectPath, name, value);
    }

    @Override
    public void setFloatMDArrayAttribute(String objectPath, String name, MDFloatArray value) {
        this.floatWriter.setMDArrayAttr(objectPath, name, value);
    }

    @Override
    public void setFloatMatrixAttribute(String objectPath, String name, float[][] value) {
        this.floatWriter.setMatrixAttr(objectPath, name, value);
    }

    @Override
    public void writeFloat(String objectPath, float value) {
        this.floatWriter.write(objectPath, value);
    }

    @Override
    public void writeFloatArray(String objectPath, float[] data) {
        this.floatWriter.writeArray(objectPath, data);
    }

    @Override
    public void writeFloatArray(String objectPath, float[] data, HDF5FloatStorageFeatures features) {
        this.floatWriter.writeArray(objectPath, data, features);
    }

    @Override
    public void writeFloatArrayBlock(String objectPath, float[] data, long blockNumber) {
        this.floatWriter.writeArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeFloatArrayBlockWithOffset(String objectPath, float[] data, int dataSize, long offset) {
        this.floatWriter.writeArrayBlockWithOffset(objectPath, data, dataSize, offset);
    }

    @Override
    public void writeFloatMDArray(String objectPath, MDFloatArray data) {
        this.floatWriter.writeMDArray(objectPath, data);
    }

    @Override
    public void writeFloatMDArray(String objectPath, MDFloatArray data, HDF5FloatStorageFeatures features) {
        this.floatWriter.writeMDArray(objectPath, data, features);
    }

    @Override
    public void writeFloatMDArrayBlock(String objectPath, MDFloatArray data, long[] blockNumber) {
        this.floatWriter.writeMDArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeFloatMDArrayBlockWithOffset(String objectPath, MDFloatArray data, long[] offset) {
        this.floatWriter.writeMDArrayBlockWithOffset(objectPath, data, offset);
    }

    @Override
    public void writeFloatMDArrayBlockWithOffset(String objectPath, MDFloatArray data, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        this.floatWriter.writeMDArrayBlockWithOffset(objectPath, data, blockDimensions, offset, memoryOffset);
    }

    @Override
    public void writeFloatMatrix(String objectPath, float[][] data) {
        this.floatWriter.writeMatrix(objectPath, data);
    }

    @Override
    public void writeFloatMatrix(String objectPath, float[][] data, HDF5FloatStorageFeatures features) {
        this.floatWriter.writeMatrix(objectPath, data, features);
    }

    @Override
    public void writeFloatMatrixBlock(String objectPath, float[][] data, long blockNumberX, long blockNumberY) {
        this.floatWriter.writeMatrixBlock(objectPath, data, blockNumberX, blockNumberY);
    }

    @Override
    public void writeFloatMatrixBlockWithOffset(String objectPath, float[][] data, long offsetX, long offsetY) {
        this.floatWriter.writeMatrixBlockWithOffset(objectPath, data, offsetX, offsetY);
    }

    @Override
    public void writeFloatMatrixBlockWithOffset(String objectPath, float[][] data, int dataSizeX, int dataSizeY, long offsetX, long offsetY) {
        this.floatWriter.writeMatrixBlockWithOffset(objectPath, data, dataSizeX, dataSizeY, offsetX, offsetY);
    }

    @Override
    public void createIntArray(String objectPath, int blockSize) {
        this.intWriter.createArray(objectPath, blockSize);
    }

    @Override
    public void createIntArray(String objectPath, long size, int blockSize) {
        this.intWriter.createArray(objectPath, size, blockSize);
    }

    @Override
    public void createIntArray(String objectPath, int size, HDF5IntStorageFeatures features) {
        this.intWriter.createArray(objectPath, size, features);
    }

    @Override
    public void createIntArray(String objectPath, long size, int blockSize, HDF5IntStorageFeatures features) {
        this.intWriter.createArray(objectPath, size, blockSize, features);
    }

    @Override
    public void createIntMDArray(String objectPath, int[] blockDimensions) {
        this.intWriter.createMDArray(objectPath, blockDimensions);
    }

    @Override
    public void createIntMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.intWriter.createMDArray(objectPath, dimensions, blockDimensions);
    }

    @Override
    public void createIntMDArray(String objectPath, int[] dimensions, HDF5IntStorageFeatures features) {
        this.intWriter.createMDArray(objectPath, dimensions, features);
    }

    @Override
    public void createIntMDArray(String objectPath, long[] dimensions, int[] blockDimensions, HDF5IntStorageFeatures features) {
        this.intWriter.createMDArray(objectPath, dimensions, blockDimensions, features);
    }

    @Override
    public void createIntMatrix(String objectPath, int blockSizeX, int blockSizeY) {
        this.intWriter.createMatrix(objectPath, blockSizeX, blockSizeY);
    }

    @Override
    public void createIntMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY) {
        this.intWriter.createMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY);
    }

    @Override
    public void createIntMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY, HDF5IntStorageFeatures features) {
        this.intWriter.createMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY, features);
    }

    @Override
    public void setIntArrayAttribute(String objectPath, String name, int[] value) {
        this.intWriter.setArrayAttr(objectPath, name, value);
    }

    @Override
    public void setIntAttribute(String objectPath, String name, int value) {
        this.intWriter.setAttr(objectPath, name, value);
    }

    @Override
    public void setIntMDArrayAttribute(String objectPath, String name, MDIntArray value) {
        this.intWriter.setMDArrayAttr(objectPath, name, value);
    }

    @Override
    public void setIntMatrixAttribute(String objectPath, String name, int[][] value) {
        this.intWriter.setMatrixAttr(objectPath, name, value);
    }

    @Override
    public void writeInt(String objectPath, int value) {
        this.intWriter.write(objectPath, value);
    }

    @Override
    public void writeIntArray(String objectPath, int[] data) {
        this.intWriter.writeArray(objectPath, data);
    }

    @Override
    public void writeIntArray(String objectPath, int[] data, HDF5IntStorageFeatures features) {
        this.intWriter.writeArray(objectPath, data, features);
    }

    @Override
    public void writeIntArrayBlock(String objectPath, int[] data, long blockNumber) {
        this.intWriter.writeArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeIntArrayBlockWithOffset(String objectPath, int[] data, int dataSize, long offset) {
        this.intWriter.writeArrayBlockWithOffset(objectPath, data, dataSize, offset);
    }

    @Override
    public void writeIntMDArray(String objectPath, MDIntArray data) {
        this.intWriter.writeMDArray(objectPath, data);
    }

    @Override
    public void writeIntMDArray(String objectPath, MDIntArray data, HDF5IntStorageFeatures features) {
        this.intWriter.writeMDArray(objectPath, data, features);
    }

    @Override
    public void writeIntMDArrayBlock(String objectPath, MDIntArray data, long[] blockNumber) {
        this.intWriter.writeMDArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeIntMDArrayBlockWithOffset(String objectPath, MDIntArray data, long[] offset) {
        this.intWriter.writeMDArrayBlockWithOffset(objectPath, data, offset);
    }

    @Override
    public void writeIntMDArrayBlockWithOffset(String objectPath, MDIntArray data, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        this.intWriter.writeMDArrayBlockWithOffset(objectPath, data, blockDimensions, offset, memoryOffset);
    }

    @Override
    public void writeIntMatrix(String objectPath, int[][] data) {
        this.intWriter.writeMatrix(objectPath, data);
    }

    @Override
    public void writeIntMatrix(String objectPath, int[][] data, HDF5IntStorageFeatures features) {
        this.intWriter.writeMatrix(objectPath, data, features);
    }

    @Override
    public void writeIntMatrixBlock(String objectPath, int[][] data, long blockNumberX, long blockNumberY) {
        this.intWriter.writeMatrixBlock(objectPath, data, blockNumberX, blockNumberY);
    }

    @Override
    public void writeIntMatrixBlockWithOffset(String objectPath, int[][] data, long offsetX, long offsetY) {
        this.intWriter.writeMatrixBlockWithOffset(objectPath, data, offsetX, offsetY);
    }

    @Override
    public void writeIntMatrixBlockWithOffset(String objectPath, int[][] data, int dataSizeX, int dataSizeY, long offsetX, long offsetY) {
        this.intWriter.writeMatrixBlockWithOffset(objectPath, data, dataSizeX, dataSizeY, offsetX, offsetY);
    }

    @Override
    public void createLongArray(String objectPath, int blockSize) {
        this.longWriter.createArray(objectPath, blockSize);
    }

    @Override
    public void createLongArray(String objectPath, long size, int blockSize) {
        this.longWriter.createArray(objectPath, size, blockSize);
    }

    @Override
    public void createLongArray(String objectPath, int size, HDF5IntStorageFeatures features) {
        this.longWriter.createArray(objectPath, size, features);
    }

    @Override
    public void createLongArray(String objectPath, long size, int blockSize, HDF5IntStorageFeatures features) {
        this.longWriter.createArray(objectPath, size, blockSize, features);
    }

    @Override
    public void createLongMDArray(String objectPath, int[] blockDimensions) {
        this.longWriter.createMDArray(objectPath, blockDimensions);
    }

    @Override
    public void createLongMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.longWriter.createMDArray(objectPath, dimensions, blockDimensions);
    }

    @Override
    public void createLongMDArray(String objectPath, int[] dimensions, HDF5IntStorageFeatures features) {
        this.longWriter.createMDArray(objectPath, dimensions, features);
    }

    @Override
    public void createLongMDArray(String objectPath, long[] dimensions, int[] blockDimensions, HDF5IntStorageFeatures features) {
        this.longWriter.createMDArray(objectPath, dimensions, blockDimensions, features);
    }

    @Override
    public void createLongMatrix(String objectPath, int blockSizeX, int blockSizeY) {
        this.longWriter.createMatrix(objectPath, blockSizeX, blockSizeY);
    }

    @Override
    public void createLongMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY) {
        this.longWriter.createMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY);
    }

    @Override
    public void createLongMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY, HDF5IntStorageFeatures features) {
        this.longWriter.createMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY, features);
    }

    @Override
    public void setLongArrayAttribute(String objectPath, String name, long[] value) {
        this.longWriter.setArrayAttr(objectPath, name, value);
    }

    @Override
    public void setLongAttribute(String objectPath, String name, long value) {
        this.longWriter.setAttr(objectPath, name, value);
    }

    @Override
    public void setLongMDArrayAttribute(String objectPath, String name, MDLongArray value) {
        this.longWriter.setMDArrayAttr(objectPath, name, value);
    }

    @Override
    public void setLongMatrixAttribute(String objectPath, String name, long[][] value) {
        this.longWriter.setMatrixAttr(objectPath, name, value);
    }

    @Override
    public void writeLong(String objectPath, long value) {
        this.longWriter.write(objectPath, value);
    }

    @Override
    public void writeLongArray(String objectPath, long[] data) {
        this.longWriter.writeArray(objectPath, data);
    }

    @Override
    public void writeLongArray(String objectPath, long[] data, HDF5IntStorageFeatures features) {
        this.longWriter.writeArray(objectPath, data, features);
    }

    @Override
    public void writeLongArrayBlock(String objectPath, long[] data, long blockNumber) {
        this.longWriter.writeArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeLongArrayBlockWithOffset(String objectPath, long[] data, int dataSize, long offset) {
        this.longWriter.writeArrayBlockWithOffset(objectPath, data, dataSize, offset);
    }

    @Override
    public void writeLongMDArray(String objectPath, MDLongArray data) {
        this.longWriter.writeMDArray(objectPath, data);
    }

    @Override
    public void writeLongMDArray(String objectPath, MDLongArray data, HDF5IntStorageFeatures features) {
        this.longWriter.writeMDArray(objectPath, data, features);
    }

    @Override
    public void writeLongMDArrayBlock(String objectPath, MDLongArray data, long[] blockNumber) {
        this.longWriter.writeMDArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeLongMDArrayBlockWithOffset(String objectPath, MDLongArray data, long[] offset) {
        this.longWriter.writeMDArrayBlockWithOffset(objectPath, data, offset);
    }

    @Override
    public void writeLongMDArrayBlockWithOffset(String objectPath, MDLongArray data, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        this.longWriter.writeMDArrayBlockWithOffset(objectPath, data, blockDimensions, offset, memoryOffset);
    }

    @Override
    public void writeLongMatrix(String objectPath, long[][] data) {
        this.longWriter.writeMatrix(objectPath, data);
    }

    @Override
    public void writeLongMatrix(String objectPath, long[][] data, HDF5IntStorageFeatures features) {
        this.longWriter.writeMatrix(objectPath, data, features);
    }

    @Override
    public void writeLongMatrixBlock(String objectPath, long[][] data, long blockNumberX, long blockNumberY) {
        this.longWriter.writeMatrixBlock(objectPath, data, blockNumberX, blockNumberY);
    }

    @Override
    public void writeLongMatrixBlockWithOffset(String objectPath, long[][] data, long offsetX, long offsetY) {
        this.longWriter.writeMatrixBlockWithOffset(objectPath, data, offsetX, offsetY);
    }

    @Override
    public void writeLongMatrixBlockWithOffset(String objectPath, long[][] data, int dataSizeX, int dataSizeY, long offsetX, long offsetY) {
        this.longWriter.writeMatrixBlockWithOffset(objectPath, data, dataSizeX, dataSizeY, offsetX, offsetY);
    }

    @Override
    public void createShortArray(String objectPath, int blockSize) {
        this.shortWriter.createArray(objectPath, blockSize);
    }

    @Override
    public void createShortArray(String objectPath, long size, int blockSize) {
        this.shortWriter.createArray(objectPath, size, blockSize);
    }

    @Override
    public void createShortArray(String objectPath, int size, HDF5IntStorageFeatures features) {
        this.shortWriter.createArray(objectPath, size, features);
    }

    @Override
    public void createShortArray(String objectPath, long size, int blockSize, HDF5IntStorageFeatures features) {
        this.shortWriter.createArray(objectPath, size, blockSize, features);
    }

    @Override
    public void createShortMDArray(String objectPath, int[] blockDimensions) {
        this.shortWriter.createMDArray(objectPath, blockDimensions);
    }

    @Override
    public void createShortMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.shortWriter.createMDArray(objectPath, dimensions, blockDimensions);
    }

    @Override
    public void createShortMDArray(String objectPath, int[] dimensions, HDF5IntStorageFeatures features) {
        this.shortWriter.createMDArray(objectPath, dimensions, features);
    }

    @Override
    public void createShortMDArray(String objectPath, long[] dimensions, int[] blockDimensions, HDF5IntStorageFeatures features) {
        this.shortWriter.createMDArray(objectPath, dimensions, blockDimensions, features);
    }

    @Override
    public void createShortMatrix(String objectPath, int blockSizeX, int blockSizeY) {
        this.shortWriter.createMatrix(objectPath, blockSizeX, blockSizeY);
    }

    @Override
    public void createShortMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY) {
        this.shortWriter.createMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY);
    }

    @Override
    public void createShortMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY, HDF5IntStorageFeatures features) {
        this.shortWriter.createMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY, features);
    }

    @Override
    public void setShortArrayAttribute(String objectPath, String name, short[] value) {
        this.shortWriter.setArrayAttr(objectPath, name, value);
    }

    @Override
    public void setShortAttribute(String objectPath, String name, short value) {
        this.shortWriter.setAttr(objectPath, name, value);
    }

    @Override
    public void setShortMDArrayAttribute(String objectPath, String name, MDShortArray value) {
        this.shortWriter.setMDArrayAttr(objectPath, name, value);
    }

    @Override
    public void setShortMatrixAttribute(String objectPath, String name, short[][] value) {
        this.shortWriter.setMatrixAttr(objectPath, name, value);
    }

    @Override
    public void writeShort(String objectPath, short value) {
        this.shortWriter.write(objectPath, value);
    }

    @Override
    public void writeShortArray(String objectPath, short[] data) {
        this.shortWriter.writeArray(objectPath, data);
    }

    @Override
    public void writeShortArray(String objectPath, short[] data, HDF5IntStorageFeatures features) {
        this.shortWriter.writeArray(objectPath, data, features);
    }

    @Override
    public void writeShortArrayBlock(String objectPath, short[] data, long blockNumber) {
        this.shortWriter.writeArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeShortArrayBlockWithOffset(String objectPath, short[] data, int dataSize, long offset) {
        this.shortWriter.writeArrayBlockWithOffset(objectPath, data, dataSize, offset);
    }

    @Override
    public void writeShortMDArray(String objectPath, MDShortArray data) {
        this.shortWriter.writeMDArray(objectPath, data);
    }

    @Override
    public void writeShortMDArray(String objectPath, MDShortArray data, HDF5IntStorageFeatures features) {
        this.shortWriter.writeMDArray(objectPath, data, features);
    }

    @Override
    public void writeShortMDArrayBlock(String objectPath, MDShortArray data, long[] blockNumber) {
        this.shortWriter.writeMDArrayBlock(objectPath, data, blockNumber);
    }

    @Override
    public void writeShortMDArrayBlockWithOffset(String objectPath, MDShortArray data, long[] offset) {
        this.shortWriter.writeMDArrayBlockWithOffset(objectPath, data, offset);
    }

    @Override
    public void writeShortMDArrayBlockWithOffset(String objectPath, MDShortArray data, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        this.shortWriter.writeMDArrayBlockWithOffset(objectPath, data, blockDimensions, offset, memoryOffset);
    }

    @Override
    public void writeShortMatrix(String objectPath, short[][] data) {
        this.shortWriter.writeMatrix(objectPath, data);
    }

    @Override
    public void writeShortMatrix(String objectPath, short[][] data, HDF5IntStorageFeatures features) {
        this.shortWriter.writeMatrix(objectPath, data, features);
    }

    @Override
    public void writeShortMatrixBlock(String objectPath, short[][] data, long blockNumberX, long blockNumberY) {
        this.shortWriter.writeMatrixBlock(objectPath, data, blockNumberX, blockNumberY);
    }

    @Override
    public void writeShortMatrixBlockWithOffset(String objectPath, short[][] data, long offsetX, long offsetY) {
        this.shortWriter.writeMatrixBlockWithOffset(objectPath, data, offsetX, offsetY);
    }

    @Override
    public void writeShortMatrixBlockWithOffset(String objectPath, short[][] data, int dataSizeX, int dataSizeY, long offsetX, long offsetY) {
        this.shortWriter.writeMatrixBlockWithOffset(objectPath, data, dataSizeX, dataSizeY, offsetX, offsetY);
    }

    @Override
    public IHDF5ByteWriter int8() {
        return this.byteWriter;
    }

    @Override
    public IHDF5ByteWriter uint8() {
        return this.ubyteWriter;
    }

    @Override
    public IHDF5ShortWriter int16() {
        return this.shortWriter;
    }

    @Override
    public IHDF5ShortWriter uint16() {
        return this.ushortWriter;
    }

    @Override
    public IHDF5IntWriter int32() {
        return this.intWriter;
    }

    @Override
    public IHDF5IntWriter uint32() {
        return this.uintWriter;
    }

    @Override
    public IHDF5LongWriter int64() {
        return this.longWriter;
    }

    @Override
    public IHDF5LongWriter uint64() {
        return this.ulongWriter;
    }

    @Override
    public IHDF5FloatWriter float32() {
        return this.floatWriter;
    }

    @Override
    public IHDF5DoubleWriter float64() {
        return this.doubleWriter;
    }
}

