/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.ColorScheme;
import jhi.flapjack.gui.visualization.colors.ColorState;
import jhi.flapjack.gui.visualization.colors.HeterozygeousColorState;
import jhi.flapjack.gui.visualization.colors.HomozygousColorState;
import jhi.flapjack.gui.visualization.colors.SimpleColorState;
import jhi.flapjack.gui.visualization.colors.WebsafePalette;
import scri.commons.gui.RB;

public class RandomColorScheme
extends ColorScheme {
    private int type;
    private ArrayList<ColorState> states = new ArrayList();

    public RandomColorScheme(int type) {
        this.type = type;
    }

    public RandomColorScheme(int type, GTView view, int w, int h) {
        super(view);
        this.type = type;
        HashMap<String, Color> hashtable = new HashMap<String, Color>();
        AlleleState state = this.stateTable.getAlleleState(0);
        this.states.add(new SimpleColorState(state, Prefs.visColorBackground, w, h));
        int seed = view.getViewSet().getRandomColorSeed();
        float colorsNeeded = this.stateTable.uniqueAlleles().size() - 1;
        float colorSpacing = 0.0f;
        float fColor = 0.0f;
        if (type == 50) {
            colorSpacing = 1.0f / colorsNeeded;
            fColor = 2.0E-5f * (float)seed;
        } else if (type == 51) {
            colorSpacing = (float)WebsafePalette.getColorCount() / colorsNeeded;
            fColor = seed;
        }
        for (int i = 1; i < this.stateTable.size(); ++i) {
            Color c2;
            state = this.stateTable.getAlleleState(i);
            if (state.isHomozygous()) {
                Color color = (Color)hashtable.get(state.homzAllele());
                if (color == null) {
                    if (type == 50) {
                        color = Color.getHSBColor(fColor, 0.5f, 1.0f);
                    } else if (type == 51) {
                        color = WebsafePalette.getColor((int)fColor);
                    }
                    fColor += colorSpacing;
                    hashtable.put(state.homzAllele(), color);
                }
                this.states.add(new HomozygousColorState(state, color, w, h));
                continue;
            }
            Color c1 = (Color)hashtable.get(state.getState(0));
            if (c1 == null) {
                if (type == 50) {
                    c1 = Color.getHSBColor(fColor, 0.5f, 1.0f);
                } else if (type == 51) {
                    c1 = WebsafePalette.getColor((int)fColor);
                }
                fColor += colorSpacing;
                hashtable.put(state.getState(0), c1);
            }
            if ((c2 = (Color)hashtable.get(state.getState(1))) == null) {
                if (type == 50) {
                    c2 = Color.getHSBColor(fColor, 0.5f, 1.0f);
                } else if (type == 51) {
                    c2 = WebsafePalette.getColor((int)fColor);
                }
                fColor += colorSpacing;
                hashtable.put(state.getState(1), c2);
            }
            this.states.add(new HeterozygeousColorState(state, Prefs.visColorNucleotideHZ, c1, c2, w, h));
        }
    }

    @Override
    public BufferedImage getSelectedImage(int line, int marker, boolean underQTL) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getImage(underQTL);
    }

    @Override
    public BufferedImage getUnselectedImage(int line, int marker, boolean underQTL) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getUnselectedImage(underQTL);
    }

    @Override
    public Color getColor(int line, int marker) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getColor();
    }

    @Override
    public int getModel() {
        if (this.type == 50) {
            return 50;
        }
        return 51;
    }

    public String toString() {
        if (this.type == 50) {
            return RB.getString((String)"gui.Actions.vizColorRandom");
        }
        return RB.getString((String)"gui.Actions.vizColorRandomWSP");
    }

    @Override
    public String getDescription() {
        if (this.type == 50) {
            return RB.getString((String)"gui.visualization.colors.RandomColorScheme");
        }
        return RB.getString((String)"gui.visualization.colors.RandomColorSchemeWSP");
    }

    @Override
    public ArrayList<ColorScheme.ColorSummary> getColorSummaries() {
        return new ArrayList<ColorScheme.ColorSummary>();
    }

    @Override
    public void setColorSummaries(ArrayList<ColorScheme.ColorSummary> colors) {
    }
}

