/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.pedver;

import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.results.PedVerLinesParentScore;
import jhi.flapjack.data.results.PedVerLinesResult;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.table.LineDataTableModel;

class PedVerLinesTableModel
extends LineDataTableModel {
    private GTViewSet viewSet;
    private int selectedIndex;
    private int rankIndex;
    private int commentsIndex;
    private int sortIndex;
    private int parentsIndex;
    private int dataTotalMatchIndex;
    private int totalMatchCountIndex;
    private int totalMatchPercentIndex;

    PedVerLinesTableModel(DataSet dataSet, GTViewSet viewSet) {
        this.dataSet = dataSet;
        this.viewSet = viewSet;
        this.setLines(viewSet.tableHandler().linesForTable());
        this.initModel();
    }

    void initModel() {
        PedVerLinesResult stats = ((LineInfo)this.lines.get(0)).getResults().getPedVerLinesResult();
        this.columnNames = new String[14 + stats.getParentScores().size() * 3];
        this.parentsIndex = 7;
        this.dataTotalMatchIndex = this.columnNames.length - 7;
        this.totalMatchCountIndex = this.columnNames.length - 6;
        this.totalMatchPercentIndex = this.columnNames.length - 5;
        this.selectedIndex = this.columnNames.length - 4;
        this.rankIndex = this.columnNames.length - 3;
        this.commentsIndex = this.columnNames.length - 2;
        this.sortIndex = this.columnNames.length - 1;
        this.columnNames[0] = "Line";
        this.columnNames[1] = "Data Count";
        this.columnNames[2] = "Missing Count";
        this.columnNames[3] = "Marker count";
        this.columnNames[4] = "% Missing";
        this.columnNames[5] = "Het Count";
        this.columnNames[6] = "% Het";
        for (int i = 0; i < stats.getParentScores().size(); ++i) {
            this.columnNames[this.parentsIndex + i * 3] = "Data Parent " + (i + 1) + " Match";
            this.columnNames[this.parentsIndex + i * 3 + 1] = "Match Parent " + (i + 1) + " Count";
            this.columnNames[this.parentsIndex + i * 3 + 2] = "Match Parent " + (i + 1) + " Percent";
        }
        this.columnNames[this.dataTotalMatchIndex] = "Data Total Match";
        this.columnNames[this.totalMatchCountIndex] = "Total Match";
        this.columnNames[this.totalMatchPercentIndex] = "Percent Total Match";
        this.columnNames[this.selectedIndex] = "Selected";
        this.columnNames[this.rankIndex] = "Rank";
        this.columnNames[this.commentsIndex] = "Comments";
        this.columnNames[this.sortIndex] = "Don't Sort/Filter";
    }

    @Override
    public boolean skipExport(int col) {
        return col == this.sortIndex;
    }

    @Override
    public int getRowCount() {
        return this.lines.size();
    }

    @Override
    public Object getObjectAt(int row, int col) {
        LineInfo line = (LineInfo)this.lines.get(row);
        PedVerLinesResult stats = line.getResults().getPedVerLinesResult();
        if (col == 0) {
            return line;
        }
        if (col == this.selectedIndex) {
            return line.getSelected();
        }
        if (col == this.rankIndex) {
            return line.getResults().getRank();
        }
        if (col == this.sortIndex) {
            return line.getResults().isSortToTop();
        }
        if (stats == null) {
            return null;
        }
        if (col == 1) {
            return stats.getDataCount();
        }
        if (col == 2) {
            return stats.getMissingCount();
        }
        if (col == 3) {
            return stats.getMarkerCount();
        }
        if (col == 4) {
            return stats.getPercentMissing();
        }
        if (col == 5) {
            return stats.getHetCount();
        }
        if (col == 6) {
            return stats.getPercentHet();
        }
        if (col >= this.parentsIndex && col < this.dataTotalMatchIndex) {
            int parent = (col -= this.parentsIndex) / 3;
            PedVerLinesParentScore score = stats.getParentScores().get(parent);
            if (col % 3 == 0) {
                return score.getDataParentMatch();
            }
            if (col % 3 == 1) {
                return score.getMatchParentCount();
            }
            return score.getMatchParentPercent();
        }
        if (col == this.dataTotalMatchIndex) {
            return stats.getDataTotalMatch();
        }
        if (col == this.totalMatchCountIndex) {
            return stats.getTotalMatch();
        }
        if (col == this.totalMatchPercentIndex) {
            return stats.getPercentTotalMatch();
        }
        if (col == this.commentsIndex) {
            String comment = line.getResults().getComments();
            return comment == null ? "" : comment;
        }
        return null;
    }

    @Override
    public Class getObjectColumnClass(int col) {
        if (col == 0) {
            return LineInfo.class;
        }
        if (col == this.selectedIndex || col == this.sortIndex) {
            return Boolean.class;
        }
        if (col == this.commentsIndex) {
            return String.class;
        }
        return Double.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == this.selectedIndex || col == this.commentsIndex || col == this.sortIndex;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        LineInfo line = (LineInfo)this.getObjectAt(row, 0);
        if (col == this.selectedIndex) {
            PedVerLinesTableModel.selectLine(line, (Boolean)value);
        } else if (col == this.rankIndex) {
            line.getResults().setRank((Integer)value);
        } else if (col == this.commentsIndex) {
            line.getResults().setComments((String)value);
        } else if (col == this.sortIndex) {
            line.getResults().setSortToTop((Boolean)value);
        }
        this.fireTableRowsUpdated(row, row);
        Actions.projectModified();
    }

    int getRankIndex() {
        return this.rankIndex;
    }
}

