/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.navpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;
import jhi.flapjack.gui.navpanel.BookmarkNode;
import jhi.flapjack.gui.navpanel.DataSetNode;
import jhi.flapjack.gui.navpanel.DendrogramNode;
import jhi.flapjack.gui.navpanel.SimMatrixNode;
import jhi.flapjack.gui.navpanel.TraitsNode;
import jhi.flapjack.gui.navpanel.VisualizationNode;
import scri.commons.gui.Icons;

public class TreeRenderer
extends JLabel
implements TreeCellRenderer {
    private static Color bColor = UIManager.getColor("Tree.selectionBackground");
    private boolean selected = false;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean isExpanded, boolean leaf, int row, boolean hasFocus) {
        this.setText(value.toString());
        if (value instanceof DataSetNode) {
            this.setIcon(isExpanded ? Icons.getIcon((String)"FOLDEROPEN") : Icons.getIcon((String)"FOLDER"));
        } else if (value instanceof VisualizationNode) {
            this.setIcon(Icons.getIcon((String)"VISUALIZATION"));
        } else if (value instanceof TraitsNode) {
            this.setIcon(Icons.getIcon((String)"TRAITS"));
        } else if (value instanceof BookmarkNode) {
            this.setIcon(Icons.getIcon((String)"BOOKMARK"));
        } else if (value instanceof SimMatrixNode) {
            this.setIcon(Icons.getIcon((String)((SimMatrixNode)value).getIconName()));
        } else if (value instanceof DendrogramNode) {
            this.setIcon(Icons.getIcon((String)"DENDROGRAM"));
        } else {
            this.setIcon(Icons.getIcon((String)"TREEBLANK"));
        }
        this.selected = selected;
        if (selected) {
            this.setForeground((Color)UIManager.get("Tree.selectionForeground"));
        } else {
            this.setForeground((Color)UIManager.get("Tree.foreground"));
        }
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        Icon icon = this.getIcon();
        int offset = 0;
        if (icon != null && this.getText() != null) {
            offset = icon.getIconWidth() + this.getIconTextGap();
        }
        if (this.selected) {
            g.setColor(bColor);
            g.fillRect(offset, 0, 500 - offset, this.getHeight() - 1);
        }
        super.paintComponent(g);
    }
}

