/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.prefs;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.dialog.prefs.IPrefsTab;
import scri.commons.gui.RB;
import scri.commons.gui.UIScaler;

class GeneralTabNB
extends JPanel
implements IPrefsTab,
ActionListener {
    private DefaultComboBoxModel<String> displayModel;
    private DefaultComboBoxModel<String> updateModel;
    private JCheckBox checkDecimal;
    private JCheckBox checkUI;
    private JComboBox<String> displayCombo;
    private JLabel displayLabel;
    private JPanel generalPanel;
    private JPanel scalePanel;
    private JLabel uiLabel;
    private JSlider uiSlider;
    private JComboBox<String> updateCombo;
    private JLabel updateLabel;

    public GeneralTabNB() {
        this.initComponents();
        this.setBackground((Color)UIManager.get("fjDialogBG"));
        this.generalPanel.setBorder(BorderFactory.createTitledBorder(RB.getString((String)"gui.dialog.prefs.NBGeneralPanel.generalPanelTitle")));
        RB.setText((JLabel)this.displayLabel, (String)"gui.dialog.prefs.NBGeneralPanel.displayLabel");
        RB.setText((AbstractButton)this.checkDecimal, (String)"gui.dialog.prefs.NBGeneralPanel.checkDecimal");
        this.displayModel = new DefaultComboBoxModel();
        this.displayModel.addElement(RB.getString((String)"gui.dialog.prefs.NBGeneralPanel.auto"));
        this.displayModel.addElement(RB.getString((String)"gui.dialog.prefs.NBGeneralPanel.en_GB"));
        this.displayModel.addElement(RB.getString((String)"gui.dialog.prefs.NBGeneralPanel.en_US"));
        this.displayModel.addElement(RB.getString((String)"gui.dialog.prefs.NBGeneralPanel.de_DE"));
        this.displayModel.addElement(RB.getString((String)"gui.dialog.prefs.NBGeneralPanel.es_MX"));
        this.displayCombo.setModel(this.displayModel);
        RB.setText((JLabel)this.updateLabel, (String)"gui.dialog.prefs.NBGeneralPanel.updateLabel");
        this.updateModel = new DefaultComboBoxModel();
        this.updateModel.addElement(RB.getString((String)"gui.dialog.prefs.NBGeneralPanel.updateNever"));
        this.updateModel.addElement(RB.getString((String)"gui.dialog.prefs.NBGeneralPanel.updateStartup"));
        this.updateModel.addElement(RB.getString((String)"gui.dialog.prefs.NBGeneralPanel.updateDaily"));
        this.updateModel.addElement(RB.getString((String)"gui.dialog.prefs.NBGeneralPanel.updateWeekly"));
        this.updateModel.addElement(RB.getString((String)"gui.dialog.prefs.NBGeneralPanel.updateMonthly"));
        this.updateCombo.setModel(this.updateModel);
        this.scalePanel.setBorder(BorderFactory.createTitledBorder(RB.getString((String)"gui.dialog.prefs.NBGeneralPanel.scalePanel.title")));
        RB.setText((AbstractButton)this.checkUI, (String)"gui.dialog.prefs.NBGeneralPanel.scalePanel.checkUI");
        RB.setText((JLabel)this.uiLabel, (String)"gui.dialog.prefs.NBGeneralPanel.scalePanel.uiLabel");
        Hashtable<Integer, JLabel> uiLabels = new Hashtable<Integer, JLabel>();
        for (int i = 100; i <= 300; i += 50) {
            uiLabels.put(i, new JLabel(i + "%"));
        }
        this.uiSlider.setLabelTable(uiLabels);
        this.checkUI.addActionListener(this);
        this.initSettings();
    }

    private int getLocaleIndex() {
        if (Prefs.localeText.equals("en_GB")) {
            return 1;
        }
        if (Prefs.localeText.equals("en_US")) {
            return 2;
        }
        if (Prefs.localeText.equals("de_DE")) {
            return 3;
        }
        if (Prefs.localeText.equals("es_MX")) {
            return 4;
        }
        return 0;
    }

    private void initSettings() {
        this.displayCombo.setSelectedIndex(this.getLocaleIndex());
        this.checkDecimal.setSelected(Prefs.guiDecimalEnglish);
        this.updateCombo.setSelectedIndex(Prefs.guiUpdateSchedule);
        this.setUIStates();
    }

    @Override
    public void applySettings() {
        switch (this.displayCombo.getSelectedIndex()) {
            case 1: {
                Prefs.localeText = "en_GB";
                break;
            }
            case 2: {
                Prefs.localeText = "en_US";
                break;
            }
            case 3: {
                Prefs.localeText = "de_DE";
                break;
            }
            case 4: {
                Prefs.localeText = "es_MX";
                break;
            }
            default: {
                Prefs.localeText = "auto";
            }
        }
        Prefs.guiDecimalEnglish = this.checkDecimal.isSelected();
        Prefs.guiUpdateSchedule = this.updateCombo.getSelectedIndex();
        Prefs.uiScale = (float)this.uiSlider.getValue() / 100.0f;
    }

    @Override
    public void setDefaults() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.checkUI) {
            Prefs.uiScaleAuto = this.checkUI.isSelected();
            this.setUIStates();
        }
    }

    private void setUIStates() {
        Prefs.uiScale = UIScaler.init((float)Prefs.uiScale, (boolean)Prefs.uiScaleAuto);
        this.checkUI.setSelected(Prefs.uiScaleAuto);
        this.uiSlider.setValue(Math.round(Prefs.uiScale * 100.0f));
        this.uiSlider.setEnabled(!this.checkUI.isSelected());
    }

    private void initComponents() {
        this.generalPanel = new JPanel();
        this.displayCombo = new JComboBox();
        this.updateCombo = new JComboBox();
        this.displayLabel = new JLabel();
        this.updateLabel = new JLabel();
        this.checkDecimal = new JCheckBox();
        this.scalePanel = new JPanel();
        this.checkUI = new JCheckBox();
        this.uiSlider = new JSlider();
        this.uiLabel = new JLabel();
        this.generalPanel.setBorder(BorderFactory.createTitledBorder("General options (restart to apply):"));
        this.generalPanel.setOpaque(false);
        this.displayLabel.setLabelFor(this.displayCombo);
        this.displayLabel.setText("Interface display language:");
        this.updateLabel.setLabelFor(this.updateCombo);
        this.updateLabel.setText("Check for newer Flapjack versions:");
        this.checkDecimal.setText("Always use English decimal mark settings (eg 3.141 for pi)");
        GroupLayout generalPanelLayout = new GroupLayout(this.generalPanel);
        this.generalPanel.setLayout(generalPanelLayout);
        generalPanelLayout.setHorizontalGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addContainerGap().addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayLabel).addComponent(this.updateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.updateCombo, 0, 250, Short.MAX_VALUE).addComponent(this.displayCombo, 0, -1, Short.MAX_VALUE))).addGroup(generalPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.checkDecimal))).addContainerGap()));
        generalPanelLayout.setVerticalGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addContainerGap().addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.displayLabel).addComponent(this.displayCombo, -2, -1, -2)).addGap(6, 6, 6).addComponent(this.checkDecimal).addGap(18, 18, 18).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.updateLabel).addComponent(this.updateCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.scalePanel.setBorder(BorderFactory.createTitledBorder("High DPI compatibility (restart to apply):"));
        this.scalePanel.setOpaque(false);
        this.checkUI.setText("Attempt automatic display scaling");
        this.uiSlider.setMajorTickSpacing(25);
        this.uiSlider.setMaximum(300);
        this.uiSlider.setMinimum(100);
        this.uiSlider.setMinorTickSpacing(5);
        this.uiSlider.setPaintLabels(true);
        this.uiSlider.setPaintTicks(true);
        this.uiSlider.setSnapToTicks(true);
        this.uiLabel.setText("Some aspects of display scaling will be set by your o/s and are outwith Flapjack's control");
        GroupLayout scalePanelLayout = new GroupLayout(this.scalePanel);
        this.scalePanel.setLayout(scalePanelLayout);
        scalePanelLayout.setHorizontalGroup(scalePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scalePanelLayout.createSequentialGroup().addContainerGap().addGroup(scalePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.uiSlider, -1, -1, Short.MAX_VALUE).addGroup(scalePanelLayout.createSequentialGroup().addGroup(scalePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkUI).addComponent(this.uiLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        scalePanelLayout.setVerticalGroup(scalePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scalePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.checkUI).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.uiSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.uiLabel).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.generalPanel, -1, -1, Short.MAX_VALUE).addComponent(this.scalePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.generalPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scalePanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

