/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.loader.collection.handler;

import java.util.Enumeration;
import java.util.SortedMap;
import java.util.TreeMap;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.MapItem;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.mapping.loader.J2CollectionHandlers;

public final class SortedMapCollectionHandler<T>
implements CollectionHandler<T> {
    @Override
    public Object add(Object collection, T object) {
        Object key = object;
        Object value = object;
        if (object instanceof MapItem) {
            MapItem item = (MapItem)object;
            key = item.getKey();
            value = item.getValue();
            if (value == null) {
                value = object;
            }
            if (key == null) {
                key = value;
            }
        }
        if (collection == null) {
            collection = new TreeMap();
            ((SortedMap)collection).put(key, value);
            return collection;
        }
        ((SortedMap)collection).put(key, value);
        return null;
    }

    @Override
    public Enumeration<T> elements(Object collection) {
        if (collection == null) {
            return new CollectionHandlers.EmptyEnumerator();
        }
        return new J2CollectionHandlers.IteratorEnumerator(((SortedMap)collection).values().iterator());
    }

    @Override
    public int size(Object collection) {
        if (collection == null) {
            return 0;
        }
        return ((SortedMap)collection).size();
    }

    @Override
    public Object clear(Object collection) {
        if (collection != null) {
            ((SortedMap)collection).clear();
        }
        return null;
    }

    public String toString() {
        return "SortedMap";
    }
}

