/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.ColorScheme;
import jhi.flapjack.gui.visualization.colors.ColorState;
import jhi.flapjack.gui.visualization.colors.SimilarityColorScheme;
import scri.commons.gui.RB;

public class MarkerSimilarityColorScheme
extends SimilarityColorScheme {
    public MarkerSimilarityColorScheme() {
    }

    public MarkerSimilarityColorScheme(GTView view, int w, int h) {
        super(view, w, h);
    }

    public ColorState getState(int line, int marker) {
        int state = this.view.getState(line, marker);
        int comparisonIndex = this.view.getComparisonMarkerIndex();
        if (marker == comparisonIndex) {
            return (ColorState)this.compStates.get(state);
        }
        if (comparisonIndex != -1) {
            int compState = this.view.getState(line, comparisonIndex);
            switch (this.lookupTable[state][compState]) {
                case 1: {
                    return (ColorState)this.mtchStatesY.get(state);
                }
                case 2: {
                    return (ColorState)this.mtchStatesN.get(state);
                }
                case 3: {
                    return (ColorState)this.het1States.get(state);
                }
                case 4: {
                    return (ColorState)this.het2States.get(state);
                }
                case 5: {
                    return (ColorState)this.gsStates.get(state);
                }
            }
        }
        return (ColorState)this.gsStates.get(state);
    }

    @Override
    public BufferedImage getSelectedImage(int line, int marker, boolean underQTL) {
        return this.getState(line, marker).getImage(underQTL);
    }

    @Override
    public BufferedImage getUnselectedImage(int line, int marker, boolean underQTL) {
        return this.getState(line, marker).getUnselectedImage(underQTL);
    }

    @Override
    public Color getColor(int line, int marker) {
        return this.getState(line, marker).getColor();
    }

    @Override
    public int getModel() {
        return 4;
    }

    public String toString() {
        return RB.getString((String)"gui.Actions.vizColorMarkerSim");
    }

    @Override
    public String getDescription() {
        return RB.getString((String)"gui.visualization.colors.MarkerSimilarityColorScheme");
    }

    @Override
    public ArrayList<ColorScheme.ColorSummary> getColorSummaries() {
        ArrayList<ColorScheme.ColorSummary> colors = new ArrayList<ColorScheme.ColorSummary>();
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimStateMatchDark, RB.getString((String)"gui.visualization.colors.MarkerSimilarityColorScheme.state1Dark")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimStateMatch, RB.getString((String)"gui.visualization.colors.MarkerSimilarityColorScheme.state1")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimStateNoMatch, RB.getString((String)"gui.visualization.colors.MarkerSimilarityColorScheme.state2")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimStateMissing, RB.getString((String)"gui.visualization.colors.MarkerSimilarityColorScheme.state3")));
        return colors;
    }
}

