/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.Marker;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.ColorScheme;
import jhi.flapjack.gui.visualization.colors.ColorState;
import jhi.flapjack.gui.visualization.colors.HeterozygeousColorState;
import jhi.flapjack.gui.visualization.colors.HomozygousColorState;
import jhi.flapjack.gui.visualization.colors.SimpleColorState;
import scri.commons.gui.RB;

public class AlleleFrequencyColorScheme
extends ColorScheme {
    private HashMap<String, ColorState> colors = new HashMap();
    private float thresholdFrequency;
    private HashMap<String, Integer> hashmap = new HashMap();

    public AlleleFrequencyColorScheme() {
    }

    public AlleleFrequencyColorScheme(GTView view, int w, int h) {
        super(view);
        this.thresholdFrequency = view.getViewSet().getAlleleFrequencyThreshold();
        int i = 0;
        for (String allele : Marker.alleles()) {
            this.hashmap.put(allele, i++);
        }
        for (int s = 0; s < this.stateTable.size(); ++s) {
            AlleleState state = this.stateTable.getAlleleState(s);
            if (state.isUnknown()) {
                this.colors.put("", new SimpleColorState(state, Prefs.visColorBackground, w, h));
                continue;
            }
            if (state.isHomozygous()) {
                this.colors.put(state.homzAllele() + "H", new HomozygousColorState(state, Prefs.visColorHiFreqState, w, h));
                this.colors.put(state.homzAllele() + "L", new HomozygousColorState(state, Prefs.visColorLoFreqState, w, h));
                continue;
            }
            String[] alleles = state.getStates();
            this.colors.put(alleles[0] + "H" + alleles[1] + "H", new HeterozygeousColorState(state, Prefs.visColorHiFreqState, Prefs.visColorHiFreqState, Prefs.visColorHiFreqState, w, h));
            this.colors.put(alleles[0] + "H" + alleles[1] + "L", new HeterozygeousColorState(state, Prefs.visColorNucleotideHZ, Prefs.visColorHiFreqState, Prefs.visColorLoFreqState, w, h));
            this.colors.put(alleles[0] + "L" + alleles[1] + "H", new HeterozygeousColorState(state, Prefs.visColorNucleotideHZ, Prefs.visColorLoFreqState, Prefs.visColorHiFreqState, w, h));
            this.colors.put(alleles[0] + "L" + alleles[1] + "L", new HeterozygeousColorState(state, Prefs.visColorLoFreqState, Prefs.visColorLoFreqState, Prefs.visColorLoFreqState, w, h));
        }
    }

    private float getFrequency(int marker, String allele) {
        return this.view.getMarker(marker).frequencies()[this.hashmap.get(allele)];
    }

    private ColorState getState(int line, int marker) {
        int index = this.view.getState(line, marker);
        if (index == 0) {
            return this.colors.get("");
        }
        String[] alleles = this.stateTable.getAlleleState(index).getStates();
        String key = "";
        for (int i = 0; i < alleles.length; ++i) {
            key = this.getFrequency(marker, alleles[i]) <= this.thresholdFrequency ? key + alleles[i] + "L" : key + alleles[i] + "H";
        }
        return this.colors.get(key);
    }

    @Override
    public BufferedImage getSelectedImage(int line, int marker, boolean underQTL) {
        return this.getState(line, marker).getImage(underQTL);
    }

    @Override
    public BufferedImage getUnselectedImage(int line, int marker, boolean underQTL) {
        return this.getState(line, marker).getUnselectedImage(underQTL);
    }

    @Override
    public Color getColor(int line, int marker) {
        return this.getState(line, marker).getColor();
    }

    @Override
    public int getModel() {
        return 7;
    }

    public String toString() {
        return RB.getString((String)"gui.Actions.vizColorAlleleFreq");
    }

    @Override
    public String getDescription() {
        return RB.getString((String)"gui.visualization.colors.AlleleFrequencyColorScheme");
    }

    @Override
    public ArrayList<ColorScheme.ColorSummary> getColorSummaries() {
        ArrayList<ColorScheme.ColorSummary> colors = new ArrayList<ColorScheme.ColorSummary>();
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorLoFreqState, RB.getString((String)"gui.visualization.colors.AlleleFrequencyColorScheme.loFreqState")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorHiFreqState, RB.getString((String)"gui.visualization.colors.AlleleFrequencyColorScheme.hiFreqState")));
        return colors;
    }

    @Override
    public void setColorSummaries(ArrayList<ColorScheme.ColorSummary> colors) {
        Prefs.visColorLoFreqState = colors.get((int)0).color;
        Prefs.visColorHiFreqState = colors.get((int)1).color;
    }
}

