/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import jhi.flapjack.data.Marker;
import jhi.flapjack.data.QTL;
import jhi.flapjack.data.QTLInfo;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.MapCanvasAAThread;
import jhi.flapjack.gui.visualization.MapCanvasML;
import jhi.flapjack.gui.visualization.QTLCanvas;
import scri.commons.gui.SystemUtils;

class MapCanvas
extends JPanel {
    private NumberFormat nf = NumberFormat.getInstance();
    private GenotypePanel gPanel;
    private GenotypeCanvas canvas;
    private int h = 55;
    private BufferedImage buffer;
    private BufferedImage aaBuffer;
    boolean updateBuffer = true;
    private int pX2 = 0;
    private int mrkrIndex = -1;
    double mSPos;
    double mEPos;
    private int w;
    private MapCanvasML mapCanvasML;

    MapCanvas(GenotypePanel gPanel, GenotypeCanvas canvas) {
        this.gPanel = gPanel;
        this.canvas = canvas;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.add(new Canvas2D());
        this.mapCanvasML = new MapCanvasML(this, gPanel);
    }

    void setMarkerIndex(int mrkrIndex) {
        if (this.mrkrIndex != mrkrIndex && !this.canvas.locked) {
            this.mrkrIndex = mrkrIndex;
            this.repaint();
        }
    }

    private int getChromosomeForPosition(double chromosomePos) {
        int acc = 0;
        for (int chr = 0; chr < this.canvas.viewSet.getViews().size(); ++chr) {
            double mapLength = this.canvas.viewSet.getView(chr).mapLength();
            if (!(chromosomePos > (double)acc + mapLength)) {
                return chr;
            }
            acc = (int)((double)acc + mapLength);
        }
        return 0;
    }

    private double getChromosomePosOnSuperChromosome(double chromosomePos) {
        int chromosome = this.getChromosomeForPosition(chromosomePos);
        double offset = IntStream.range(0, chromosome).mapToDouble(i -> this.canvas.viewSet.getView(i).mapLength()).sum();
        return chromosomePos - offset;
    }

    private String getChromosomeNameOnSuperChromosome(double chromosomePos) {
        int chromosome = this.getChromosomeForPosition(chromosomePos);
        return this.canvas.viewSet.getView(chromosome).getChromosomeMap().getName();
    }

    private void paintBuffer() {
        this.w = this.canvas.pX2 - this.canvas.pX1 + 1;
        if (this.buffer == null || this.buffer.getWidth() != this.w || this.buffer.getHeight() != this.h) {
            this.buffer = (BufferedImage)this.createImage(this.w > 0 ? this.w : 1, this.h > 0 ? this.h : 1);
            this.aaBuffer = (BufferedImage)this.createImage(this.w > 0 ? this.w : 1, this.h > 0 ? this.h : 1);
        }
        Graphics2D g = this.buffer.createGraphics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.w, this.h);
        int xS = this.canvas.pX1 / this.canvas.boxW;
        int xE = this.canvas.pX2 / this.canvas.boxW;
        this.render(g, xS, xE);
        new MapCanvasAAThread(this, xS, xE);
        g.dispose();
        this.updateBuffer = false;
    }

    void render(Graphics2D g, int xS, int xE) {
        if (this.canvas.view.markerCount() == 0) {
            return;
        }
        int y = 12;
        int yH = 10;
        this.setScaling(xS, xE);
        if (this.canvas.view.getChromosomeMap().isSpecialChromosome()) {
            double start = 0.0;
            double dS = 0.0;
            for (int i = 0; i < this.canvas.viewSet.getViews().size(); ++i) {
                double mapLength = this.canvas.viewSet.getView(i).mapLength();
                Color bg = i % 2 == 0 ? Color.WHITE : new Color(206, 221, 235);
                g.setColor(bg);
                double distance = this.mEPos - this.mSPos;
                int dEnd = (int)((start + mapLength - this.mSPos) * ((double)(this.w - 1) / distance));
                g.fillRect((int)dS, y, dEnd, yH);
                start += mapLength;
                dS = dEnd > 0 ? (double)dEnd : 0.0;
            }
        } else {
            g.setColor(Color.white);
            g.fillRect(0, y, this.w - 1, yH);
        }
        g.setColor(Color.lightGray);
        if (Prefs.visMapScaling != 2) {
            g.drawRect(0, y, this.w - 1, yH);
        } else {
            g.drawRect(-this.canvas.pX1, y, this.canvas.canvasW - 1, yH);
        }
        for (int i = xS; i <= xE; ++i) {
            this.renderMarker(g, i, xS, false);
        }
        int y1 = y - 5;
        int y2 = y + yH + 5;
        if (Prefs.visMapScaling == 1) {
            g.drawLine(0, y1, 0, y2);
            g.drawLine(this.w - 1, y1, this.w - 1, y2);
        } else if (Prefs.visMapScaling == 0) {
            if (this.mSPos == 0.0) {
                g.drawLine(0, y1, 0, y2);
            }
            if (this.mEPos == this.canvas.view.mapLength()) {
                g.drawLine(this.w - 1, y1, this.w - 1, y2);
            }
        } else if (Prefs.visMapScaling == 2) {
            int x1 = -this.canvas.pX1;
            int x2 = this.canvas.canvasW - this.canvas.pX1 - 1;
            g.drawLine(x1, y1, x1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
    }

    private void renderMarker(Graphics2D g, int i, int xS, boolean text) {
        Marker m = this.canvas.view.getMarker(i);
        int markerIndex = this.canvas.view.getMarkerInfo(i).getIndex();
        double distance = this.mEPos - this.mSPos;
        int xMap = (int)((m.getPosition() - this.mSPos) * ((double)(this.w - 1) / distance));
        int jiggle = this.canvas.pX1 % this.canvas.boxW;
        int xBox = (i - xS) * this.canvas.boxW + this.canvas.boxW / 2 - jiggle;
        if (!m.dummyMarker()) {
            Color current = g.getColor();
            if (g.getColor() != Color.red && this.canvas.qtlHash.contains(markerIndex)) {
                g.setColor(new Color(128, 128, 128));
            }
            g.drawLine(xMap, 12, xMap, 22);
            g.drawLine(xMap, 22, xBox, this.h - 9);
            if (this.canvas.qtlHash.contains(markerIndex)) {
                int xBoxL = (i - xS) * this.canvas.boxW - jiggle;
                g.setColor(Color.yellow);
                g.fillRect(xBoxL, this.h - 7, this.canvas.boxW - 1, 5);
                g.setColor(Color.lightGray);
                g.drawRect(xBoxL, this.h - 7, this.canvas.boxW - 1, 5);
            } else {
                g.drawLine(xBox, this.h - 9, xBox, this.h - 5);
            }
            g.setColor(current);
        } else {
            g.drawLine(xMap, 6, xMap, 22);
        }
        if (text && !m.dummyMarker()) {
            String str = m.getName() + "  (" + this.nf.format(m.getRealPosition()) + ")";
            int strWidth = g.getFontMetrics().stringWidth(str);
            g.drawString(str, this.getPosition(xMap, strWidth), 8);
        }
    }

    private void highlightMarker(Graphics2D g) {
        if (this.mrkrIndex >= 0 && this.mrkrIndex < this.canvas.view.markerCount()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.red);
            int xS = this.canvas.pX1 / this.canvas.boxW;
            this.renderMarker(g, this.mrkrIndex, xS, true);
        }
    }

    private void highlightQTL(Graphics2D g) {
        if (QTLCanvas.mouseOverQTL == null) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.red);
        QTLInfo qtlInfo = QTLCanvas.mouseOverQTL;
        QTL qtl = qtlInfo.getQTL();
        double min = qtlInfo.min();
        double max = qtlInfo.max();
        double distance = this.mEPos - this.mSPos;
        int xMap = (int)((min + (max - min) / 2.0 - this.mSPos) * ((double)(this.w - 1) / distance));
        String str = qtl.getName() + "  (";
        str = str + this.nf.format(qtl.getPosition()) + ": ";
        str = str + this.nf.format(qtl.getMin()) + "-" + this.nf.format(qtl.getMax()) + ")";
        int strWidth = g.getFontMetrics().stringWidth(str);
        g.drawString(str, this.getPosition(xMap, strWidth), 8);
        int mkrCount = this.canvas.view.markerCount();
        int xS = this.canvas.pX1 / this.canvas.boxW;
        for (int i = 0; i < mkrCount; ++i) {
            Marker m = this.canvas.view.getMarker(i);
            if (!(m.getRealPosition() >= qtl.getMin()) || !(m.getRealPosition() <= qtl.getMax()) || !(m.getPosition() >= min) || !(m.getPosition() <= max)) continue;
            this.renderMarker(g, i, xS, false);
        }
    }

    private int getPosition(int pos, int strWidth) {
        int leftPos = pos - (int)((float)strWidth / 2.0f);
        int rghtPos = pos + (int)((float)strWidth / 2.0f);
        if (leftPos < 0) {
            leftPos = 0;
        } else if (rghtPos > this.w) {
            leftPos = this.w - strWidth - 1;
        }
        return leftPos;
    }

    private void setScaling(int xS, int xE) {
        if (Prefs.visMapScaling == 0) {
            this.mSPos = this.canvas.view.getMarker(xS).getPosition();
            this.mEPos = this.canvas.view.getMarker(xE).getPosition();
            if (!this.canvas.view.getMarkersOrdered()) {
                for (int i = xS; i <= xE; ++i) {
                    double pos = this.canvas.view.getMarker(i).getPosition();
                    if (pos < this.mSPos) {
                        this.mSPos = pos;
                        continue;
                    }
                    if (!(pos > this.mEPos)) continue;
                    this.mEPos = pos;
                }
            }
        } else if (Prefs.visMapScaling == 1) {
            this.mSPos = 0.0;
            this.mEPos = this.canvas.view.mapLength();
        } else {
            double xScale = (double)(this.canvas.canvasW - 1) / this.canvas.view.mapLength();
            this.mSPos = (double)this.canvas.pX1 / xScale;
            this.mEPos = (double)this.canvas.pX2 / xScale;
        }
    }

    Graphics2D getAntiAliasedBufferGraphics() {
        return this.aaBuffer.createGraphics();
    }

    BufferedImage createSavableImage(boolean full) throws Exception {
        this.w = this.canvas.pX2 - this.canvas.pX1 + 1;
        int xS = this.canvas.pX1 / this.canvas.boxW;
        int xE = this.canvas.pX2 / this.canvas.boxW;
        if (full) {
            this.w = this.canvas.canvasW;
            xS = 0;
            xE = this.canvas.view.markerCount() - 1;
        }
        BufferedImage image = (BufferedImage)this.createImage(this.w > 0 ? this.w : 1, this.h > 0 ? this.h : 1);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.w, this.h);
        this.render(g, xS, xE);
        g.dispose();
        return image;
    }

    private class Canvas2D
    extends JPanel {
        private Font font = null;

        Canvas2D() {
            this.setPreferredSize(new Dimension(0, MapCanvas.this.h));
            this.font = SystemUtils.isMacOS() ? new Font("Dialog", 0, 10) : new Font("Dialog", 0, 11);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g = (Graphics2D)graphics;
            if (MapCanvas.this.pX2 != ((MapCanvas)MapCanvas.this).canvas.pX2) {
                MapCanvas.this.updateBuffer = true;
                MapCanvas.this.pX2 = ((MapCanvas)MapCanvas.this).canvas.pX2;
            }
            int xOffset = ((MapCanvas)MapCanvas.this).gPanel.traitCanvas.getPanelWidth() + ((MapCanvas)MapCanvas.this).gPanel.listPanel.getPanelWidth() + 1;
            g.translate(xOffset, 0);
            g.setClip(0, 0, ((MapCanvas)MapCanvas.this).canvas.pX2Max - ((MapCanvas)MapCanvas.this).canvas.pX1 + 1, this.getHeight());
            if (MapCanvas.this.updateBuffer) {
                MapCanvas.this.paintBuffer();
            }
            if (MapCanvasAAThread.bufferAvailable) {
                g.drawImage((Image)MapCanvas.this.aaBuffer, 0, 0, null);
            } else {
                g.drawImage((Image)MapCanvas.this.buffer, 0, 0, null);
            }
            g.setFont(this.font);
            MapCanvas.this.highlightMarker(g);
            MapCanvas.this.highlightQTL(g);
            this.drawChromosomePosition(g);
        }

        private void drawChromosomePosition(Graphics2D g) {
            double chromosomeLength;
            Integer mousePos = ((MapCanvas)MapCanvas.this).mapCanvasML.mousePos;
            if (mousePos == null || ((MapCanvas)MapCanvas.this).canvas.view.markerCount() == 0) {
                return;
            }
            float canvasWidth = ((MapCanvas)MapCanvas.this).canvas.pX2 - ((MapCanvas)MapCanvas.this).canvas.pX1 + 1;
            float posAsRatio = (float)mousePos.intValue() / canvasWidth;
            double chromosomePos = MapCanvas.this.mSPos + (double)posAsRatio * (chromosomeLength = MapCanvas.this.mEPos - MapCanvas.this.mSPos);
            if (chromosomePos < MapCanvas.this.mSPos || chromosomePos > MapCanvas.this.mEPos) {
                return;
            }
            double realChromosomePos = MapCanvas.this.getChromosomePosOnSuperChromosome(chromosomePos);
            g.setColor(Color.red);
            g.drawLine(mousePos, 12, mousePos, 22);
            String str = "";
            if (((MapCanvas)MapCanvas.this).canvas.view.getChromosomeMap().isSpecialChromosome()) {
                str = MapCanvas.this.nf.format(realChromosomePos) + " (" + MapCanvas.this.getChromosomeNameOnSuperChromosome(chromosomePos) + ")";
            } else {
                MapCanvas.this.nf.format(chromosomePos);
            }
            int strWidth = g.getFontMetrics().stringWidth(str);
            g.drawString(str, MapCanvas.this.getPosition(mousePos, strWidth), 8);
        }
    }
}

