/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.gui.Flapjack;
import scri.commons.gui.RB;
import scri.commons.gui.SwingUtils;
import scri.commons.gui.matisse.DialogPanel;
import scri.commons.gui.matisse.HyperLinkLabel;

public class LinkedColumnSelectionDialog
extends JDialog
implements ActionListener {
    private boolean isOK = false;
    private GTViewSet viewSet;
    private JButton bCancel;
    private JButton bOk;
    private DialogPanel dialogPanel1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private HyperLinkLabel lblSelectAll;
    private HyperLinkLabel lblSelectNone;
    private JTable table;

    public LinkedColumnSelectionDialog(GTViewSet viewSet) {
        super(Flapjack.winMain, "Columns To Display", true);
        this.viewSet = viewSet;
        this.initComponents();
        this.setBackground((Color)UIManager.get("fjDialogBG"));
        RB.setText((AbstractButton)this.bCancel, (String)"gui.text.cancel");
        RB.setText((AbstractButton)this.bOk, (String)"gui.text.ok");
        this.bOk.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.lblSelectAll.addActionListener((ActionListener)this);
        this.lblSelectNone.addActionListener((ActionListener)this);
        this.createTable(viewSet);
        this.getRootPane().setDefaultButton(this.bOk);
        SwingUtils.addCloseHandler((Window)this, (JComponent)this.bCancel);
        this.pack();
        this.setLocationRelativeTo(Flapjack.winMain);
        this.setResizable(false);
        this.setVisible(true);
    }

    private void createTable(GTViewSet viewSet) {
        int i;
        Object[] columnNames = new String[]{"Column", "Selected"};
        Object[][] data = new Object[viewSet.tableHandler().model().getColumnCount() - 1][2];
        for (i = 0; i < data.length; ++i) {
            data[i][0] = viewSet.tableHandler().model().getColumnName(i + 1);
            data[i][1] = false;
        }
        for (i = 0; i < viewSet.getLinkedModelCols().length; ++i) {
            int index = viewSet.getLinkedModelCols()[i];
            data[index - 1][1] = true;
        }
        this.table.setModel(new DefaultTableModel(data, columnNames){

            public Class getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 1;
            }
        });
        this.table.getColumnModel().getColumn(1).setPreferredWidth(10);
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>((DefaultTableModel)this.table.getModel());
        this.table.setRowSorter(sorter);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.lblSelectAll) {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                this.table.setValueAt(true, i, 1);
            }
        } else if (e.getSource() == this.lblSelectNone) {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                this.table.setValueAt(false, i, 1);
            }
        } else if (e.getSource() == this.bOk) {
            int[] cols = this.getSelectedColumnIndices();
            this.viewSet.setLinkedModelCols(cols);
            this.isOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.bCancel) {
            this.setVisible(false);
        }
    }

    private int[] getSelectedColumnIndices() {
        ArrayList<Integer> cols = new ArrayList<Integer>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (!((Boolean)this.table.getValueAt(i, 1)).booleanValue()) continue;
            cols.add(i + 1);
        }
        return cols.stream().mapToInt(Integer::intValue).toArray();
    }

    public boolean isOK() {
        return this.isOK;
    }

    private void initComponents() {
        this.dialogPanel1 = new DialogPanel();
        this.bOk = new JButton();
        this.bCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.lblSelectAll = new HyperLinkLabel();
        this.jLabel1 = new JLabel();
        this.lblSelectNone = new HyperLinkLabel();
        this.setDefaultCloseOperation(2);
        this.bOk.setText("Ok");
        this.dialogPanel1.add((Component)this.bOk);
        this.bCancel.setText("Cancel");
        this.dialogPanel1.add((Component)this.bCancel);
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.table.setAutoResizeMode(4);
        this.jScrollPane1.setViewportView(this.table);
        this.lblSelectAll.setText("Select all");
        this.jLabel1.setText("|");
        this.lblSelectNone.setText("Select none");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dialogPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 480, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent((Component)this.lblSelectAll, -2, -1, -2).addGap(5, 5, 5).addComponent(this.jLabel1).addGap(5, 5, 5).addComponent((Component)this.lblSelectNone, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 183, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.lblSelectAll, -2, -1, -2).addComponent(this.jLabel1).addComponent((Component)this.lblSelectNone, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.dialogPanel1, -2, 46, -2)));
        this.pack();
    }
}

