/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.simmatrix;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JPanel;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.results.SimMatrix;
import jhi.flapjack.gui.simmatrix.SimMatrixPanel;

public class SimMatrixCanvas
extends JPanel {
    private SimMatrixPanel sPanel;
    private SimMatrix matrix;
    int boxTotalX;
    int boxTotalY;
    int canvasW;
    int canvasH;
    int boxW;
    int boxH;
    int boxCountX;
    int boxCountY;
    int pX1;
    int pY1;
    int pX2;
    int pY2;
    int pX2Max;
    int pY2Max;
    private int cores = Runtime.getRuntime().availableProcessors();
    private ExecutorService executor;
    private Future[] tasks;
    BufferedImage imageViewPort;
    boolean redraw = true;
    int[][] colors;
    Point pCenter;
    Point bCenter;
    private GTViewSet viewSet;

    public SimMatrixCanvas(SimMatrixPanel sPanel, SimMatrix matrix) {
        this.sPanel = sPanel;
        this.matrix = matrix;
        this.viewSet = this.viewSet;
        this.setOpaque(false);
        this.executor = Executors.newFixedThreadPool(this.cores);
        this.tasks = new Future[this.cores];
    }

    void onResize(int sizeX, int sizeY) {
        this.boxW = sizeX;
        this.boxH = sizeY;
        this.boxTotalX = this.matrix.size();
        this.boxTotalY = this.matrix.size();
        this.canvasW = this.boxTotalX * this.boxW;
        this.canvasH = this.boxTotalY * this.boxH;
        this.setPreferredSize(new Dimension(this.canvasW, this.canvasH));
        this.resetBufferedState(true);
    }

    void onRedraw(Dimension viewSize, Point viewPosition) {
        this.boxCountX = 1 + (int)((float)viewSize.getWidth() / (float)this.boxW);
        this.boxCountY = 1 + (int)((float)viewSize.getHeight() / (float)this.boxH);
        this.pX1 = viewPosition.x;
        this.pX2 = this.pX2Max = this.pX1 + viewSize.width - 1;
        this.pY1 = viewPosition.y;
        this.pY2 = this.pY2Max = this.pY1 + viewSize.height - 1;
        if (this.pX2 >= this.canvasW) {
            this.pX2 = this.canvasW - 1;
        }
        if (this.pY2 >= this.canvasH) {
            this.pY2 = this.canvasH - 1;
        }
        int pCenterX = this.pX1 + (this.pX2 - this.pX1 + 1) / 2;
        int pCenterY = this.pY1 + (this.pY2 - this.pY1 + 1) / 2;
        this.pCenter = new Point(pCenterX, pCenterY);
        this.bCenter = new Point(pCenterX / this.boxW, pCenterY / this.boxH);
        this.redraw = true;
        this.repaint();
    }

    void resetBufferedState(boolean createNewBuffer) {
        this.redraw = true;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g = (Graphics2D)graphics;
        this.renderViewport(g);
    }

    private void renderViewport(Graphics2D g) {
        if (this.redraw) {
            int i;
            int w = this.pX2 - this.pX1 + 1;
            int h = this.pY2 - this.pY1 + 1;
            if (this.imageViewPort == null || this.imageViewPort.getWidth() != w || this.imageViewPort.getHeight() != h) {
                this.imageViewPort = (BufferedImage)this.createImage(w, h);
            }
            Graphics2D[] graphics = new Graphics2D[this.cores];
            for (i = 0; i < graphics.length; ++i) {
                graphics[i] = this.imageViewPort.createGraphics();
                graphics[i].translate(-this.pX1, -this.pY1);
            }
            this.renderRegion(graphics);
            for (i = 0; i < graphics.length; ++i) {
                graphics[i].dispose();
            }
        }
        g.drawImage((Image)this.imageViewPort, this.pX1, this.pY1, null);
        this.redraw = false;
    }

    private void renderRegion(Graphics2D[] g) {
        int yE;
        int xS = this.pX1 / this.boxW;
        int yS = this.pY1 / this.boxH;
        int xE = xS + this.boxCountX;
        if (xE >= this.boxTotalX) {
            xE = this.boxTotalX - 1;
        }
        if ((yE = yS + this.boxCountY) >= this.boxTotalY) {
            yE = this.boxTotalY - 1;
        }
        this.render(g, xS, xE, yS, yE);
    }

    private void render(Graphics2D[] g, int xS, int xE, int yS, int yE) {
        try {
            for (int i = 0; i < this.tasks.length; ++i) {
                this.tasks[i] = this.executor.submit(new LinePainter(g[i], xS, xE, yS + i, yE));
            }
            for (Future task : this.tasks) {
                task.get();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final class LinePainter
    implements Runnable {
        private Graphics2D g;
        private int xS;
        private int xE;
        private int yS;
        private int yE;

        LinePainter(Graphics2D g, int xS, int xE, int yS, int yE) {
            this.g = g;
            this.xS = xS;
            this.xE = xE;
            this.yS = yS;
            this.yE = yE;
        }

        @Override
        public void run() {
            Color col1 = Color.blue;
            int[] c1 = new int[]{col1.getRed(), col1.getGreen(), col1.getBlue()};
            Color col2 = Color.white;
            int[] c2 = new int[]{col2.getRed(), col2.getGreen(), col2.getBlue()};
            int row = this.yS;
            int y = SimMatrixCanvas.this.boxH * this.yS;
            while (row <= this.yE) {
                int xIndex = this.xS;
                int x = SimMatrixCanvas.this.boxW * this.xS;
                while (xIndex <= this.xE) {
                    float f = 0.0f;
                    f = xIndex <= row ? SimMatrixCanvas.this.matrix.valueAt(row, xIndex) : SimMatrixCanvas.this.matrix.valueAt(xIndex, row);
                    float f1 = (float)(1.0 - (double)f);
                    float f2 = f;
                    this.g.setColor(new Color((int)(f1 * (float)c1[0] + f2 * (float)c2[0]), (int)(f1 * (float)c1[1] + f2 * (float)c2[1]), (int)(f1 * (float)c1[2] + f2 * (float)c2[2])));
                    this.g.fillRect(x, y, SimMatrixCanvas.this.boxW, SimMatrixCanvas.this.boxH);
                    ++xIndex;
                    x += SimMatrixCanvas.this.boxW;
                }
                row += SimMatrixCanvas.this.cores;
                y += SimMatrixCanvas.this.boxH * SimMatrixCanvas.this.cores;
            }
        }
    }
}

