/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.simmatrix;

import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jhi.flapjack.gui.simmatrix.SimMatrixCanvas;
import jhi.flapjack.gui.simmatrix.SimMatrixPanel;

public class CanvasController
implements ChangeListener {
    private SimMatrixPanel sPanel;
    private SimMatrixCanvas sCanvas;
    private JViewport viewport;
    private JScrollBar hBar;
    private JScrollBar vBar;
    int zoomX = 2;
    int zoomY = 2;

    CanvasController(SimMatrixPanel sPanel, JScrollPane sp) {
        this.sPanel = sPanel;
        this.sCanvas = sPanel.getSimMatrixCanvas();
        this.viewport = sp.getViewport();
        this.viewport.addChangeListener(this);
        this.hBar = sp.getHorizontalScrollBar();
        this.vBar = sp.getVerticalScrollBar();
        this.computePanelSizes();
    }

    void computePanelSizes() {
        this.sCanvas.onResize(this.zoomX, this.zoomY);
        this.setScrollbarAdjustmentValues(this.sCanvas.boxW, this.sCanvas.boxH);
    }

    private void setScrollbarAdjustmentValues(int xIncrement, int yIncrement) {
        this.hBar.setUnitIncrement(xIncrement);
        this.hBar.setBlockIncrement(xIncrement);
        this.vBar.setUnitIncrement(yIncrement);
        this.vBar.setBlockIncrement(yIncrement);
    }

    void moveBy(int x, int y) {
        this.hBar.setValue(this.hBar.getValue() + x);
        this.vBar.setValue(this.vBar.getValue() + y);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.sCanvas.onRedraw(this.viewport.getExtentSize(), this.viewport.getViewPosition());
    }

    void clickZoom(MouseEvent e) {
        int oldCanvasW = this.sCanvas.canvasW;
        int clickX = e.getX();
        int clickY = e.getY();
        System.out.println("OLD X: " + clickX + " Y: " + clickY);
        System.out.println("Over box X: " + clickX / this.sCanvas.boxW + " Y: " + clickY / this.sCanvas.boxH);
        int centreX = this.sCanvas.pCenter.x;
        int centreY = this.sCanvas.pCenter.y;
        int newCanvasW = this.sCanvas.boxTotalX * (++this.zoomX * 2);
        System.out.println("oldW: " + oldCanvasW + " newW: " + newCanvasW);
        float scale = (float)newCanvasW / (float)oldCanvasW;
        int moveX = clickX - centreX;
        int moveY = clickY - centreY;
        int scaledMoveX = (int)((float)moveX * scale);
        int scaledMoveY = (int)((float)moveY * scale);
        System.out.println("MoveX: " + moveX + " scaled: " + scaledMoveX + " moveY: " + moveY + " scaled: " + scaledMoveY);
        this.moveBy(scaledMoveX, scaledMoveY);
        ++this.zoomX;
        ++this.zoomY;
        this.computePanelSizes();
        System.out.println("NEW X: " + this.sCanvas.pCenter.x + " Y: " + this.sCanvas.pCenter.y);
        System.out.println("Over box X: " + this.sCanvas.pCenter.x / this.sCanvas.boxW + " Y: " + this.sCanvas.pCenter.y / this.sCanvas.boxH);
    }
}

