/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.pedigree.PedManager;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import scri.commons.gui.RB;
import scri.commons.gui.matisse.DialogPanel;

public class SelectParentsDialog
extends JDialog
implements ActionListener {
    private GTView view;
    private PedManager pm;
    private DefaultComboBoxModel<IndexWrapper> p1Model = new DefaultComboBoxModel();
    private DefaultComboBoxModel<IndexWrapper> p2Model = new DefaultComboBoxModel();
    private ArrayList<IndexWrapper> allLines = new ArrayList();
    private boolean isOK;
    private JButton bCancel;
    private JButton bOK;
    private DialogPanel dialogPanel1;
    private JComboBox<IndexWrapper> p1Combo;
    private JLabel p1Label;
    private JComboBox<IndexWrapper> p2Combo;
    private JLabel p2Label;
    private JCheckBox parentsOnly;

    public SelectParentsDialog(GTView view) {
        super(Flapjack.winMain, RB.getString((String)"gui.dialog.SelectParentsDialog.title"), true);
        this.view = view;
        this.isOK = false;
        this.initComponents();
        this.initComponents2();
        FlapjackUtils.initDialog(this, this.bOK, this.bCancel, true, this.getContentPane());
    }

    private void initComponents2() {
        RB.setText((AbstractButton)this.bOK, (String)"gui.text.ok");
        this.bOK.addActionListener(this);
        RB.setText((AbstractButton)this.bCancel, (String)"gui.text.cancel");
        this.bCancel.addActionListener(this);
        this.pm = this.view.getViewSet().getDataSet().getPedManager();
        if (this.pm.getPedigrees().size() == 0) {
            this.parentsOnly.setEnabled(false);
        }
        this.parentsOnly.addActionListener(this);
        for (int i = 0; i < this.view.lineCount(); ++i) {
            this.allLines.add(new IndexWrapper(this.view.getLineInfo(i), i));
        }
        this.initModels();
        if (!this.parentsOnly.isSelected()) {
            int index = this.view.mouseOverLine;
            if (this.p1Model.getSize() > index) {
                this.p1Combo.setSelectedIndex(index);
            }
            if (this.p2Model.getSize() > index + 1) {
                this.p2Combo.setSelectedIndex(index + 1);
            }
        }
        this.p1Combo.addActionListener(e -> this.checkStates());
        this.p2Combo.addActionListener(e -> this.checkStates());
        this.checkStates();
    }

    private void checkStates() {
        this.bOK.setEnabled(this.p1Combo.getSelectedIndex() != this.p2Combo.getSelectedIndex());
    }

    private void initModels() {
        this.initModel(this.p1Combo, this.p1Model);
        this.initModel(this.p2Combo, this.p2Model);
        this.checkStates();
    }

    private void initModel(JComboBox<IndexWrapper> combo, DefaultComboBoxModel<IndexWrapper> model) {
        boolean parOnly = this.parentsOnly.isSelected();
        IndexWrapper sel = model.getElementAt(combo.getSelectedIndex());
        model.removeAllElements();
        for (int i = 0; i < this.allLines.size(); ++i) {
            if (parOnly && (!parOnly || !this.pm.isParent(this.allLines.get((int)i).line))) continue;
            model.addElement(this.allLines.get(i));
        }
        combo.setModel(model);
        if (sel != null) {
            combo.setSelectedItem(sel);
        }
    }

    public int getParent1() {
        IndexWrapper wrapper = (IndexWrapper)this.p1Combo.getSelectedItem();
        return wrapper.index;
    }

    public int getParent2() {
        IndexWrapper wrapper = (IndexWrapper)this.p2Combo.getSelectedItem();
        return wrapper.index;
    }

    public boolean isOK() {
        return this.isOK;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOK) {
            this.isOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.bCancel) {
            this.setVisible(false);
        } else if (e.getSource() == this.parentsOnly) {
            this.initModels();
        }
    }

    private void initComponents() {
        this.dialogPanel1 = new DialogPanel();
        this.bOK = new JButton();
        this.bCancel = new JButton();
        this.p2Label = new JLabel();
        this.p1Label = new JLabel();
        this.p1Combo = new JComboBox();
        this.p2Combo = new JComboBox();
        this.parentsOnly = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.bOK.setText("OK");
        this.dialogPanel1.add((Component)this.bOK);
        this.bCancel.setText("Cancel");
        this.dialogPanel1.add((Component)this.bCancel);
        this.p2Label.setText("Select 2nd parent line:");
        this.p2Label.setToolTipText("");
        this.p1Label.setText("Select 1st parent line:");
        this.p1Label.setToolTipText("");
        this.parentsOnly.setText("Only list known parental lines (using any imported pedigree information)");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dialogPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.parentsOnly).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.p1Label).addComponent(this.p2Label)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.p2Combo, 0, -1, Short.MAX_VALUE).addComponent(this.p1Combo, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.p1Label).addComponent(this.p1Combo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.p2Label).addComponent(this.p2Combo, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.parentsOnly).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.dialogPanel1, -2, 44, -2)));
        this.pack();
    }

    static class IndexWrapper {
        LineInfo line;
        int index;

        IndexWrapper(LineInfo line, int index) {
            this.line = line;
            this.index = index;
        }

        public String toString() {
            return this.line.toString();
        }
    }
}

