/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jhi.flapjack.analysis.CalculateMarkerFrequencies;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.visualization.GenotypePanel;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.ProgressDialog;
import scri.commons.gui.RB;
import scri.commons.gui.matisse.DialogPanel;

public class AlleleFrequencyDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private boolean isOK = true;
    private GenotypePanel gPanel;
    private GTViewSet viewSet;
    private JButton bHelp;
    private JButton bOK;
    private DialogPanel dialogPanel1;
    private JLabel hintLabel;
    private JLabel percentLabel;
    private JSlider slider;
    private JLabel thresholdLabel;

    public AlleleFrequencyDialog(GenotypePanel gPanel) {
        super(Flapjack.winMain, RB.getString((String)"gui.dialog.AlleleFrequencyDialog.title"), true);
        this.gPanel = gPanel;
        this.viewSet = gPanel.getViewSet();
        this.initComponents();
        this.initComponents2();
        FlapjackUtils.initDialog(this, this.bOK, this.bOK, true, this.getContentPane());
    }

    private void initComponents2() {
        RB.setText((AbstractButton)this.bOK, (String)"gui.text.ok");
        this.bOK.addActionListener(this);
        RB.setText((AbstractButton)this.bHelp, (String)"gui.text.help");
        FlapjackUtils.setHelp(this.bHelp, "allele_frequency_threshold.html");
        RB.setText((JLabel)this.thresholdLabel, (String)"gui.dialog.NBAlleleFrequencyPanel.thresholdLabel");
        RB.setText((JLabel)this.hintLabel, (String)"gui.dialog.NBAlleleFrequencyPanel.hintLabel");
        this.slider.addChangeListener(this);
        int value = (int)(this.viewSet.getAlleleFrequencyThreshold() * 200.0f);
        this.slider.setValue(value);
    }

    public boolean isOK() {
        return this.isOK;
    }

    public static boolean calculate(GTViewSet viewSet) {
        DataSet dataSet = viewSet.getDataSet();
        CalculateMarkerFrequencies cmf = new CalculateMarkerFrequencies(dataSet, 0);
        ProgressDialog dialog = new ProgressDialog((ITrackableJob)cmf, RB.format((String)"gui.dialog.NBAlleleFrequencyPanel.calculatingTitle", (Object[])new Object[0]), RB.format((String)"gui.dialog.NBAlleleFrequencyPanel.calculatingLabel", (Object[])new Object[0]), (Frame)Flapjack.winMain);
        return dialog.getResult() == 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOK) {
            this.isOK = true;
            this.setVisible(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int value = this.slider.getValue();
        float threshold = (float)value / 200.0f;
        float percent = (float)value / 2.0f;
        this.percentLabel.setText(percent + "%");
        this.viewSet.setAlleleFrequencyThreshold(threshold);
        if (!AlleleFrequencyDialog.calculate(this.viewSet)) {
            this.isOK = false;
            this.setVisible(false);
        } else {
            this.viewSet.setColorScheme(7);
            this.gPanel.refreshView();
            Actions.projectModified();
        }
    }

    private void initComponents() {
        this.dialogPanel1 = new DialogPanel();
        this.bOK = new JButton();
        this.bHelp = new JButton();
        this.hintLabel = new JLabel();
        this.thresholdLabel = new JLabel();
        this.percentLabel = new JLabel();
        this.slider = new JSlider();
        this.setDefaultCloseOperation(2);
        this.bOK.setText("OK");
        this.dialogPanel1.add((Component)this.bOK);
        this.bHelp.setText("Help");
        this.dialogPanel1.add((Component)this.bHelp);
        this.hintLabel.setText("To adjust this threshold later on, simply reapply the colour scheme");
        this.thresholdLabel.setText("Low/high cutoff threshold:");
        this.percentLabel.setText("50%");
        this.slider.setMajorTickSpacing(50);
        this.slider.setMaximum(200);
        this.slider.setMinorTickSpacing(10);
        this.slider.setPaintTicks(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dialogPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.slider, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.thresholdLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.percentLabel)).addComponent(this.hintLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.thresholdLabel).addComponent(this.percentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slider, -2, 33, -2).addGap(18, 18, 18).addComponent(this.hintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.dialogPanel1, -2, -1, -2)));
        this.pack();
    }
}

