/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui;

import jhi.flapjack.data.Bookmark;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.Marker;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.NavPanel;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.dialog.NewViewDialog;
import jhi.flapjack.gui.dialog.RenameDialog;
import jhi.flapjack.gui.dialog.ToggleCanvasDialog;
import jhi.flapjack.gui.navpanel.BaseNode;
import jhi.flapjack.gui.navpanel.DendrogramNode;
import jhi.flapjack.gui.navpanel.MabcNode;
import jhi.flapjack.gui.navpanel.PedVerF1sNode;
import jhi.flapjack.gui.navpanel.PedVerLinesNode;
import jhi.flapjack.gui.navpanel.SimMatrixNode;
import jhi.flapjack.gui.navpanel.VisualizationChildNode;
import jhi.flapjack.gui.navpanel.VisualizationNode;
import jhi.flapjack.gui.visualization.BookmarkHighlighter;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.OverviewManager;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;

public class MenuView {
    private NavPanel navPanel;
    private GenotypePanel gPanel;

    void setComponents(NavPanel navPanel) {
        this.navPanel = navPanel;
        this.gPanel = navPanel.getGenotypePanel();
    }

    void viewNewView() {
        GTViewSet viewSet;
        DataSet dataSet = this.navPanel.getDataSetForSelection();
        NewViewDialog dialog = new NewViewDialog(dataSet, viewSet = this.navPanel.getViewSetForSelection());
        if (dialog.isOK()) {
            GTViewSet newViewSet = dialog.getNewViewSet();
            dataSet.getViewSets().add(newViewSet);
            this.navPanel.addVisualizationNode(dataSet, newViewSet);
            Actions.projectModified();
        }
    }

    void viewRenameView() {
        VisualizationChildNode vNode;
        RenameDialog dialog;
        BaseNode node = this.navPanel.getNodeForSelection();
        if (node instanceof VisualizationNode) {
            GTViewSet viewSet = ((VisualizationNode)node).getViewSet();
            RenameDialog dialog2 = new RenameDialog(viewSet.getName());
            if (dialog2.isOK()) {
                viewSet.setName(dialog2.getNewName());
                this.navPanel.updateNodeFor(viewSet);
                Actions.projectModified();
            }
        } else if (node instanceof VisualizationChildNode && (dialog = new RenameDialog((vNode = (VisualizationChildNode)node).getName())).isOK()) {
            String newName = dialog.getNewName();
            vNode.setName(newName);
            if (vNode instanceof MabcNode || vNode instanceof PedVerF1sNode || vNode instanceof PedVerLinesNode) {
                GTViewSet viewSet = vNode.getViewSet();
                viewSet.getLines().forEach(line -> line.getResults().setName(newName));
            } else if (vNode instanceof SimMatrixNode) {
                SimMatrixNode sNode = (SimMatrixNode)vNode;
                sNode.getMatrix().setTitle(newName);
            } else if (vNode instanceof DendrogramNode) {
                DendrogramNode dNode = (DendrogramNode)vNode;
                dNode.getDendrogram().setTitle(newName);
            }
            this.navPanel.updateNode(vNode);
            Actions.projectModified();
        }
    }

    void viewDeleteView() {
        GTViewSet viewSet = this.navPanel.getViewSetForSelection();
        String msg = RB.format((String)"gui.WinMain.deleteViewSet", (Object[])new Object[]{viewSet.getName(), viewSet.getDataSet().getName()});
        String[] options = new String[]{RB.getString((String)"gui.WinMain.deleteViewSetButton"), RB.getString((String)"gui.text.cancel")};
        if (TaskDialog.show((String)msg, (int)3, (int)1, (String[])options) == 0) {
            viewSet.getDataSet().getViewSets().remove(viewSet);
            this.navPanel.removeVisualizationNode(viewSet);
            Actions.projectModified();
        }
    }

    void viewBookmark() {
        GTView view = this.gPanel.getView();
        ChromosomeMap chromosome = view.getChromosomeMap();
        Line line = view.getLine(view.mouseOverLine);
        Marker marker = view.getMarker(view.mouseOverMarker);
        Bookmark bookmark = new Bookmark(chromosome, line, marker);
        BookmarkHighlighter.enable = false;
        view.getViewSet().getBookmarks().add(bookmark);
        this.navPanel.addBookmarkNode(view.getViewSet(), bookmark);
        Actions.projectModified();
    }

    void viewDeleteBookmark() {
        GTViewSet viewSet = this.gPanel.getViewSet();
        Bookmark bookmark = this.navPanel.removeSelectedBookmarkNode();
        viewSet.getBookmarks().remove(bookmark);
        Actions.projectModified();
    }

    void viewOverview() {
        OverviewManager.toggleOverviewDialog();
    }

    void viewToggleCanvas() {
        new ToggleCanvasDialog(this.gPanel);
    }

    void viewPageLeft() {
        this.gPanel.getController().pageLeft();
    }

    void viewPageRight() {
        this.gPanel.getController().pageRight();
    }

    void viewGenotypesOrChromosomes(boolean showChromosomes) {
        Prefs.visShowChromosomes = showChromosomes;
        Actions.viewGenotypes.putValue("SwingSelectedKey", !Prefs.visShowChromosomes);
        Actions.viewChromosomes.putValue("SwingSelectedKey", Prefs.visShowChromosomes);
        this.navPanel.toggleGenotypePanelViews();
    }
}

