/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui;

import apple.dts.samplecode.osxadapter.OSXAdapter;
import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Locale;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.UIManager;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.WinMain;
import jhi.flapjack.gui.WinMainMenuBar;
import jhi.flapjack.gui.dialog.CitationDialog;
import jhi.flapjack.gui.visualization.colors.WebsafePalette;
import jhi.flapjack.io.FlapjackFile;
import scri.commons.gui.Icons;
import scri.commons.gui.Install4j;
import scri.commons.gui.RB;
import scri.commons.gui.SystemUtils;
import scri.commons.gui.TaskDialog;
import scri.commons.gui.UIScaler;
import scri.commons.io.FileUtils;

public class Flapjack {
    private static File prefsFile = Flapjack.getPrefsFile();
    private static Prefs prefs = new Prefs();
    private static String[] initialProject;
    public static WinMain winMain;

    public static void main(String[] args) throws Exception {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Flapjack");
        System.out.println("Flapjack " + Install4j.getVersion(Flapjack.class) + " on " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ")");
        new WebsafePalette();
        Prefs.setDefaults();
        prefs.loadPreferences(prefsFile, Prefs.class);
        prefs.savePreferences(prefsFile, Prefs.class);
        Prefs.uiScale = UIScaler.init((float)Prefs.uiScale, (boolean)Prefs.uiScaleAuto);
        Icons.initialize((String)"/res/icons", (String)".png");
        RB.initialize((String)Prefs.localeText, (String)"res.text.flapjack");
        if (Prefs.guiDecimalEnglish) {
            Locale.setDefault(Locale.UK);
        }
        Flapjack.setProxy();
        FlapjackUtils.initialiseSqlite();
        if (args.length >= 1) {
            initialProject = args;
        }
        Flapjack.install4j();
        new Flapjack();
    }

    private static void install4j() {
        Install4j i4j = new Install4j("9131-7045-2417-5931", "418");
        i4j.setUser(Prefs.guiUpdateSchedule, Prefs.flapjackID, Prefs.rating);
        i4j.setURLs("http://bioinf.hutton.ac.uk/flapjack/installers/updates.xml", "http://bioinf.hutton.ac.uk/flapjack/logs/flapjack.pl");
        i4j.doStartUpCheck(Flapjack.class);
    }

    Flapjack() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            UIManager.put("TextArea.font", UIManager.get("TextField.font"));
            UIManager.put("TabbedPane.focus", new Color(0, 0, 0, 0));
            UIManager.put("fjDialogBG", Color.white);
            UIManager.put("Slider.background", Color.white);
            UIManager.put("CheckBox.background", Color.white);
            UIManager.put("RadioButton.background", Color.white);
            UIManager.put("CheckBox.border", BorderFactory.createEmptyBorder(0, 0, 0, 0));
            if (SystemUtils.isWindowsXP()) {
                UIManager.put("Panel.background", new Color(240, 240, 240));
            } else if (SystemUtils.isMacOS()) {
                this.handleOSXStupidities();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        winMain = new WinMain();
        winMain.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!winMain.okToExit()) {
                    return;
                }
                Flapjack.this.shutdown();
            }

            @Override
            public void windowOpened(WindowEvent e) {
                long thirtyDays = 2592000000L;
                long thirtyDaysAgo = System.currentTimeMillis() - thirtyDays;
                if (!Prefs.isFirstRun && Long.valueOf(Prefs.visColorSeed) < thirtyDaysAgo) {
                    Prefs.visColorSeed = "" + System.currentTimeMillis();
                    prefs.savePreferences(prefsFile, Prefs.class);
                    new CitationDialog();
                }
                if (initialProject != null) {
                    Flapjack.winMain.mFile.handleDragDrop(initialProject);
                }
            }

            @Override
            public void windowIconified(WindowEvent e) {
                WinMainMenuBar.mWndFlapjack.setSelected(false);
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                WinMainMenuBar.mWndFlapjack.setSelected(true);
            }
        });
        TaskDialog.initialize((JFrame)winMain, (String)"Flapjack");
        TaskDialog.initialize((File)FlapjackUtils.getLogFile(), (String)RB.getString((String)"gui.text.log"), (String)RB.getString((String)"gui.text.close"));
        winMain.setVisible(true);
    }

    public static void setProxy() {
        Properties p = System.getProperties();
        if (Prefs.proxyUse) {
            if (!Prefs.proxySocks) {
                p.setProperty("http.proxyHost", Prefs.proxyAddress);
                p.setProperty("https.proxyHost", Prefs.proxyAddress);
                p.setProperty("http.proxyPort", "" + Prefs.proxyPort);
            } else {
                p.setProperty("socksProxyHost", Prefs.proxyAddress);
                p.setProperty("socksProxyPort", "" + Prefs.proxyPort);
            }
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(Prefs.proxyUsername, Prefs.proxyPassword.toCharArray());
                }
            });
        } else {
            p.remove("http.proxyHost");
            p.remove("http.proxyPort");
            p.remove("socksProxyHost");
            p.remove("socksProxyPort");
        }
    }

    private void shutdown() {
        Prefs.isFirstRun = false;
        prefs.savePreferences(prefsFile, Prefs.class);
        FileUtils.emptyDirectory((File)FlapjackUtils.getCacheDir(), (boolean)true);
        System.exit(0);
    }

    private static File getPrefsFile() {
        File fldr = new File(System.getProperty("user.home"), ".scri-bioinf");
        fldr.mkdirs();
        File file = new File(fldr, "flapjack.xml");
        if (file.exists()) {
            return file;
        }
        File old = new File(System.getProperty("user.home"), ".flapjack.xml");
        if (old.exists()) {
            try {
                FileUtils.copyFile((File)old, (File)file, (boolean)true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    private void handleOSXStupidities() {
        try {
            OSXAdapter.setPreferencesHandler((Object)this, (Method)this.getClass().getDeclaredMethod("osxPreferences", null));
            OSXAdapter.setAboutHandler((Object)this, (Method)this.getClass().getDeclaredMethod("osxAbout", null));
            OSXAdapter.setQuitHandler((Object)this, (Method)this.getClass().getDeclaredMethod("osxShutdown", null));
            OSXAdapter.setFileHandler((Object)this, (Method)this.getClass().getDeclaredMethod("osxOpen", String.class));
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void osxPreferences() {
        Flapjack.winMain.mHelp.helpPrefs();
    }

    public void osxAbout() {
        Flapjack.winMain.mHelp.helpAbout();
    }

    public void osxOpen(String path) {
        if (winMain != null && winMain.isVisible()) {
            Flapjack.winMain.mFile.fileOpen(new FlapjackFile(path));
        } else {
            initialProject = new String[]{path};
        }
    }

    public boolean osxShutdown() {
        if (!winMain.okToExit()) {
            return false;
        }
        this.shutdown();
        return true;
    }

    static void osxMinimize() {
        winMain.setExtendedState(1);
    }

    static void osxZoom() {
        if (winMain.getExtendedState() == 0) {
            winMain.setExtendedState(6);
        } else {
            winMain.setExtendedState(0);
        }
    }

    static void osxFlapjack() {
        if (Prefs.guiWinMainMaximized) {
            winMain.setExtendedState(6);
        } else {
            winMain.setExtendedState(0);
        }
        WinMainMenuBar.mWndFlapjack.setSelected(true);
    }
}

