/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data;

import java.awt.Color;
import java.util.HashMap;
import jhi.flapjack.data.Trait;
import jhi.flapjack.data.XMLRoot;
import jhi.flapjack.gui.Prefs;

public class TraitColors
extends XMLRoot {
    private HashMap<String, Integer> colors = new HashMap();

    public HashMap<String, Integer> getColors() {
        return this.colors;
    }

    public void setColors(HashMap<String, Integer> colors) {
        this.colors = colors;
    }

    public void clear() {
        this.colors.clear();
    }

    public void put(String key, Color value) {
        this.colors.put(key, value.getRGB());
    }

    public Color get(String key) {
        Integer rgb = this.colors.get(key);
        if (rgb != null) {
            return new Color(rgb);
        }
        return null;
    }

    public Color queryLow() {
        if (this.colors.size() > 0 && this.colors.containsKey("FLAPJACK_LW")) {
            return this.get("FLAPJACK_LW");
        }
        return Prefs.visColorHeatmapLow;
    }

    public Color queryHigh() {
        if (this.colors.size() > 0 && this.colors.containsKey("FLAPJACK_HG")) {
            return this.get("FLAPJACK_HG");
        }
        return Prefs.visColorHeatmapHigh;
    }

    Color displayColor(Trait trait, float value, float normal) {
        String key;
        if (this.colors.size() > 0 && !trait.traitIsNumerical() && this.colors.containsKey(key = trait.getCategories().get((int)value))) {
            return this.get(key);
        }
        Color col1 = this.queryLow();
        int[] c1 = new int[]{col1.getRed(), col1.getGreen(), col1.getBlue()};
        Color col2 = this.queryHigh();
        int[] c2 = new int[]{col2.getRed(), col2.getGreen(), col2.getBlue()};
        float f1 = 1.0f - normal;
        float f2 = normal;
        Color color = new Color((int)(f1 * (float)c1[0] + f2 * (float)c2[0]), (int)(f1 * (float)c1[1] + f2 * (float)c2[1]), (int)(f1 * (float)c1[2] + f2 * (float)c2[2]));
        return color;
    }
}

