/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data;

import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.XMLRoot;
import scri.commons.MatrixXML;

public class GraphData
extends XMLRoot {
    private String name;
    private ChromosomeMap map;
    private float[] data;
    private float min = Float.MAX_VALUE;
    private float max = Float.MIN_VALUE;
    private boolean hasThreshold = false;
    private float threshold;

    public GraphData() {
    }

    public GraphData(ChromosomeMap map, String name) {
        this.map = map;
        this.data = new float[map.countLoci()];
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getData() {
        return MatrixXML.arrayToString((float[])this.data);
    }

    public void setData(String dataStr) {
        this.data = MatrixXML.stringToFloatArray((String)dataStr);
    }

    public float getMinimum() {
        return this.min;
    }

    public void setMinimum(float min) {
        this.min = min;
    }

    public float getMaximum() {
        return this.max;
    }

    public void setMaximum(float max) {
        this.max = max;
    }

    public boolean getHasThreshold() {
        return this.hasThreshold;
    }

    public void setHasThreshold(boolean hasThreshold) {
        this.hasThreshold = hasThreshold;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public void determineLimits() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.map.getMarkerByIndex(i).dummyMarker()) continue;
            if (this.data[i] < this.min) {
                this.min = this.data[i];
            }
            if (!(this.data[i] > this.max)) continue;
            this.max = this.data[i];
        }
    }

    public void setValue(int mrkIndex, float value) {
        this.data[mrkIndex] = value;
    }

    public void normalize() {
        if (this.hasThreshold) {
            this.min = Math.min(this.threshold, this.min);
            this.max = Math.max(this.threshold, this.max);
            this.threshold = (this.threshold - this.min) / (this.max - this.min);
            if (Float.isNaN(this.threshold)) {
                this.threshold = 0.0f;
            }
        }
        for (int d = 0; d < this.data.length; ++d) {
            this.data[d] = (this.data[d] - this.min) / (this.max - this.min);
            if (!Float.isNaN(this.data[d]) && !Float.isInfinite(this.data[d])) continue;
            this.data[d] = 0.0f;
        }
    }

    public float getRealValueAt(int mIndex) {
        float value = this.data[mIndex];
        value = value * (this.max - this.min) + this.min;
        return value;
    }

    public float[] data() {
        return this.data;
    }

    public void setArrayData(float[] data) {
        this.data = data;
    }
}

