/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data;

import java.util.ArrayList;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.Marker;
import jhi.flapjack.data.MarkerInfo;
import jhi.flapjack.data.QTLInfo;
import jhi.flapjack.data.XMLRoot;

public class GTView
extends XMLRoot {
    private GTViewSet viewSet;
    private ChromosomeMap map;
    private int chrIndex;
    private ArrayList<MarkerInfo> markers = new ArrayList();
    private ArrayList<MarkerInfo> hideMarkers = new ArrayList();
    private ArrayList<QTLInfo> qtls = new ArrayList();
    public int mouseOverLine = -1;
    public int mouseOverMarker = -1;
    private Marker comparisonMarker = null;
    private int comparisonMarkerIndex = -1;
    private boolean markersOrdered = false;

    public GTView() {
    }

    public GTView(GTViewSet viewSet, ChromosomeMap map, boolean isNew) {
        this.viewSet = viewSet;
        this.map = map;
        this.chrIndex = viewSet.getDataSet().getChromosomeMaps().indexOf(map);
        this.markers = new ArrayList(map.countLoci());
        for (int i = 0; i < map.countLoci(); ++i) {
            Marker m = map.getMarkerByIndex(i);
            this.markers.add(new MarkerInfo(m, i));
        }
        this.markers.trimToSize();
        if (isNew) {
            this.markersOrdered = true;
        }
    }

    void validate() throws NullPointerException {
        if (this.viewSet == null || this.map == null || this.markers == null) {
            throw new NullPointerException();
        }
        this.chrIndex = this.viewSet.getDataSet().getChromosomeMaps().indexOf(this.map);
    }

    public GTViewSet getViewSet() {
        return this.viewSet;
    }

    public void setViewSet(GTViewSet viewSet) {
        this.viewSet = viewSet;
    }

    public ChromosomeMap getChromosomeMap() {
        return this.map;
    }

    public void setChromosomeMap(ChromosomeMap map) {
        this.map = map;
    }

    public ArrayList<MarkerInfo> getMarkers() {
        return this.markers;
    }

    public void setMarkers(ArrayList<MarkerInfo> markers) {
        this.markers = markers;
    }

    public ArrayList<MarkerInfo> getHideMarkers() {
        return this.hideMarkers;
    }

    public void setHideMarkers(ArrayList<MarkerInfo> hideMarkers) {
        this.hideMarkers = hideMarkers;
    }

    public Marker getComparisonMarker() {
        return this.comparisonMarker;
    }

    public void setComparisonMarker(Marker comparisonMarker) {
        this.comparisonMarker = comparisonMarker;
    }

    public int getComparisonMarkerIndex() {
        return this.comparisonMarkerIndex;
    }

    public void setComparisonMarkerIndex(int comparisonMarkerIndex) {
        this.comparisonMarkerIndex = comparisonMarkerIndex;
    }

    public boolean getMarkersOrdered() {
        return this.markersOrdered;
    }

    public void setMarkersOrdered(boolean markersOrdered) {
        this.markersOrdered = markersOrdered;
    }

    public ArrayList<QTLInfo> getQTLs() {
        return this.qtls;
    }

    public void setQTLs(ArrayList<QTLInfo> qtl) {
        this.qtls = qtl;
    }

    public Line getLine(int index) {
        return this.viewSet.lines.get((int)index).line;
    }

    public LineInfo getLineInfo(int index) {
        return this.viewSet.lines.get(index);
    }

    public int getState(int lineIndex, int markerIndex) throws ArrayIndexOutOfBoundsException {
        return this.viewSet.lines.get(lineIndex).getState(this.chrIndex, this.markers.get((int)markerIndex).index);
    }

    public int markerCount() {
        return this.markers.size();
    }

    public int lineCount() {
        return this.viewSet.lines.size();
    }

    public double mapLength() {
        return this.map.getLength();
    }

    public Marker getMarker(int index) {
        return this.markers.get((int)index).marker;
    }

    public MarkerInfo getMarkerInfo(int index) {
        return this.markers.get(index);
    }

    public void moveMarker(int fromIndex, int toIndex) {
        if (toIndex < 0 || fromIndex < 0) {
            return;
        }
        if (toIndex >= this.markers.size() || fromIndex >= this.markers.size()) {
            return;
        }
        if (this.comparisonMarkerIndex == fromIndex) {
            this.comparisonMarkerIndex = toIndex;
        } else if (this.comparisonMarkerIndex == toIndex) {
            this.comparisonMarkerIndex = fromIndex;
        }
        MarkerInfo oldValue = this.markers.get(fromIndex);
        this.markers.set(fromIndex, this.markers.get(toIndex));
        this.markers.set(toIndex, oldValue);
    }

    public void initializeComparisons() {
        this.viewSet.initializeComparisons();
        if (this.comparisonMarkerIndex != -1) {
            this.comparisonMarker = this.getMarker(this.comparisonMarkerIndex);
        }
    }

    public void updateComparisons() {
        this.viewSet.updateComparisons();
        this.comparisonMarkerIndex = -1;
        for (int i = 0; i < this.markers.size(); ++i) {
            if (this.markers.get((int)i).marker != this.comparisonMarker) continue;
            this.comparisonMarkerIndex = i;
            break;
        }
    }

    public MarkerInfo[] getMarkersAsArray(boolean getVisible) {
        if (getVisible) {
            return this.markers.toArray(new MarkerInfo[0]);
        }
        return this.hideMarkers.toArray(new MarkerInfo[0]);
    }

    public void setMarkersFromArray(MarkerInfo[] array, boolean setVisible) {
        if (setVisible) {
            this.markers.clear();
            for (MarkerInfo mi : array) {
                this.markers.add(mi);
            }
        } else {
            this.hideMarkers.clear();
            for (MarkerInfo mi : array) {
                this.hideMarkers.add(mi);
            }
        }
    }

    public GTView createClone(GTViewSet clonedViewSet, boolean selectedMrkrsOnly) {
        GTView clone = new GTView(clonedViewSet, this.map, false);
        clone.markers.clear();
        for (MarkerInfo mi : this.markers) {
            if (selectedMrkrsOnly && (!selectedMrkrsOnly || !mi.getSelected())) continue;
            clone.markers.add(new MarkerInfo(mi));
        }
        if (!selectedMrkrsOnly) {
            for (MarkerInfo mi : this.hideMarkers) {
                clone.hideMarkers.add(new MarkerInfo(mi));
            }
        }
        ArrayList<QTLInfo> clonedQTLs = new ArrayList<QTLInfo>();
        for (QTLInfo qtl : this.qtls) {
            clonedQTLs.add(new QTLInfo(qtl));
        }
        clone.setQTLs(clonedQTLs);
        clone.comparisonMarker = this.comparisonMarker;
        clone.comparisonMarkerIndex = this.comparisonMarkerIndex;
        clone.markersOrdered = this.markersOrdered;
        return clone;
    }

    public int indexOf(Marker marker) {
        for (int i = 0; i < this.markers.size(); ++i) {
            if (this.markers.get((int)i).marker != marker) continue;
            return i;
        }
        return -1;
    }

    public boolean isMarkerSelected(int index) {
        return this.markers.get((int)index).selected;
    }

    public boolean isLineSelected(int index) {
        return this.viewSet.lines.get((int)index).selected;
    }

    public boolean toggleMarkerState(int index) {
        MarkerInfo mi;
        if (this.markers.get(index).dummyMarker()) {
            return true;
        }
        mi.selectMarkerAndLinkedMarker(!(mi = this.markers.get(index)).getSelected());
        return mi.selected;
    }

    public boolean toggleLineState(int index) {
        LineInfo mi = this.viewSet.lines.get(index);
        mi.selected = !mi.selected;
        return mi.selected;
    }

    public void setMarkerState(int index, boolean selectionState) {
        if (!this.markers.get(index).dummyMarker()) {
            this.markers.get(index).selectMarkerAndLinkedMarker(selectionState);
        }
    }

    public void setLineState(int index, boolean selectionState) {
        this.viewSet.lines.get((int)index).selected = selectionState;
    }

    public int countSelectedMarkers() {
        int count = 0;
        for (MarkerInfo mi : this.markers) {
            if (!mi.selected || mi.dummyMarker()) continue;
            ++count;
        }
        return count;
    }

    public int countSelectedLines() {
        int count = 0;
        for (LineInfo li : this.viewSet.lines) {
            if (!li.selected) continue;
            ++count;
        }
        return count;
    }

    public int hiddenMarkerCount() {
        return this.hideMarkers.size();
    }

    public void hideMarkers(boolean hideSelected) {
        this.hideMarkers.ensureCapacity(this.markers.size());
        boolean nullCount = false;
        for (int i = 0; i < this.markers.size(); ++i) {
            MarkerInfo mi = this.markers.get(i);
            if (mi.selected != hideSelected || mi.dummyMarker()) continue;
            this.hideMarkers.add(mi);
            this.markers.set(i, null);
        }
        ArrayList<MarkerInfo> markers2 = new ArrayList<MarkerInfo>(this.markers.size());
        for (int i = 0; i < this.markers.size(); ++i) {
            if (this.markers.get(i) == null) continue;
            markers2.add(this.markers.get(i));
        }
        this.markers = markers2;
        this.markers.trimToSize();
        this.hideMarkers.trimToSize();
    }

    public void hideLines(boolean hideSelected) {
        this.viewSet.hideLines.ensureCapacity(this.viewSet.lines.size());
        for (int i = 0; i < this.viewSet.lines.size(); ++i) {
            if (this.viewSet.lines.get((int)i).selected != hideSelected) continue;
            LineInfo lineInfo = this.viewSet.lines.get(i);
            lineInfo.setVisibility(LineInfo.HIDDEN);
            this.viewSet.hideLines.add(lineInfo);
            this.viewSet.lines.set(i, null);
        }
        ArrayList<LineInfo> lines = new ArrayList<LineInfo>(this.viewSet.lines.size());
        for (int i = 0; i < this.viewSet.lines.size(); ++i) {
            if (this.viewSet.lines.get(i) == null) continue;
            lines.add(this.viewSet.lines.get(i));
        }
        this.viewSet.lines.clear();
        this.viewSet.lines.addAll(lines);
        this.viewSet.lines.trimToSize();
        this.viewSet.hideLines.trimToSize();
        this.viewSet.tableHandler().copyViewToTable(false);
    }

    public void hideMarker(MarkerInfo mi) {
        this.markers.remove(mi);
        this.hideMarkers.add(mi);
    }

    public void hideLine(int index) {
        if (index < 0 || index >= this.viewSet.lines.size()) {
            return;
        }
        LineInfo lineInfo = this.viewSet.lines.remove(index);
        lineInfo.setVisibility(LineInfo.HIDDEN);
        this.viewSet.hideLines.add(lineInfo);
        this.viewSet.tableHandler().copyViewToTable(false);
    }

    public void restoreHiddenMarkers() {
        while (this.hideMarkers.size() > 0) {
            int insertAt;
            MarkerInfo mi = this.hideMarkers.remove(0);
            double position = mi.marker.getPosition();
            for (insertAt = 0; insertAt < this.markers.size() && !(this.markers.get((int)insertAt).marker.getPosition() >= position); ++insertAt) {
            }
            this.markers.add(insertAt, mi);
        }
    }

    public boolean isDummyLine(int lineInfoIndex) {
        LineInfo info = this.viewSet.lines.get(lineInfoIndex);
        return info.getLine() == this.viewSet.getDataSet().getDummyLine();
    }

    public boolean isSplitter(int lineInfoIndex) {
        LineInfo info = this.viewSet.lines.get(lineInfoIndex);
        return info.getLine() == this.viewSet.getDataSet().getSplitter();
    }

    public boolean isDuplicate(int lineInfoIndex) {
        return this.viewSet.lines.get((int)lineInfoIndex).duplicate;
    }

    public int countGenuineMarkers() {
        if (!this.map.isSpecialChromosome()) {
            return this.markerCount();
        }
        int count = 0;
        for (MarkerInfo mi : this.markers) {
            if (mi.dummyMarker()) continue;
            ++count;
        }
        return count;
    }

    public int getSplitterIndex() {
        int linecount = this.lineCount();
        for (int i = 0; i < linecount; ++i) {
            if (this.getLine(i) != this.viewSet.getDataSet().getSplitter()) continue;
            return i;
        }
        return -1;
    }

    public boolean hasDummyLines() {
        int lineCount = this.lineCount();
        for (int i = 0; i < lineCount; ++i) {
            if (this.viewSet.lines.get((int)i).line != this.viewSet.getDataSet().getDummyLine()) continue;
            return true;
        }
        return false;
    }

    void linkMarkerInfos() {
        if (!this.map.isSpecialChromosome()) {
            return;
        }
        int specialMarkerIndex = 0;
        for (GTView realView : this.viewSet.getViews()) {
            ChromosomeMap realMap = realView.map;
            if (realMap.isSpecialChromosome()) continue;
            int i = 0;
            while (i < realView.markerCount()) {
                MarkerInfo specialMarkerInfo = this.getMarkerInfo(specialMarkerIndex);
                MarkerInfo realMarkerInfo = realView.getMarkerInfo(i);
                realMarkerInfo.setLinkedMarkerInfo(specialMarkerInfo);
                specialMarkerInfo.setLinkedMarkerInfo(realMarkerInfo);
                ++i;
                ++specialMarkerIndex;
            }
            specialMarkerIndex += 5;
        }
    }
}

