/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.undo;

import jhi.flapjack.data.GTView;
import jhi.flapjack.data.IUndoState;
import jhi.flapjack.data.Marker;
import jhi.flapjack.data.MarkerInfo;

public class MovedMarkersState
implements IUndoState {
    private GTView view;
    private String menuStr;
    private MarkerInfo[] undoMarkers;
    private Marker undoComparisonMarker;
    private int undoComparisonMarkerIndex;
    private MarkerInfo[] redoMarkers;
    private Marker redoComparisonMarker;
    private int redoComparisonMarkerIndex;

    public MovedMarkersState(GTView view, String menuStr) {
        this.view = view;
        this.menuStr = menuStr;
    }

    @Override
    public String getMenuString() {
        return this.menuStr;
    }

    @Override
    public GTView getView() {
        return this.view;
    }

    @Override
    public void createUndoState() {
        this.undoMarkers = this.view.getMarkersAsArray(true);
        this.undoComparisonMarker = this.view.getComparisonMarker();
        this.undoComparisonMarkerIndex = this.view.getComparisonMarkerIndex();
    }

    @Override
    public void applyUndoState() {
        this.view.setMarkersFromArray(this.undoMarkers, true);
        this.view.setComparisonMarker(this.undoComparisonMarker);
        this.view.setComparisonMarkerIndex(this.undoComparisonMarkerIndex);
    }

    @Override
    public void createRedoState() {
        this.redoMarkers = this.view.getMarkersAsArray(true);
        this.redoComparisonMarker = this.view.getComparisonMarker();
        this.redoComparisonMarkerIndex = this.view.getComparisonMarkerIndex();
    }

    @Override
    public void applyRedoState() {
        this.view.setMarkersFromArray(this.redoMarkers, true);
        this.view.setComparisonMarker(this.redoComparisonMarker);
        this.view.setComparisonMarkerIndex(this.redoComparisonMarkerIndex);
    }
}

