/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import java.io.File;
import java.util.Locale;
import jhi.flapjack.analysis.CalculateSimilarityMatrix;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.io.FlapjackFile;
import jhi.flapjack.io.SimMatrixExporter;
import jhi.flapjack.io.cmd.CreateProject;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;

public class CreateMatrix {
    private DataSet dataSet = new DataSet();
    private File mapFile;
    private File genotypesFile;
    private boolean decimalEnglish = false;
    private String filename;

    public static void main(String[] args) {
        File mapFile = null;
        File genotypesFile = null;
        String filename = null;
        boolean decimalEnglish = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-map=")) {
                mapFile = new File(args[i].substring(5));
            }
            if (args[i].startsWith("-genotypes=")) {
                genotypesFile = new File(args[i].substring(11));
            }
            if (args[i].startsWith("-matrix=")) {
                filename = args[i].substring(8);
            }
            if (!args[i].startsWith("-decimalEnglish")) continue;
            decimalEnglish = true;
        }
        if (genotypesFile == null || filename == null) {
            System.out.println("Usage: creatematrix <options>\n where valid options are:\n   -map=<map_file>                (optional input file)\n   -genotypes=<genotypes_file>    (required input file)\n   -decimalEnglish                (optional input parameter)\n   -matrix=<matrix_file>          (required output file)\n");
            System.exit(1);
        }
        CreateMatrix cMatrix = new CreateMatrix(mapFile, genotypesFile, filename, decimalEnglish);
        cMatrix.doMatrixCreation();
        System.exit(0);
    }

    public CreateMatrix(File mapFile, File genotypesFile, String filename, boolean decimalEnglish) {
        this.mapFile = mapFile;
        this.genotypesFile = genotypesFile;
        this.filename = filename;
        this.decimalEnglish = decimalEnglish;
    }

    public void doMatrixCreation() {
        RB.initialize((String)"auto", (String)"res.text.flapjack");
        TaskDialog.setIsHeadless();
        if (this.decimalEnglish) {
            Locale.setDefault(Locale.UK);
        }
        CreateProject createProject = new CreateProject(this.mapFile, this.genotypesFile, null, null, new FlapjackFile("temp"), null, false);
        try {
            createProject.createProject();
            this.dataSet = createProject.dataSet();
            this.CreateSimMatrix();
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(1);
        }
    }

    private void CreateSimMatrix() throws Exception {
        GTViewSet viewSet = this.dataSet.getViewSets().get(0);
        GTView view = viewSet.getView(0);
        boolean[] chromosomes = new boolean[viewSet.chromosomeCount()];
        for (int i = 0; i < chromosomes.length; ++i) {
            chromosomes[i] = true;
        }
        CalculateSimilarityMatrix calculator = new CalculateSimilarityMatrix(viewSet, view, chromosomes, false);
        calculator.runJob(0);
        SimMatrixExporter exporter = new SimMatrixExporter(calculator.getMatrix(), this.filename);
        exporter.runJob(0);
    }
}

