/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.brapi;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jhi.brapi.api.markerprofiles.BrapiAlleleMatrix;
import jhi.brapi.api.markerprofiles.BrapiMarkerProfile;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.Marker;
import jhi.flapjack.data.StateTable;
import jhi.flapjack.io.IGenotypeImporter;
import jhi.flapjack.io.MarkerIndex;
import jhi.flapjack.io.brapi.BrapiClient;

public class BrapiGenotypeImporter
implements IGenotypeImporter {
    private DataSet dataSet;
    private StateTable stateTable;
    private HashMap<String, MarkerIndex> markers;
    private HashMap<String, MarkerIndex> markersByName;
    private HashMap<String, Integer> states = new HashMap();
    private String ioMissingData;
    private String ioHeteroSeparator;
    private long alleleCount;
    private boolean useByteStorage = true;
    private boolean isOK = true;
    private BrapiClient client;
    private boolean mapWasProvided;
    private boolean fakeMapCreated = false;

    public BrapiGenotypeImporter(BrapiClient client, DataSet dataSet, HashMap<String, MarkerIndex> markers, HashMap<String, MarkerIndex> markersByName, String ioMissingData, String ioHeteroSeparator) {
        this.client = client;
        this.dataSet = dataSet;
        this.markers = markers;
        this.markersByName = markersByName;
        this.ioMissingData = ioMissingData;
        this.ioHeteroSeparator = ioHeteroSeparator;
        this.ioMissingData = "N";
        this.ioHeteroSeparator = "/";
        this.stateTable = dataSet.getStateTable();
        this.mapWasProvided = markersByName.size() > 0;
    }

    @Override
    public void cleanUp() {
        this.markers.clear();
    }

    @Override
    public void cancelImport() {
        this.isOK = false;
    }

    @Override
    public long getLineCount() {
        return this.dataSet.getLines().size();
    }

    @Override
    public long getMarkerCount() {
        return this.alleleCount;
    }

    @Override
    public void importGenotypeData() throws Exception {
        if (!this.readData()) {
            this.dataSet.getLines().clear();
            this.stateTable.resetTable();
            this.states.clear();
            this.useByteStorage = false;
            this.alleleCount = 0L;
            this.readData();
        }
    }

    private boolean readData() throws Exception {
        if (this.client.hasAlleleMatrices()) {
            return this.readFlapjackAlleleMatrix(true, null);
        }
        List<BrapiMarkerProfile> profiles = this.client.getMarkerProfiles();
        HashMap<String, Line> linesByProfileID = new HashMap<String, Line>();
        if (this.client.hasAlleleMatrixSearchTSV()) {
            if (this.mapWasProvided) {
                for (BrapiMarkerProfile mp : profiles) {
                    String name = mp.getUniqueDisplayName();
                    Line line = this.dataSet.createLine(name, this.useByteStorage);
                    linesByProfileID.put(mp.getMarkerprofileDbId(), line);
                }
            }
            return this.readTSVAlleleMatrix(linesByProfileID, profiles);
        }
        if (this.client.hasAlleleMatrixSearchFlapjack()) {
            return this.readFlapjackAlleleMatrix(false, profiles);
        }
        return this.readJSONAlleleMatrix(linesByProfileID, profiles);
    }

    @Override
    public long getBytesRead() {
        return 0L;
    }

    private boolean readTSVAlleleMatrix(HashMap<String, Line> linesByProfileID, List<BrapiMarkerProfile> profiles) throws Exception {
        URI uri = this.client.getAlleleMatrixFileByProfiles(profiles, "tsv");
        BufferedReader in = new BufferedReader(new InputStreamReader(this.client.getInputStream(uri)));
        String str = in.readLine();
        String[] tmpstr = str.split("\t");
        List<String> markerprofileIds = Arrays.asList(tmpstr);
        if (!this.mapWasProvided) {
            ArrayList<String> markerNames = new ArrayList<String>();
            while ((str = in.readLine()) != null) {
                String[] tokens = str.split("\t");
                String markerID = tokens[0].trim();
                markerNames.add(markerID);
            }
            markerNames.forEach(this::queryMarker);
            for (BrapiMarkerProfile mp : profiles) {
                String name = mp.getUniqueDisplayName();
                Line line = this.dataSet.createLine(name, this.useByteStorage);
                linesByProfileID.put(mp.getMarkerprofileDbId(), line);
            }
            this.fakeMapCreated = true;
        }
        in = new BufferedReader(new InputStreamReader(this.client.getInputStream(uri)));
        str = in.readLine();
        while ((str = in.readLine()) != null && !str.isEmpty()) {
            String mpID;
            Line line;
            System.out.println(str);
            String[] tokens = str.split("\t");
            String markerID = tokens[0].trim();
            MarkerIndex index = this.queryMarker(markerID);
            for (int j = 1; j < tokens.length && (line = linesByProfileID.get(mpID = markerprofileIds.get(j))) != null && index != null; ++j) {
                String allele = tokens[j];
                Integer stateCode = this.states.computeIfAbsent(allele, a -> this.stateTable.getStateCode((String)a, true, this.ioMissingData, this.ioHeteroSeparator));
                line.setLoci(index.mapIndex, index.mkrIndex, stateCode);
                ++this.alleleCount;
            }
            if (this.useByteStorage && this.stateTable.size() > 127) {
                return false;
            }
            if (this.isOK) continue;
            break;
        }
        in.close();
        return true;
    }

    private boolean readFlapjackAlleleMatrix(boolean createLines, List<BrapiMarkerProfile> profiles) throws Exception {
        String str;
        URI uri;
        BufferedReader in = null;
        if (createLines) {
            uri = this.client.getAlleleMatrixFileById();
            in = new BufferedReader(new InputStreamReader(this.client.getInputStream(uri)));
        } else {
            uri = this.client.getAlleleMatrixFileByProfiles(profiles, "flapjack");
            in = new BufferedReader(new InputStreamReader(this.client.getInputStream(uri)));
        }
        while ((str = in.readLine()) != null && !str.isEmpty()) {
            if (str.startsWith("#")) continue;
            String[] markerNames = str.split("\t");
            int[] mapIndex = new int[markerNames.length];
            int[] mkrIndex = new int[markerNames.length];
            for (int i = 1; i < markerNames.length && this.isOK; ++i) {
                MarkerIndex index = this.queryMarker(markerNames[i].trim());
                if (index != null) {
                    mapIndex[i] = index.mapIndex;
                    mkrIndex[i] = index.mkrIndex;
                    continue;
                }
                mkrIndex[i] = -1;
                mapIndex[i] = -1;
            }
            while ((str = in.readLine()) != null && this.isOK) {
                String[] values;
                if (str.length() == 0 || (values = str.split("\t")).length == 0) continue;
                String name = values[0].trim();
                Line line = this.dataSet.createLine(name, this.useByteStorage);
                for (int i = 1; i < values.length; ++i) {
                    if (mapIndex[i] == -1) continue;
                    Integer stateCode = this.states.computeIfAbsent(values[i], a -> this.stateTable.getStateCode((String)a, true, this.ioMissingData, this.ioHeteroSeparator));
                    line.setLoci(mapIndex[i], mkrIndex[i], stateCode);
                }
                if (!this.useByteStorage || this.stateTable.size() <= 127) continue;
                return false;
            }
        }
        in.close();
        return true;
    }

    private boolean readJSONAlleleMatrix(HashMap<String, Line> linesByProfileID, List<BrapiMarkerProfile> profiles) throws Exception {
        List<BrapiAlleleMatrix> matrixList = this.client.getAlleleMatrix(profiles);
        for (int m = 0; m < matrixList.size(); ++m) {
            BrapiAlleleMatrix matrix = matrixList.get(m);
            for (int call = 0; call < matrix.getData().size(); ++call) {
                String markerDbId = matrix.markerId(call);
                String markerprofileDbId = matrix.markerProfileId(call);
                String allele = matrix.allele(call);
                Line line = linesByProfileID.get(markerprofileDbId);
                MarkerIndex index = this.markers.get(markerDbId);
                if (line == null || index == null) continue;
                Integer stateCode = this.states.computeIfAbsent(allele, a -> this.stateTable.getStateCode((String)a, true, this.ioMissingData, this.ioHeteroSeparator));
                line.setLoci(index.mapIndex, index.mkrIndex, stateCode);
                ++this.alleleCount;
                if (!this.useByteStorage || this.stateTable.size() <= 127) continue;
                return false;
            }
            if (!this.isOK) break;
        }
        return true;
    }

    private MarkerIndex queryMarker(String name) {
        if (this.mapWasProvided || this.fakeMapCreated) {
            return this.markersByName.get(name);
        }
        if (this.markersByName.get(name) != null) {
            return null;
        }
        int position = this.markersByName.size();
        Marker marker = new Marker(name, (double)position);
        ChromosomeMap map = this.dataSet.getChromosomeMaps().get(0);
        map.addMarker(marker);
        map.setLength(position);
        MarkerIndex mi = new MarkerIndex(0, this.markersByName.size());
        this.markersByName.put(marker.getName(), mi);
        return mi;
    }
}

