/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Hdf5Utils {
    public static List<String> getLines(File hdf5File) {
        IHDF5Reader reader = HDF5Factory.openForReading((File)hdf5File);
        String[] hdf5MarkersArray = reader.readStringArray("Lines");
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(hdf5MarkersArray));
        reader.close();
        return lines;
    }

    public static List<String> getMarkers(File hdf5File) {
        IHDF5Reader reader = HDF5Factory.openForReading((File)hdf5File);
        String[] hdf5MarkersArray = reader.readStringArray("Markers");
        ArrayList<String> markers = new ArrayList<String>(Arrays.asList(hdf5MarkersArray));
        reader.close();
        return markers;
    }

    public static List<String> retainLinesFrom(File hdf5File, List<String> lines) {
        List<String> hdf5Lines = Hdf5Utils.getLines(hdf5File);
        lines.retainAll(hdf5Lines);
        return lines;
    }

    public static List<String> retainMarkersFrom(File hdf5File, List<String> markers) {
        List<String> hdf5Markers = Hdf5Utils.getMarkers(hdf5File);
        markers.retainAll(hdf5Markers);
        return markers;
    }
}

