/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import scri.commons.gui.SimpleJob;

public class ChromosomeMapExporter
extends SimpleJob {
    private NumberFormat nf = NumberFormat.getInstance();
    private File file;
    private GTViewSet viewSet;
    private boolean useAll;
    private boolean[] chrm;

    public ChromosomeMapExporter(File file, GTViewSet viewSet, boolean useAll, boolean[] chrm, int total) {
        this.file = file;
        this.viewSet = viewSet;
        this.useAll = useAll;
        this.chrm = chrm;
        this.maximum = total;
    }

    public void runJob(int index) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(this.file));
        out.write("# fjFile = MAP");
        out.newLine();
        for (int c = 0; c < this.viewSet.chromosomeCount(); ++c) {
            GTView view = this.viewSet.getView(c);
            if (this.chrm != null && !this.chrm[c]) continue;
            int i = 0;
            while (i < view.markerCount() && this.okToRun) {
                if ((this.useAll || view.isMarkerSelected(i)) && !view.getMarker(i).dummyMarker()) {
                    out.write(view.getMarker(i).getName() + "\t" + view.getChromosomeMap().getName() + "\t" + this.nf.format(view.getMarker(i).getPosition()));
                    out.newLine();
                }
                ++i;
                ++this.progress;
            }
        }
        out.close();
    }
}

