/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.undo;

import java.util.ArrayList;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.IUndoState;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.gui.table.SortColumn;

public class InsertedLineState
implements IUndoState {
    private GTViewSet viewSet;
    private String menuStr;
    private ArrayList<LineInfo> undoLines;
    private ArrayList<LineInfo> redoLines;
    private ArrayList<SortColumn> undoColumns;
    private ArrayList<SortColumn> redoColumns;

    public InsertedLineState(GTViewSet viewSet, String menuStr) {
        this.viewSet = viewSet;
        this.menuStr = menuStr;
    }

    @Override
    public String getMenuString() {
        return this.menuStr;
    }

    public void setMenuString(String menuStr) {
        this.menuStr = menuStr;
    }

    @Override
    public GTView getView() {
        return null;
    }

    @Override
    public void createUndoState() {
        this.undoLines = this.viewSet.copyLines(LineInfo.VISIBLE);
        this.undoColumns = this.viewSet.tableHandler().getSortKeys();
    }

    @Override
    public void applyUndoState() {
        this.viewSet.setLinesFromCopies(this.undoLines, null, null);
        this.viewSet.tableHandler().undoRedoApplySort(this.undoColumns);
    }

    @Override
    public void createRedoState() {
        this.redoLines = this.viewSet.copyLines(LineInfo.VISIBLE);
        this.redoColumns = this.viewSet.tableHandler().getSortKeys();
    }

    @Override
    public void applyRedoState() {
        this.viewSet.setLinesFromCopies(this.redoLines, null, null);
        this.viewSet.tableHandler().undoRedoApplySort(this.redoColumns);
    }
}

