/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.IUndoState;
import jhi.flapjack.data.UndoManager;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.WinMain;
import jhi.flapjack.gui.WinMainMenuBar;
import jhi.flapjack.gui.WinMainToolBar;
import jhi.flapjack.gui.visualization.CanvasController;
import jhi.flapjack.gui.visualization.ColCanvas;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GraphCanvas;
import jhi.flapjack.gui.visualization.ListPanel;
import jhi.flapjack.gui.visualization.MapCanvas;
import jhi.flapjack.gui.visualization.MiniMapCanvas;
import jhi.flapjack.gui.visualization.OverviewManager;
import jhi.flapjack.gui.visualization.QTLCanvas;
import jhi.flapjack.gui.visualization.RowCanvas;
import jhi.flapjack.gui.visualization.StatusPanelNB;
import jhi.flapjack.gui.visualization.TraitCanvas;
import scri.commons.gui.Icons;
import scri.commons.gui.RB;
import scri.commons.gui.SystemUtils;

public class GenotypePanel
extends JPanel
implements ActionListener {
    private GTViewSet viewSet;
    private GTView view;
    GenotypeCanvas canvas;
    MapCanvas mapCanvas;
    MiniMapCanvas miniMapCanvas;
    private RowCanvas rowCanvas;
    private ColCanvas colCanvas;
    QTLCanvas qtlCanvas;
    GraphCanvas[] graphCanvas = new GraphCanvas[3];
    TraitCanvas traitCanvas;
    ListPanel listPanel;
    StatusPanelNB statusPanel;
    private CanvasController controller;
    private JScrollPane sp;
    private JSplitPane qtlSplitter;
    private JComboBox<ChromosomeMap> combo;
    private JLabel chromoLabel = new JLabel();
    private JLabel lineLabel = new JLabel();
    private JLabel markerLabel = new JLabel();
    private JLabel lengthLabel = new JLabel();

    public GenotypePanel(WinMain winMain) {
        this.createControls(winMain);
        JPanel ctrlPanel = new JPanel(new FlowLayout(0, 2, 5));
        ctrlPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ((Color)UIManager.get("Panel.background")).darker()));
        ctrlPanel.add(new JLabel(" "));
        ctrlPanel.add(this.chromoLabel);
        ctrlPanel.add(new JLabel(" "));
        ctrlPanel.add(this.combo);
        ctrlPanel.add(new JLabel(" "));
        ctrlPanel.add(this.lineLabel);
        ctrlPanel.add(this.markerLabel);
        ctrlPanel.add(this.lengthLabel);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)ctrlPanel, "North");
        topPanel.add((Component)this.miniMapCanvas, "South");
        JPanel mapPanel = new JPanel(new BorderLayout());
        mapPanel.add((Component)this.mapCanvas, "Center");
        JPanel graphPanel = new JPanel(new BorderLayout(0, 1));
        graphPanel.add((Component)this.graphCanvas[0], "North");
        graphPanel.add(this.graphCanvas[1]);
        graphPanel.add((Component)this.graphCanvas[2], "South");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)graphPanel, "North");
        bottomPanel.add((Component)this.rowCanvas, "South");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add(this.sp);
        centerPanel.add((Component)mapPanel, "North");
        centerPanel.add((Component)bottomPanel, "South");
        centerPanel.add((Component)this.colCanvas, "East");
        centerPanel.add((Component)this.traitCanvas, "West");
        this.qtlSplitter = new JSplitPane(0);
        this.qtlSplitter.setTopComponent(this.qtlCanvas);
        this.qtlSplitter.setBottomComponent(centerPanel);
        this.qtlSplitter.setContinuousLayout(true);
        this.qtlSplitter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.qtlSplitter.addPropertyChangeListener(this.qtlCanvas);
        this.setVisibleStates();
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.add(this.qtlSplitter);
        this.add((Component)this.statusPanel, "South");
    }

    private void createControls(WinMain winMain) {
        this.combo = new JComboBox();
        this.combo.setRenderer(new ComboRenderer());
        RB.setText((JLabel)this.chromoLabel, (String)"gui.visualization.GenotypePanel.chromoLabel");
        this.chromoLabel.setLabelFor(this.combo);
        this.chromoLabel.setIcon(Icons.getIcon((String)"CHROMOSOME"));
        this.canvas = new GenotypeCanvas(this, winMain);
        this.rowCanvas = new RowCanvas(this, this.canvas);
        this.colCanvas = new ColCanvas(this.canvas);
        this.mapCanvas = new MapCanvas(this, this.canvas);
        this.miniMapCanvas = new MiniMapCanvas(this, this.canvas);
        this.traitCanvas = new TraitCanvas(this, this.canvas);
        this.qtlCanvas = new QTLCanvas(this, this.canvas, this.mapCanvas);
        this.listPanel = new ListPanel(this);
        this.statusPanel = new StatusPanelNB(this);
        for (int i = 0; i < this.graphCanvas.length; ++i) {
            this.graphCanvas[i] = new GraphCanvas(this, this.canvas, i);
        }
        OverviewManager.initialize(winMain, this, this.canvas);
        this.sp = new JScrollPane();
        this.sp.setViewportView(this.canvas);
        this.sp.getViewport().setBackground(Prefs.visColorBackground);
        this.sp.setWheelScrollingEnabled(false);
        this.controller = new CanvasController(this, this.sp);
    }

    public void setViewSet(GTViewSet viewSet) {
        this.viewSet = viewSet;
        int selectedIndex = viewSet.getViewIndex();
        this.combo.removeActionListener(this);
        this.combo.removeAllItems();
        for (GTView view : viewSet.getViews()) {
            this.combo.addItem(view.getChromosomeMap());
        }
        this.combo.addActionListener(this);
        this.combo.setSelectedIndex(selectedIndex);
    }

    public GTViewSet getViewSet() {
        return this.viewSet;
    }

    public GTView getView() {
        return this.view;
    }

    public CanvasController getController() {
        return this.controller;
    }

    public void refreshView() {
        if (this.viewSet == null) {
            return;
        }
        this.view.updateComparisons();
        this.canvas.setView(this.viewSet, this.view);
        this.listPanel.setView(this.view);
        this.statusPanel.setView(this.view);
        this.traitCanvas.determineVisibility();
        for (int i = 0; i < this.graphCanvas.length; ++i) {
            this.graphCanvas[i].determineVisibility();
        }
        this.controller.computePanelSizes();
        this.setCtrlLabels();
        OverviewManager.createImage();
    }

    private void displayMap(int mapIndex) {
        this.viewSet.setViewIndex(mapIndex);
        this.view = this.viewSet.getView(mapIndex);
        this.setEditActions();
        this.refreshView();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.combo && this.combo.getSelectedIndex() != -1) {
            this.displayMap(this.combo.getSelectedIndex());
        }
    }

    void forceOverviewUpdate() {
        this.canvas.updateOverviewSelectionBox();
    }

    void canvasViewChanged(int xIndex, int xW, int yIndex, int yH) {
        OverviewManager.updateOverviewSelectionBox(xIndex, xW, yIndex, yH);
        this.rowCanvas.updateOverviewSelectionBox(xIndex, xW);
        this.colCanvas.updateOverviewSelectionBox(yIndex, yH);
        this.repaint();
    }

    void overRow(int colIndex, int rowIndex) {
        this.canvas.setHighlightedIndices(rowIndex, colIndex);
        this.listPanel.repaint();
        this.rowCanvas.setLineIndex(rowIndex);
        this.colCanvas.setMarkerIndex(colIndex);
        this.mapCanvas.setMarkerIndex(colIndex);
        this.statusPanel.setIndices(rowIndex, colIndex);
    }

    public void resetBufferedState(boolean state) {
        this.canvas.resetBufferedState(state);
    }

    public long computeCanvasBufferInBytes() {
        return (long)this.canvas.canvasW * (long)this.canvas.canvasH * 3L;
    }

    public BufferedImage getCanvasBuffer(boolean full) throws Error, Exception {
        return this.canvas.createSavableImage(full);
    }

    public BufferedImage getMapCanvasBuffer(boolean full) throws Error, Exception {
        return this.mapCanvas.createSavableImage(full);
    }

    public BufferedImage getLineCanvasBuffer(boolean full) {
        return this.listPanel.createSavableImage(full, this.canvas.pY1);
    }

    public BufferedImage getTraitCanvasBuffer(boolean full) {
        return this.traitCanvas.createSavableImage(full);
    }

    public BufferedImage getQTLCanvasBuffer(boolean full) throws Error, Exception {
        return this.qtlCanvas.createSavableImage(full);
    }

    public BufferedImage[] getGraphCanvasBuffers(boolean full) throws Error, Exception {
        BufferedImage[] images = new BufferedImage[this.graphCanvas.length];
        for (int i = 0; i < this.graphCanvas.length; ++i) {
            images[i] = this.graphCanvas[i].createSavableImage(full);
        }
        return images;
    }

    void setEditActions() {
        UndoManager manager = this.viewSet.getUndoManager();
        boolean canUndo = manager.canUndo();
        Actions.editUndo.setEnabled(canUndo);
        String undoStr = RB.getString((String)"gui.Actions.editUndo");
        if (canUndo) {
            undoStr = RB.format((String)"gui.Actions.editUndoCanUndo", (Object[])new Object[]{manager.getNextUndoString()});
        }
        WinMainMenuBar.mEditUndo.setText(undoStr);
        WinMainToolBar.editUndo.setToolTipText(undoStr);
        boolean canRedo = manager.canRedo();
        Actions.editRedo.setEnabled(canRedo);
        String redoStr = RB.getString((String)"gui.Actions.editRedo");
        if (canRedo) {
            redoStr = RB.format((String)"gui.Actions.editRedoCanRedo", (Object[])new Object[]{manager.getNextRedoString()});
        }
        WinMainMenuBar.mEditRedo.setText(redoStr);
        WinMainToolBar.editRedo.setToolTipText(redoStr);
    }

    public void processUndoRedo(boolean undo, IUndoState state) {
        state = undo ? this.viewSet.getUndoManager().processUndo(state) : this.viewSet.getUndoManager().processRedo();
        if (state.getView() != null) {
            this.returnToView(state);
        } else {
            this.refreshView();
        }
        this.setEditActions();
        Actions.projectModified();
    }

    public void addUndoState(IUndoState state) {
        this.viewSet.getUndoManager().addUndoState(state);
        this.setEditActions();
        Actions.projectModified();
    }

    private void returnToView(IUndoState state) {
        GTView returnToView = state.getView();
        int index = this.viewSet.getViews().indexOf(returnToView);
        this.viewSet.setViewIndex(index);
        this.setViewSet(this.viewSet);
    }

    public void setVisibleStates() {
        this.miniMapCanvas.setVisible(Prefs.visShowMiniMapCanvas);
        this.mapCanvas.setVisible(Prefs.visShowMapCanvas);
        this.qtlCanvas.setVisible(Prefs.visShowQTLCanvas);
        this.rowCanvas.setVisible(Prefs.visShowRowCanvas);
        this.colCanvas.setVisible(Prefs.visShowColCanvas);
        this.traitCanvas.determineVisibility();
        for (int i = 0; i < this.graphCanvas.length; ++i) {
            this.graphCanvas[i].determineVisibility();
        }
        this.statusPanel.setVisible(Prefs.visShowStatusPanel);
        if (Prefs.visShowLinePanel) {
            this.sp.setRowHeaderView(this.listPanel);
        } else {
            this.sp.setRowHeaderView(null);
        }
        if (Prefs.visShowQTLCanvas) {
            if (SystemUtils.isMacOS()) {
                this.qtlSplitter.setDividerSize(5);
            } else {
                this.qtlSplitter.setDividerSize(3);
            }
            this.qtlSplitter.setDividerLocation(Prefs.guiQTLSplitterLocation);
        } else {
            this.qtlSplitter.setDividerSize(0);
        }
    }

    private void setCtrlLabels() {
        int lineCount = this.view.lineCount();
        int mrkrCount = this.view.countGenuineMarkers();
        String length = NumberFormat.getInstance().format(this.view.getChromosomeMap().getLength());
        if (lineCount == 1) {
            this.lineLabel.setText(RB.getString((String)"gui.visualization.GenotypePanel.lineLabel1"));
        } else {
            this.lineLabel.setText(RB.format((String)"gui.visualization.GenotypePanel.lineLabel2", (Object[])new Object[]{lineCount}));
        }
        if (mrkrCount == 1) {
            this.markerLabel.setText(RB.getString((String)"gui.visualization.GenotypePanel.markerLabel1"));
        } else {
            this.markerLabel.setText(RB.format((String)"gui.visualization.GenotypePanel.markerLabel2", (Object[])new Object[]{mrkrCount}));
        }
        this.lengthLabel.setText(RB.format((String)"gui.visualization.GenotypePanel.lengthLabel", (Object[])new Object[]{length}));
    }

    public void moveToPosition(int rowIndex, int colIndex, boolean centre) {
        this.controller.moveToLater(rowIndex, colIndex, centre);
    }

    public String getStatusSummary() {
        return this.canvas.boxCountY + "x" + this.canvas.boxCountX;
    }

    class ComboRenderer
    extends DefaultListCellRenderer {
        ComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ChromosomeMap map = (ChromosomeMap)value;
            this.setText(map.getName());
            if (map.isSpecialChromosome()) {
                this.setForeground(isSelected ? Color.white : Color.blue);
            } else {
                this.setForeground(isSelected ? Color.white : Color.black);
            }
            return c;
        }
    }
}

