/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.table;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.table.CellData;
import jhi.flapjack.gui.table.FilterColumn;
import jhi.flapjack.gui.table.SortColumn;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.undo.SelectedLinesState;

public abstract class LineDataTableModel
extends AbstractTableModel {
    protected DataSet dataSet;
    protected String[] columnNames;
    protected String[] ttNames;
    protected ArrayList<LineInfo> lines;

    public void setLines(ArrayList<LineInfo> lines) {
        this.lines = lines;
    }

    public ArrayList<LineInfo> getLines() {
        return this.lines;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public String getToolTip(int col) {
        return this.ttNames != null && this.ttNames[col] != null ? this.ttNames[col] : this.columnNames[col];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return new CellData(this.lines.get(row), this.getObjectAt(row, col));
    }

    public final Class getColumnClass(int col) {
        return CellData.class;
    }

    public abstract Object getObjectAt(int var1, int var2);

    public abstract Class getObjectColumnClass(int var1);

    public Color getDisplayColor(int row, int col) {
        return null;
    }

    public SortColumn[] getSortableColumns() {
        SortColumn[] cols = new SortColumn[this.columnNames.length];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = new SortColumn(i, this.columnNames[i]);
        }
        return cols;
    }

    public FilterColumn[] getFilterableColumns() {
        ArrayList<FilterColumn> cols = new ArrayList<FilterColumn>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            Class c = this.getObjectColumnClass(i);
            if (c != Double.class && c != Float.class && c != Integer.class && c != Boolean.class) continue;
            cols.add(new FilterColumn(i, c, this.columnNames[i], 0));
        }
        return cols.toArray(new FilterColumn[0]);
    }

    void setLineStates(Boolean state, boolean visibleOnly) {
        for (LineInfo line : this.lines) {
            if (!visibleOnly || line.getVisibility() != LineInfo.VISIBLE) continue;
            if (state != null) {
                line.setSelected(state);
                continue;
            }
            line.setSelected(!line.getSelected());
        }
        this.fireTableRowsUpdated(0, this.lines.size() - 1);
        Actions.projectModified();
    }

    void selectLines(FilterColumn[] data, boolean visibleOnly) {
        block0: for (int i = 0; i < this.getRowCount(); ++i) {
            LineInfo line = (LineInfo)this.getObjectAt(i, 0);
            if (visibleOnly && line.getVisibility() != LineInfo.VISIBLE) continue;
            for (FilterColumn selectFilter : data) {
                if (selectFilter.disabled()) continue;
                Object value = this.getObjectAt(i, selectFilter.colIndex);
                if (selectFilter.matches(value)) {
                    line.setSelected(true);
                    continue;
                }
                line.setSelected(false);
                continue block0;
            }
        }
        this.fireTableDataChanged();
    }

    void clearAllFilters() {
        for (LineInfo line : this.lines) {
            if (line.getVisibility() != LineInfo.FILTERED) continue;
            line.setVisibility(LineInfo.VISIBLE);
        }
    }

    public long visAndSelCount() {
        return this.lines.stream().filter(li -> li.getVisibility() == LineInfo.VISIBLE).filter(li -> li.getSelected()).count();
    }

    public Object getObjectForLine(LineInfo lineInfo, int col) {
        int index = this.lines.indexOf(lineInfo);
        if (index == -1) {
            return null;
        }
        return this.getObjectAt(index, col);
    }

    public boolean skipExport(int col) {
        return false;
    }

    public static void selectLine(LineInfo line, boolean value) {
        GenotypePanel gPanel = Flapjack.winMain.getGenotypePanel();
        SelectedLinesState undo = new SelectedLinesState(gPanel.getView(), "selected lines");
        undo.createUndoState();
        line.setSelected(value);
        undo.createRedoState();
        gPanel.addUndoState(undo);
        Flapjack.winMain.mEdit.editMode(2);
    }
}

