/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dendrogram;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import jhi.flapjack.data.results.Dendrogram;
import jhi.flapjack.gui.TitlePanel;
import jhi.flapjack.gui.dendrogram.CanvasController;
import jhi.flapjack.gui.dendrogram.DendrogramCanvas;
import jhi.flapjack.gui.dendrogram.DendrogramPanelNB;
import jhi.flapjack.io.ProjectSerializerDB;

public class DendrogramPanel
extends JPanel
implements AncestorListener {
    private Dendrogram dendrogram;
    private DendrogramCanvas dCanvas;
    private DendrogramPanelNB nbPanel;
    private CanvasController controller;

    public DendrogramPanel(Dendrogram dendrogram) {
        this.dendrogram = dendrogram;
        this.createControls();
        this.addAncestorListener(this);
    }

    private void createControls() {
        this.dCanvas = new DendrogramCanvas(this);
        this.nbPanel = new DendrogramPanelNB(this.dendrogram, this.dCanvas);
        this.controller = new CanvasController(this, this.nbPanel.sp);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)new TitlePanel(this.dendrogram.getTitle()), "North");
        this.add(this.nbPanel);
    }

    DendrogramCanvas getDendrogramCanvas() {
        return this.dCanvas;
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        ProjectSerializerDB.setFromCache(this.dendrogram.getPng());
        ProjectSerializerDB.setFromCache(this.dendrogram.getPdf());
        try {
            byte[] data = this.dendrogram.getPng().image;
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            BufferedImage image = ImageIO.read(bis);
            this.dCanvas.setImage(image);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this.dendrogram.getPng().dbClear();
        this.dendrogram.getPdf().dbClear();
        this.dCanvas.setImage(null);
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }
}

