/*
 * Decompiled with CFR 0.152.
 */
package scri.commons.io;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    private byte[] buffer;
    private int bufPos = 0;
    private int bufEnd = 0;
    private long realPos = 0L;
    private int BUFFER_SIZE;

    public BufferedRandomAccessFile(String filename, String mode, int bufferSize) throws FileNotFoundException, IOException {
        super(filename, mode);
        this.invalidate();
        this.BUFFER_SIZE = bufferSize;
        this.buffer = new byte[this.BUFFER_SIZE];
    }

    public BufferedRandomAccessFile(File file, String mode, int bufferSize) throws FileNotFoundException, IOException {
        super(file, mode);
        this.invalidate();
        this.BUFFER_SIZE = bufferSize;
        this.buffer = new byte[this.BUFFER_SIZE];
    }

    @Override
    public int read() throws IOException {
        if (this.bufPos >= this.bufEnd) {
            this.fillBuffer();
        }
        if (this.bufEnd == 0) {
            throw new IOException();
        }
        return this.buffer[this.bufPos++];
    }

    @Override
    public int read(byte[] tempBuf) throws IOException {
        int i = 0;
        int bytes = 0;
        if (this.bufPos + tempBuf.length < this.bufEnd) {
            System.arraycopy(this.buffer, this.bufPos, tempBuf, 0, tempBuf.length);
            this.bufPos += tempBuf.length;
            return tempBuf.length;
        }
        if (this.bufPos < this.bufEnd) {
            bytes = this.bufEnd - this.bufPos;
            System.arraycopy(this.buffer, this.bufPos, tempBuf, 0, bytes);
            this.bufPos = this.bufEnd + 1;
            i = bytes;
        }
        while (i < tempBuf.length) {
            int c = this.read();
            tempBuf[i] = (byte)c;
            ++i;
        }
        return tempBuf.length;
    }

    public int readIntFromBuffer() throws IOException {
        byte[] tempBuf = new byte[4];
        if (this.read(tempBuf) < tempBuf.length) {
            throw new EOFException();
        }
        ByteBuffer buf = ByteBuffer.wrap(tempBuf);
        return buf.getInt();
    }

    public long readLongFromBuffer() throws IOException {
        byte[] tempBuf = new byte[8];
        if (this.read(tempBuf) < tempBuf.length) {
            throw new EOFException();
        }
        ByteBuffer buf = ByteBuffer.wrap(tempBuf);
        return buf.getLong();
    }

    public boolean readBooleanFromBuffer() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public short readShortFromBuffer() throws IOException {
        byte[] tempBuf = new byte[2];
        if (this.read(tempBuf) < tempBuf.length) {
            throw new EOFException();
        }
        ByteBuffer buf = ByteBuffer.wrap(tempBuf);
        return buf.getShort();
    }

    public int fillBuffer() throws IOException {
        int n = super.read(this.buffer, 0, this.BUFFER_SIZE - 1);
        if (n != 0) {
            this.realPos += (long)n;
            this.bufPos = 0;
            this.bufEnd = n;
            return n;
        }
        throw new EOFException();
    }

    public void invalidate() throws IOException {
        this.bufPos = 0;
        this.bufEnd = 0;
        this.realPos = super.getFilePointer();
    }

    @Override
    public long getFilePointer() throws IOException {
        long l = this.realPos;
        return l - (long)this.bufEnd + (long)this.bufPos;
    }

    @Override
    public void seek(long pos) throws IOException {
        int n = (int)(this.realPos - pos);
        if (n >= 0 && n <= this.bufEnd) {
            this.bufPos = this.bufEnd - n;
        } else {
            super.seek(pos);
            this.invalidate();
        }
    }
}

