/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.brapi;

import java.util.List;
import jhi.brapi.api.calls.BrapiCall;
import jhi.flapjack.gui.Prefs;

class CallsUtils {
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String JSON = "json";
    private static final String TSV = "tsv";
    private static final String FLAPJACK = "flapjack";
    String exceptionMsg = "";
    private List<BrapiCall> calls;

    CallsUtils(List<BrapiCall> calls) {
        this.calls = calls;
    }

    boolean validate() {
        if (Prefs.guiBrAPIUseStudies && !this.hasStudiesSearchGET() && !this.hasStudiesSearchPOST()) {
            this.exceptionMsg = "studies-search not implemented";
            return false;
        }
        if (Prefs.guiBrAPIUseMaps && !this.hasCall("maps", JSON, GET)) {
            this.exceptionMsg = "maps not implmented";
            return false;
        }
        if (Prefs.guiBrAPIUseMaps && !this.hasCall("maps/{id}/positions", JSON, GET)) {
            this.exceptionMsg = "maps/{id}/positions not implmented";
            return false;
        }
        if (this.hasAlleleMatrices()) {
            if (!this.hasAlleleMatrixSearchFlapjack()) {
                this.exceptionMsg = "no Flapjack format support in allelematrix-search";
                return false;
            }
            return true;
        }
        if (this.hasCall("markerprofiles", JSON, GET)) {
            return this.hasCall("allelematrix-search", JSON, POST) || this.hasAlleleMatrixSearchTSV() || this.hasAlleleMatrixSearchFlapjack();
        }
        return false;
    }

    boolean hasCall(String signature, String datatype, String method) {
        for (BrapiCall call : this.calls) {
            if (!call.getCall().equals(signature) || !call.hasDataType(datatype) || !call.hasMethod(method)) continue;
            return true;
        }
        return false;
    }

    boolean hasToken() {
        return this.hasCall("token", JSON, POST);
    }

    boolean hasMapsMapDbId() {
        return this.hasCall("maps/{id}", JSON, GET);
    }

    boolean hasAlleleMatrices() {
        return this.hasCall("allelematrices", JSON, GET);
    }

    boolean hasAlleleMatrixSearchTSV() {
        return this.hasCall("allelematrix-search", TSV, POST);
    }

    boolean hasAlleleMatrixSearchFlapjack() {
        return this.hasCall("allelematrix-search", FLAPJACK, POST);
    }

    boolean hasStudiesSearchGET() {
        return this.hasCall("studies-search", JSON, GET);
    }

    boolean hasStudiesSearchPOST() {
        return this.hasCall("studies-search", JSON, POST);
    }
}

