/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.ColorScheme;
import jhi.flapjack.gui.visualization.colors.ColorState;
import jhi.flapjack.gui.visualization.colors.HeterozygeousColorState;
import jhi.flapjack.gui.visualization.colors.HomozygousColorState;
import jhi.flapjack.gui.visualization.colors.SimpleColorState;
import scri.commons.gui.RB;

public class ParentMatchDualColorScheme
extends ColorScheme {
    protected ArrayList<ColorState> p1States = new ArrayList();
    protected ArrayList<ColorState> p2States = new ArrayList();
    protected ArrayList<ColorState> p1MatchStates = new ArrayList();
    protected ArrayList<ColorState> p2MatchStates = new ArrayList();
    protected ArrayList<ColorState> gsStates = new ArrayList();
    protected ArrayList<ColorState> noMatchStates = new ArrayList();

    public ParentMatchDualColorScheme() {
    }

    public ParentMatchDualColorScheme(GTView view, int w, int h) {
        super(view);
        Color sHz = Prefs.visColorNucleotideHZ;
        Color drk = Prefs.visParentSimilarity1;
        Color drk2 = Prefs.visParentSimilarity2;
        Color s1 = Prefs.visParentSimilarity1Match;
        Color s2 = Prefs.visParentSimilarity2Match;
        Color gsC = Prefs.visColorSimStateMissing;
        Color red = Prefs.visColorSimStateNoMatch;
        for (int i = 0; i < this.stateTable.size(); ++i) {
            ColorState comp;
            ColorState comp2;
            ColorState noMatch;
            ColorState mtchY;
            ColorState mtchN;
            ColorState gs;
            AlleleState state = this.stateTable.getAlleleState(i);
            if (state.isUnknown()) {
                mtchN = gs = new SimpleColorState(state, Prefs.visColorBackground, w, h);
                mtchY = gs;
                noMatch = gs;
                comp2 = gs;
                comp = gs;
            } else if (state.isHomozygous()) {
                comp = new HomozygousColorState(state, drk, w, h);
                comp2 = new HomozygousColorState(state, drk2, w, h);
                mtchY = new HomozygousColorState(state, s1, w, h);
                mtchN = new HomozygousColorState(state, s2, w, h);
                gs = new HomozygousColorState(state, gsC, w, h);
                noMatch = new HomozygousColorState(state, red, w, h);
            } else {
                comp = new HeterozygeousColorState(state, sHz, drk, drk, w, h);
                comp2 = new HeterozygeousColorState(state, sHz, drk2, drk2, w, h);
                mtchY = new HeterozygeousColorState(state, sHz, s1, s1, w, h);
                mtchN = new HeterozygeousColorState(state, sHz, s2, s2, w, h);
                gs = new HeterozygeousColorState(state, sHz, gsC, gsC, w, h);
                noMatch = new HeterozygeousColorState(state, sHz, red, red, w, h);
            }
            this.p1States.add(comp);
            this.p2States.add(comp2);
            this.p1MatchStates.add(mtchY);
            this.p2MatchStates.add(mtchN);
            this.gsStates.add(gs);
            this.noMatchStates.add(noMatch);
        }
    }

    @Override
    public void setColorSummaries(ArrayList<ColorScheme.ColorSummary> colors) {
        Prefs.visParentSimilarity1 = colors.get((int)0).color;
        Prefs.visParentSimilarity2 = colors.get((int)1).color;
        Prefs.visParentSimilarity1Match = colors.get((int)2).color;
        Prefs.visParentSimilarity2Match = colors.get((int)3).color;
        Prefs.visColorSimStateMissing = colors.get((int)4).color;
        Prefs.visColorSimStateNoMatch = colors.get((int)5).color;
    }

    protected ColorState getState(int line, int marker) {
        int p1 = this.view.getViewSet().getComparisonLineIndex();
        int p2 = this.view.getViewSet().getComparisonLineIndex2();
        int state = this.view.getState(line, marker);
        AlleleState childState = this.stateTable.getAlleleState(state);
        if (p1 != -1 && p2 != -1) {
            int p1State = this.view.getState(p1, marker);
            int p2State = this.view.getState(p2, marker);
            AlleleState p1AlleleState = this.stateTable.getAlleleState(p1State);
            AlleleState p2AlleleState = this.stateTable.getAlleleState(p2State);
            if (line == p1) {
                return this.parentStatesAmbiguous(p1State, p2State) ? this.gsStates.get(state) : this.p1States.get(state);
            }
            if (line == p2) {
                return this.parentStatesAmbiguous(p1State, p2State) ? this.gsStates.get(state) : this.p2States.get(state);
            }
            if (!childState.allelesContainedInParents(p1AlleleState, p2AlleleState) && p1State != 0 && p2State != 0) {
                return this.noMatchStates.get(state);
            }
            if (this.parentStatesAmbiguous(p1State, p2State)) {
                return this.gsStates.get(state);
            }
            if (state == p1State) {
                return this.p1MatchStates.get(state);
            }
            if (state == p2State) {
                return this.p2MatchStates.get(state);
            }
        }
        return this.gsStates.get(state);
    }

    private boolean parentStatesAmbiguous(int p1, int p2) {
        return p1 == p2 || p1 == 0 || p2 == 0 || this.stateTable.isHet(p1) || this.stateTable.isHet(p2);
    }

    @Override
    public BufferedImage getSelectedImage(int line, int marker, boolean underQTL) {
        return this.getState(line, marker).getImage(underQTL);
    }

    @Override
    public BufferedImage getUnselectedImage(int line, int marker, boolean underQTL) {
        return this.getState(line, marker).getUnselectedImage(underQTL);
    }

    @Override
    public Color getColor(int line, int marker) {
        return this.getState(line, marker).getColor();
    }

    @Override
    public int getModel() {
        return 13;
    }

    @Override
    public String getDescription() {
        return RB.getString((String)"gui.visualization.colors.ParentDualColorScheme");
    }

    public String toString() {
        return RB.getString((String)"gui.Actions.vizColorParentDual");
    }

    @Override
    public ArrayList<ColorScheme.ColorSummary> getColorSummaries() {
        ArrayList<ColorScheme.ColorSummary> colors = new ArrayList<ColorScheme.ColorSummary>();
        colors.add(new ColorScheme.ColorSummary(Prefs.visParentSimilarity1, RB.getString((String)"gui.visualization.colors.ParentMatchDualColorScheme.parent1")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visParentSimilarity2, RB.getString((String)"gui.visualization.colors.ParentMatchDualColorScheme.parent2")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visParentSimilarity1Match, RB.getString((String)"gui.visualization.colors.ParentMatchDualColorScheme.state1")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visParentSimilarity2Match, RB.getString((String)"gui.visualization.colors.ParentMatchDualColorScheme.state2")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimStateMissing, RB.getString((String)"gui.visualization.colors.ParentMatchDualColorScheme.state3")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimStateNoMatch, RB.getString((String)"gui.visualization.colors.ParentMatchDualColorScheme.state4")));
        return colors;
    }
}

