/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui;

import java.awt.Frame;
import java.io.File;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import jhi.flapjack.analysis.ExternalSelection;
import jhi.flapjack.analysis.FilterHeterozygousMarkers;
import jhi.flapjack.analysis.FilterHeterozygousMarkersByLine;
import jhi.flapjack.analysis.FilterMissingMarkers;
import jhi.flapjack.analysis.FilterMissingMarkersByLine;
import jhi.flapjack.analysis.FilterMonomorphicMarkers;
import jhi.flapjack.analysis.SelectMonomorphicMarkers;
import jhi.flapjack.analysis.ViewSetAnalyses;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.MarkerInfo;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.dialog.BrowseDialog;
import jhi.flapjack.gui.dialog.HeterozygousMarkersDialog;
import jhi.flapjack.gui.dialog.HideLMDialog;
import jhi.flapjack.gui.dialog.MissingMarkersDialog;
import jhi.flapjack.gui.dialog.analysis.FilterMarkersByLineDialog;
import jhi.flapjack.gui.dialog.analysis.FilterMonomorphicMarkersDialog;
import jhi.flapjack.gui.dialog.analysis.SelectMonomorphicMarkersDialog;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.undo.HidLinesState;
import jhi.flapjack.gui.visualization.undo.HidMarkersState;
import jhi.flapjack.gui.visualization.undo.InsertedLineState;
import jhi.flapjack.gui.visualization.undo.SelectedLinesState;
import jhi.flapjack.gui.visualization.undo.SelectedMarkersState;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.ProgressDialog;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;

public class MenuEdit {
    private GenotypePanel gPanel;

    void setComponents(GenotypePanel gPanel) {
        this.gPanel = gPanel;
    }

    void editUndoRedo(boolean undo) {
        this.gPanel.processUndoRedo(undo, null);
        Flapjack.winMain.repaint();
    }

    public void editMode(int newMode) {
        JCheckBox checkbox;
        boolean wasInMarkerMode = Prefs.guiMouseMode == 1;
        boolean wasInLineMode = Prefs.guiMouseMode == 2;
        Prefs.guiMouseMode = newMode;
        Actions.editModeNavigation.putValue("SwingSelectedKey", Prefs.guiMouseMode == 0);
        Actions.editModeMarker.putValue("SwingSelectedKey", Prefs.guiMouseMode == 1);
        Actions.editModeLine.putValue("SwingSelectedKey", Prefs.guiMouseMode == 2);
        this.gPanel.resetBufferedState(true);
        if (Prefs.warnEditMarkerMode && !wasInMarkerMode && newMode == 1) {
            checkbox = new JCheckBox();
            RB.setText((AbstractButton)checkbox, (String)"gui.MenuEdit.warnEditMarkerMode");
            TaskDialog.info((String)RB.getString((String)"gui.MenuEdit.editMarkerMode"), (String)RB.getString((String)"gui.text.close"), (JCheckBox)checkbox);
            boolean bl = Prefs.warnEditMarkerMode = !checkbox.isSelected();
        }
        if (Prefs.warnEditLineMode && !wasInLineMode && newMode == 2) {
            checkbox = new JCheckBox();
            RB.setText((AbstractButton)checkbox, (String)"gui.MenuEdit.warnEditLineMode");
            TaskDialog.info((String)RB.getString((String)"gui.MenuEdit.editLineMode"), (String)RB.getString((String)"gui.text.close"), (JCheckBox)checkbox);
            Prefs.warnEditLineMode = !checkbox.isSelected();
        }
    }

    void editSelectMarkers(int selectionType) {
        GTView view = this.gPanel.getView();
        SelectedMarkersState state = new SelectedMarkersState(view);
        state.createUndoState();
        if (selectionType == 0) {
            state.setMenuString(RB.getString((String)"gui.visualization.SelectedMarkersState.selectedAll"));
            for (int i = 0; i < view.markerCount(); ++i) {
                view.setMarkerState(i, true);
            }
        } else if (selectionType == 1) {
            state.setMenuString(RB.getString((String)"gui.visualization.SelectedMarkersState.selectedNone"));
            for (int i = 0; i < view.markerCount(); ++i) {
                view.setMarkerState(i, false);
            }
        } else if (selectionType == 2) {
            state.setMenuString(RB.getString((String)"gui.visualization.SelectedMarkersState.selectedInvert"));
            for (int i = 0; i < view.markerCount(); ++i) {
                view.toggleMarkerState(i);
            }
        } else if (selectionType == 3) {
            state.setMenuString(RB.getString((String)"gui.visualization.SelectedMarkersState.selectedImport"));
            if (!this.loadMarkerSelectionFromFile(view)) {
                return;
            }
        } else if (selectionType == 4) {
            state.setMenuString(RB.getString((String)"gui.visualization.SelectedMarkersState.selectedMonomorphic"));
            if (!this.selectMonomorphicMarkers()) {
                return;
            }
        }
        state.createRedoState();
        this.gPanel.addUndoState(state);
        this.editMode(1);
    }

    private boolean selectMonomorphicMarkers() {
        GTViewSet viewSet = this.gPanel.getViewSet();
        SelectMonomorphicMarkersDialog sDialog = new SelectMonomorphicMarkersDialog(viewSet);
        if (!sDialog.isOK()) {
            return false;
        }
        SelectMonomorphicMarkers smm = new SelectMonomorphicMarkers(viewSet, sDialog.getSelectedChromosomes());
        ProgressDialog dialog = new ProgressDialog((ITrackableJob)smm, RB.getString((String)"gui.MenuEdit.smono.title"), RB.getString((String)"gui.MenuEdit.smono.label"), (Frame)Flapjack.winMain);
        if (dialog.getResult() != 0) {
            return false;
        }
        TaskDialog.info((String)RB.format((String)"gui.MenuEdit.smono.summary", (Object[])new Object[]{smm.getCount()}), (String)RB.getString((String)"gui.text.close"));
        return true;
    }

    private boolean loadMarkerSelectionFromFile(GTView view) {
        String rbTitle = "gui.MenuEdit.externalMarkerSelection.title";
        String rbLabel = "gui.MenuEdit.externalMarkerSelection.label";
        String rbButton = "gui.MenuEdit.externalMarkerSelection.button";
        String help = "_-_Selecting_Lines/Markers";
        BrowseDialog browseDialog = new BrowseDialog(Prefs.guiExternalMarkerSelectionHistory, rbTitle, rbLabel, rbButton, help);
        if (browseDialog.isOK()) {
            File file = browseDialog.getFile();
            Prefs.guiExternalMarkerSelectionHistory = browseDialog.getHistory();
            ExternalSelection selectMarkers = new ExternalSelection(file);
            ProgressDialog dialog = new ProgressDialog((ITrackableJob)selectMarkers, RB.getString((String)"gui.MenuEdit.markerSelection.title"), RB.getString((String)"gui.MenuEdit.markerSelection.label"), (Frame)Flapjack.winMain);
            if (dialog.getResult() == 0) {
                HashSet<MarkerInfo> selectedMarkers = new HashSet<MarkerInfo>();
                for (MarkerInfo info : view.getMarkers()) {
                    for (String name : selectMarkers.selectionStrings()) {
                        if (!info.getMarker().getName().equals(name)) continue;
                        selectedMarkers.add(info);
                    }
                }
                for (int i = 0; i < view.markerCount(); ++i) {
                    view.setMarkerState(i, selectedMarkers.contains(view.getMarkerInfo(i)));
                }
                TaskDialog.info((String)RB.format((String)"gui.MenuEdit.markerSelectionSummary", (Object[])new Object[]{selectedMarkers.size(), selectMarkers.selectionStrings().size()}), (String)RB.getString((String)"gui.text.close"));
                return true;
            }
            if (dialog.failed("gui.error")) {
                return false;
            }
        }
        return false;
    }

    void editHideMarkers() {
        HideLMDialog dialog = new HideLMDialog(this.gPanel, true);
        if (dialog.isOK()) {
            HidMarkersState state = new HidMarkersState(this.gPanel.getView(), RB.getString((String)"gui.visualization.HidMarkersState.hidMarkers"));
            state.createUndoState();
            this.gPanel.getView().hideMarkers(Prefs.guiHideSelectedMarkers);
            this.gPanel.refreshView();
            state.createRedoState();
            this.gPanel.addUndoState(state);
            this.editMode(1);
        }
    }

    void editSelectLines(int selectionType) {
        GTView view = this.gPanel.getView();
        SelectedLinesState state = new SelectedLinesState(view);
        state.createUndoState();
        if (selectionType == 0) {
            state.setMenuString(RB.getString((String)"gui.visualization.SelectedLinesState.selectedAll"));
            for (int i = 0; i < view.lineCount(); ++i) {
                view.setLineState(i, true);
            }
        } else if (selectionType == 1) {
            state.setMenuString(RB.getString((String)"gui.visualization.SelectedLinesState.selectedNone"));
            for (int i = 0; i < view.lineCount(); ++i) {
                view.setLineState(i, false);
            }
        } else if (selectionType == 2) {
            state.setMenuString(RB.getString((String)"gui.visualization.SelectedLinesState.selectedInvert"));
            for (int i = 0; i < view.lineCount(); ++i) {
                view.toggleLineState(i);
            }
        } else if (selectionType == 3) {
            state.setMenuString(RB.getString((String)"gui.visualization.SelectedLinesState.selectedImport"));
            if (!this.loadLineSelectionFromFile(state, view)) {
                return;
            }
        }
        state.createRedoState();
        this.gPanel.addUndoState(state);
        this.editMode(2);
    }

    private boolean loadLineSelectionFromFile(SelectedLinesState state, GTView view) {
        String rbTitle = "gui.MenuEdit.externalLineSelection.title";
        String rbLabel = "gui.MenuEdit.externalLineSelection.label";
        String rbButton = "gui.MenuEdit.externalLineSelection.button";
        String help = "_-_Selecting_Lines/Markers";
        BrowseDialog browseDialog = new BrowseDialog(Prefs.guiExternalLineSelectionHistory, rbTitle, rbLabel, rbButton, help);
        if (browseDialog.isOK()) {
            File file = browseDialog.getFile();
            Prefs.guiExternalLineSelectionHistory = browseDialog.getHistory();
            ExternalSelection selectLines = new ExternalSelection(file);
            ProgressDialog dialog = new ProgressDialog((ITrackableJob)selectLines, RB.getString((String)"gui.MenuEdit.lineSelection.title"), RB.getString((String)"gui.MenuEdit.lineSelection.label"), (Frame)Flapjack.winMain);
            if (dialog.getResult() == 0) {
                HashSet<LineInfo> selectedLines = new HashSet<LineInfo>();
                for (LineInfo info : view.getViewSet().getLines()) {
                    for (String name : selectLines.selectionStrings()) {
                        if (!info.getLine().getName().equals(name)) continue;
                        selectedLines.add(info);
                    }
                }
                for (int i = 0; i < view.lineCount(); ++i) {
                    view.setLineState(i, selectedLines.contains(view.getLineInfo(i)));
                }
                TaskDialog.info((String)RB.format((String)"gui.MenuEdit.lineSelectionSummary", (Object[])new Object[]{selectedLines.size(), selectLines.selectionStrings().size()}), (String)RB.getString((String)"gui.text.ok"));
                return true;
            }
            if (dialog.getResult() == 2) {
                TaskDialog.error((String)RB.format((String)"gui.MenuEdit.externalLineSelection.error", (Object[])new Object[]{dialog.getException()}), (String)RB.getString((String)"gui.text.close"));
            }
            return false;
        }
        return false;
    }

    void editHideLines() {
        HideLMDialog dialog = new HideLMDialog(this.gPanel, false);
        if (dialog.isOK()) {
            HidLinesState state = new HidLinesState(this.gPanel.getViewSet(), RB.getString((String)"gui.visualization.HidLinesState.hidLines"));
            state.createUndoState();
            this.gPanel.getView().hideLines(Prefs.guiHideSelectedLines);
            this.gPanel.refreshView();
            state.createRedoState();
            this.gPanel.addUndoState(state);
            this.editMode(2);
        }
    }

    void editInsertLine() {
        GTViewSet viewSet = this.gPanel.getViewSet();
        GTView view = this.gPanel.getView();
        if (view.mouseOverLine >= 0 && view.mouseOverLine < view.lineCount()) {
            InsertedLineState state = new InsertedLineState(viewSet, RB.getString((String)"gui.visualization.InsertedLineState.insert"));
            state.createUndoState();
            viewSet.insertDummyLine(view.mouseOverLine);
            state.createRedoState();
            this.gPanel.addUndoState(state);
            this.gPanel.refreshView();
            this.editMode(2);
        }
    }

    void editDeleteLine() {
        String[] options;
        GTViewSet viewSet = this.gPanel.getViewSet();
        GTView view = this.gPanel.getView();
        int index = view.mouseOverLine;
        boolean allowSingleDelete = false;
        if (index >= 0 && index < view.lineCount() && view.isDummyLine(index)) {
            allowSingleDelete = true;
        }
        boolean[] states = new boolean[]{allowSingleDelete, true, true};
        String msg = RB.getString((String)"gui.MenuEdit.deleteLineMsg");
        int response = TaskDialog.show((String)msg, (int)3, (int)0, (String[])(options = new String[]{RB.getString((String)"gui.MenuEdit.deleteLine"), RB.getString((String)"gui.MenuEdit.deleteAll"), RB.getString((String)"gui.text.cancel")}), (boolean[])states);
        if (response == -1 || response == 2) {
            return;
        }
        InsertedLineState state = new InsertedLineState(viewSet, RB.getString((String)"gui.visualization.InsertedLineState.remove"));
        state.createUndoState();
        if (response == 0) {
            viewSet.getLines().remove(index);
        } else {
            viewSet.removeAllDummyLines();
        }
        state.createRedoState();
        this.gPanel.addUndoState(state);
        this.gPanel.refreshView();
        this.editMode(2);
    }

    void editDuplicateLine() {
        GTViewSet viewSet = this.gPanel.getViewSet();
        GTView view = this.gPanel.getView();
        if (view.mouseOverLine >= 0 && view.mouseOverLine < view.lineCount()) {
            InsertedLineState state = new InsertedLineState(viewSet, RB.getString((String)"gui.visualization.InsertedLineState.duplicate"));
            state.createUndoState();
            viewSet.duplicateLine(view.mouseOverLine);
            state.createRedoState();
            this.gPanel.addUndoState(state);
            this.gPanel.refreshView();
            this.editMode(2);
        }
    }

    void editDuplicateLineRemove() {
        String[] options;
        GTViewSet viewSet = this.gPanel.getViewSet();
        GTView view = this.gPanel.getView();
        int index = view.mouseOverLine;
        boolean allowSingleDelete = false;
        if (index >= 0 && index < view.lineCount() && view.isDuplicate(index)) {
            allowSingleDelete = true;
        }
        boolean[] states = new boolean[]{allowSingleDelete, true, true};
        String msg = RB.getString((String)"gui.MenuEdit.deleteDuplicateMsg");
        int response = TaskDialog.show((String)msg, (int)3, (int)0, (String[])(options = new String[]{RB.getString((String)"gui.MenuEdit.deleteLine"), RB.getString((String)"gui.MenuEdit.deleteAllDuplicates"), RB.getString((String)"gui.text.cancel")}), (boolean[])states);
        if (response == -1 || response == 2) {
            return;
        }
        InsertedLineState state = new InsertedLineState(viewSet, RB.getString((String)"gui.visualization.InsertedLineState.removeDuplicate"));
        state.createUndoState();
        if (response == 0) {
            viewSet.getLines().remove(index);
        } else {
            viewSet.removeAllDuplicates();
        }
        state.createRedoState();
        this.gPanel.addUndoState(state);
        this.gPanel.refreshView();
        this.editMode(2);
    }

    void editInsertSplitter() {
        GTViewSet viewSet = this.gPanel.getViewSet();
        GTView view = this.gPanel.getView();
        if (view.getSplitterIndex() != -1) {
            return;
        }
        if (view.mouseOverLine >= 0 && view.mouseOverLine < view.lineCount()) {
            InsertedLineState state = new InsertedLineState(viewSet, RB.getString((String)"gui.visualization.InsertedSplitterState.insert"));
            state.createUndoState();
            viewSet.insertSplitterLine(view.mouseOverLine);
            state.createRedoState();
            this.gPanel.addUndoState(state);
            this.gPanel.refreshView();
            this.editMode(2);
        }
    }

    void editDeleteSplitter() {
        GTViewSet viewSet = this.gPanel.getViewSet();
        int response = TaskDialog.show((String)RB.getString((String)"gui.MenuEdit.removeSplitter"), (int)1, (int)0, (String[])new String[]{RB.getString((String)"gui.text.ok"), RB.getString((String)"gui.text.cancel")});
        InsertedLineState state = new InsertedLineState(viewSet, RB.getString((String)"gui.visualization.InsertedSplitterState.remove"));
        state.createUndoState();
        if (response == 0) {
            viewSet.removeSortSplitter();
        }
        state.createRedoState();
        this.gPanel.addUndoState(state);
        this.gPanel.refreshView();
        this.editMode(2);
    }

    void editFilterMissingMarkers() {
        GTViewSet viewSet = this.gPanel.getViewSet();
        MissingMarkersDialog mmDialog = new MissingMarkersDialog(viewSet);
        if (mmDialog.isOK()) {
            HidMarkersState state = new HidMarkersState(this.gPanel.getView(), RB.getString((String)"gui.visualization.HidMarkersState.hidMarkers"));
            state.createUndoState();
            FilterMissingMarkers fmm = new FilterMissingMarkers(this.gPanel.getViewSet(), mmDialog.getSelectedChromosomes(), Prefs.guiMissingMarkerPcnt);
            ProgressDialog dialog = new ProgressDialog((ITrackableJob)fmm, RB.getString((String)"gui.MenuEdit.fmm.title"), RB.getString((String)"gui.MenuEdit.fmm.label"), (Frame)Flapjack.winMain);
            if (dialog.getResult() != 0) {
                this.gPanel.processUndoRedo(true, state);
                return;
            }
            this.gPanel.refreshView();
            state.createRedoState();
            this.gPanel.addUndoState(state);
            TaskDialog.info((String)RB.format((String)"gui.MenuEdit.fmm.summary", (Object[])new Object[]{Prefs.guiMissingMarkerPcnt, fmm.getCount()}), (String)RB.getString((String)"gui.text.close"));
            this.editMode(1);
        }
    }

    void editFilterMissingMarkersByLine() {
        GTViewSet viewSet = this.gPanel.getViewSet();
        FilterMarkersByLineDialog mDialog = new FilterMarkersByLineDialog(this.gPanel, viewSet, RB.getString((String)"gui.dialog.analysis.FilterMissingMarkersByLineDialog.title"), RB.getString((String)"gui.dialog.analysis.FilterMissingMarkerByLineDialog.label"));
        if (mDialog.isOK()) {
            HidMarkersState state = new HidMarkersState(this.gPanel.getView(), RB.getString((String)"gui.visualization.HidMarkersState.hidMarkers"));
            state.createUndoState();
            FilterMissingMarkersByLine fmm = new FilterMissingMarkersByLine(this.gPanel.getViewSet(), mDialog.getSelectedChromosomes(), mDialog.getSelectedLine());
            ProgressDialog dialog = new ProgressDialog((ITrackableJob)fmm, RB.getString((String)"gui.MenuEdit.fmm.title"), RB.getString((String)"gui.MenuEdit.fmm.label"), (Frame)Flapjack.winMain);
            if (dialog.getResult() != 0) {
                this.gPanel.processUndoRedo(true, state);
                return;
            }
            this.gPanel.refreshView();
            state.createRedoState();
            this.gPanel.addUndoState(state);
            TaskDialog.info((String)RB.format((String)"gui.MenuEdit.fmmByLine.summary", (Object[])new Object[]{fmm.getCount()}), (String)RB.getString((String)"gui.text.close"));
            this.editMode(1);
        }
    }

    void editFilterHeterozygousMarkers() {
        GTViewSet viewSet = this.gPanel.getViewSet();
        HeterozygousMarkersDialog mmDialog = new HeterozygousMarkersDialog(viewSet);
        if (mmDialog.isOK()) {
            HidMarkersState state = new HidMarkersState(this.gPanel.getView(), RB.getString((String)"gui.visualization.HidMarkersState.hidMarkers"));
            state.createUndoState();
            FilterHeterozygousMarkers fhm = new FilterHeterozygousMarkers(this.gPanel.getViewSet(), mmDialog.getSelectedChromosomes(), Prefs.guiHeterozygousMarkerPcnt);
            ProgressDialog dialog = new ProgressDialog((ITrackableJob)fhm, RB.getString((String)"gui.MenuEdit.fhm.title"), RB.getString((String)"gui.MenuEdit.fhm.label"), (Frame)Flapjack.winMain);
            if (dialog.getResult() != 0) {
                this.gPanel.processUndoRedo(true, state);
                return;
            }
            this.gPanel.refreshView();
            state.createRedoState();
            this.gPanel.addUndoState(state);
            TaskDialog.info((String)RB.format((String)"gui.MenuEdit.fhm.summary", (Object[])new Object[]{Prefs.guiHeterozygousMarkerPcnt, fhm.getCount()}), (String)RB.getString((String)"gui.text.close"));
            this.editMode(1);
        }
    }

    void editFilterHeterozygousMarkersByLine() {
        GTViewSet viewSet = this.gPanel.getViewSet();
        FilterMarkersByLineDialog mDialog = new FilterMarkersByLineDialog(this.gPanel, viewSet, RB.getString((String)"gui.dialog.analysis.FilterHeterozygousMarkersByLineDialog.title"), RB.getString((String)"gui.dialog.analysis.FilterHeterozygousMarkersByLineDialog.label"));
        if (mDialog.isOK()) {
            HidMarkersState state = new HidMarkersState(this.gPanel.getView(), RB.getString((String)"gui.visualization.HidMarkersState.hidMarkers"));
            state.createUndoState();
            FilterHeterozygousMarkersByLine fmm = new FilterHeterozygousMarkersByLine(this.gPanel.getViewSet(), mDialog.getSelectedChromosomes(), mDialog.getSelectedLine());
            ProgressDialog dialog = new ProgressDialog((ITrackableJob)fmm, RB.getString((String)"gui.MenuEdit.fhmbl.title"), RB.getString((String)"gui.MenuEdit.fhmbl.label"), (Frame)Flapjack.winMain);
            if (dialog.getResult() != 0) {
                this.gPanel.processUndoRedo(true, state);
                return;
            }
            this.gPanel.refreshView();
            state.createRedoState();
            this.gPanel.addUndoState(state);
            TaskDialog.info((String)RB.format((String)"gui.MenuEdit.fhmbl.summary", (Object[])new Object[]{fmm.getCount()}), (String)RB.getString((String)"gui.text.close"));
            this.editMode(1);
        }
    }

    void editFilterMonomorphicMarkers() {
        GTViewSet viewSet = this.gPanel.getViewSet();
        FilterMonomorphicMarkersDialog mDialog = new FilterMonomorphicMarkersDialog(viewSet);
        if (mDialog.isOK()) {
            HidMarkersState state = new HidMarkersState(this.gPanel.getView(), RB.getString((String)"gui.visualization.HidMarkersState.hidMarkers"));
            state.createUndoState();
            FilterMonomorphicMarkers fmm = new FilterMonomorphicMarkers(viewSet, mDialog.getSelectedChromosomes());
            ProgressDialog dialog = new ProgressDialog((ITrackableJob)fmm, RB.getString((String)"gui.MenuEdit.fmono.title"), RB.getString((String)"gui.MenuEdit.fmono.label"), (Frame)Flapjack.winMain);
            if (dialog.getResult() != 0) {
                this.gPanel.processUndoRedo(true, state);
                return;
            }
            this.gPanel.refreshView();
            state.createRedoState();
            this.gPanel.addUndoState(state);
            TaskDialog.info((String)RB.format((String)"gui.MenuEdit.fmono.summary", (Object[])new Object[]{fmm.getCount()}), (String)RB.getString((String)"gui.text.close"));
            this.editMode(1);
        }
    }

    void editCustomMap() {
        GTView view = this.gPanel.getView();
        if (view.getChromosomeMap().isSpecialChromosome()) {
            TaskDialog.info((String)RB.getString((String)"gui.MenuEdit.editCustomMapSpecial"), (String)RB.getString((String)"gui.text.close"));
            return;
        }
        int response = 0;
        if (Prefs.warnEditCustomMap) {
            JCheckBox checkbox = new JCheckBox();
            RB.setText((AbstractButton)checkbox, (String)"gui.MenuEdit.warnEditCustomMap");
            response = TaskDialog.show((String)RB.getString((String)"gui.MenuEdit.editCustomMap"), (int)1, (int)0, (JCheckBox)checkbox, (String[])new String[]{RB.getString((String)"gui.text.ok"), RB.getString((String)"gui.text.cancel")});
            boolean bl = Prefs.warnEditCustomMap = !checkbox.isSelected();
        }
        if (response == 0) {
            ViewSetAnalyses.createCustomMap(view);
            this.gPanel.refreshView();
            Flapjack.winMain.mView.viewGenotypesOrChromosomes(true);
            Actions.projectModified();
        }
    }
}

