/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;

public class DatabaseOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    private static final int CHUNKSIZE = 0xF00000;
    private PreparedStatement ps;
    private int blobColumn;

    public DatabaseOutputStream(PreparedStatement ps, int blobColumn) {
        this.ps = ps;
        this.blobColumn = blobColumn;
        this.buf = new byte[0xF00000];
    }

    @Override
    public void flush() throws IOException {
        if (this.count == 0) {
            return;
        }
        try {
            if (this.count < this.buf.length) {
                this.ps.setBytes(this.blobColumn, Arrays.copyOf(this.buf, this.count));
            } else {
                this.ps.setBytes(this.blobColumn, this.buf);
            }
            this.ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
        this.count = 0;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flush();
        }
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            if (len <= this.buf.length - this.count) {
                System.arraycopy(b, off, this.buf, this.count, len);
                this.count += len;
                len = 0;
                continue;
            }
            int bytes = this.buf.length - this.count;
            System.arraycopy(b, off, this.buf, this.count, bytes);
            this.count += bytes;
            off += bytes;
            len -= bytes;
            this.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }
}

