/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.ColorScheme;
import jhi.flapjack.gui.visualization.colors.ColorState;
import jhi.flapjack.gui.visualization.colors.HeterozygeousColorState;
import jhi.flapjack.gui.visualization.colors.HomozygousColorState;
import jhi.flapjack.gui.visualization.colors.SimpleColorState;
import scri.commons.gui.RB;

public class MagicColorScheme
extends ColorScheme {
    protected ArrayList<ColorState> states = new ArrayList();
    private String[] colorIds = new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};
    private Color[] colors = new Color[]{Prefs.visColorMagic1, Prefs.visColorMagic2, Prefs.visColorMagic3, Prefs.visColorMagic4, Prefs.visColorMagic5, Prefs.visColorMagic6, Prefs.visColorMagic7, Prefs.visColorMagic8};

    public MagicColorScheme() {
    }

    public MagicColorScheme(GTView view, int w, int h) {
        super(view);
        for (int i = 0; i < this.stateTable.size(); ++i) {
            int j;
            AlleleState state = this.stateTable.getAlleleState(i);
            ColorState c = null;
            if (state.isUnknown()) {
                c = new SimpleColorState(state, Prefs.visColorBackground, w, h);
            } else if (state.isHomozygous()) {
                for (j = 0; j < this.colorIds.length; ++j) {
                    if (state.homzAllele().equals(this.colorIds[j])) {
                        c = new HomozygousColorState(state, this.colors[j], w, h);
                        break;
                    }
                    c = new HomozygousColorState(state, Prefs.visColorNucleotideOther, w, h);
                }
            } else {
                c = new HeterozygeousColorState(state, Prefs.visColorNucleotideOther, Prefs.visColorNucleotideOther, Prefs.visColorNucleotideOther, w, h);
                for (j = 0; j < this.colorIds.length; ++j) {
                    for (int k = 0; k < this.colorIds.length; ++k) {
                        if (!state.getState(0).equals(this.colorIds[j]) || !state.getState(1).equals(this.colorIds[k])) continue;
                        c = new HeterozygeousColorState(state, Prefs.visColorNucleotideHZ, this.colors[j], this.colors[k], w, h);
                    }
                }
            }
            this.states.add(c);
        }
    }

    @Override
    public BufferedImage getSelectedImage(int line, int marker, boolean underQTL) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getImage(underQTL);
    }

    @Override
    public BufferedImage getUnselectedImage(int line, int marker, boolean underQTL) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getUnselectedImage(underQTL);
    }

    @Override
    public Color getColor(int line, int marker) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getColor();
    }

    @Override
    public int getModel() {
        return 11;
    }

    public String toString() {
        return RB.getString((String)"gui.Actions.vizColorMagic");
    }

    @Override
    public String getDescription() {
        return RB.getString((String)"gui.visualization.colors.MagicColorScheme");
    }

    @Override
    public ArrayList<ColorScheme.ColorSummary> getColorSummaries() {
        ArrayList<ColorScheme.ColorSummary> summaries = new ArrayList<ColorScheme.ColorSummary>();
        summaries.add(new ColorScheme.ColorSummary(Prefs.visColorMagic1, RB.getString((String)"gui.visualization.colors.MagicColorScheme.parent1")));
        summaries.add(new ColorScheme.ColorSummary(Prefs.visColorMagic2, RB.getString((String)"gui.visualization.colors.MagicColorScheme.parent2")));
        summaries.add(new ColorScheme.ColorSummary(Prefs.visColorMagic3, RB.getString((String)"gui.visualization.colors.MagicColorScheme.parent3")));
        summaries.add(new ColorScheme.ColorSummary(Prefs.visColorMagic4, RB.getString((String)"gui.visualization.colors.MagicColorScheme.parent4")));
        summaries.add(new ColorScheme.ColorSummary(Prefs.visColorMagic5, RB.getString((String)"gui.visualization.colors.MagicColorScheme.parent5")));
        summaries.add(new ColorScheme.ColorSummary(Prefs.visColorMagic6, RB.getString((String)"gui.visualization.colors.MagicColorScheme.parent6")));
        summaries.add(new ColorScheme.ColorSummary(Prefs.visColorMagic7, RB.getString((String)"gui.visualization.colors.MagicColorScheme.parent7")));
        summaries.add(new ColorScheme.ColorSummary(Prefs.visColorMagic8, RB.getString((String)"gui.visualization.colors.MagicColorScheme.parent8")));
        summaries.add(new ColorScheme.ColorSummary(Prefs.visColorNucleotideOther, RB.getString((String)"gui.visualization.colors.NucleotideColorScheme.other")));
        return summaries;
    }

    @Override
    public void setColorSummaries(ArrayList<ColorScheme.ColorSummary> colors) {
        Prefs.visColorMagic1 = colors.get((int)0).color;
        Prefs.visColorMagic2 = colors.get((int)1).color;
        Prefs.visColorMagic3 = colors.get((int)2).color;
        Prefs.visColorMagic4 = colors.get((int)3).color;
        Prefs.visColorMagic5 = colors.get((int)4).color;
        Prefs.visColorMagic6 = colors.get((int)5).color;
        Prefs.visColorMagic7 = colors.get((int)6).color;
        Prefs.visColorMagic8 = colors.get((int)7).color;
        Prefs.visColorNucleotideOther = colors.get((int)8).color;
    }
}

